/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.util;

public class Complex
implements Cloneable {
    private double re;
    private double im;

    public Complex() {
        this(0.0, 0.0);
    }

    public Complex(double real) {
        this(real, 0.0);
    }

    public Complex(double real, double imag) {
        this.re = real;
        this.im = imag;
    }

    public Complex assign(Complex right) {
        if (this != right) {
            this.re = right.re;
            this.im = right.im;
        }
        return this;
    }

    public double real() {
        return this.re;
    }

    public double imag() {
        return this.im;
    }

    public Complex add(Complex right) {
        this.re += right.re;
        this.im += right.im;
        return this;
    }

    public static Complex add(Complex c1, Complex c2) {
        return new Complex(c1.re + c2.re, c1.im + c2.im);
    }

    public Complex sub(Complex right) {
        this.re -= right.re;
        this.im -= right.im;
        return this;
    }

    public static Complex sub(Complex c1, Complex c2) {
        return new Complex(c1.re - c2.re, c1.im - c2.im);
    }

    public Complex mul(Complex right) {
        double tmp1 = this.re * right.re - this.im * right.im;
        double tmp2 = this.re * right.im + this.im * right.re;
        this.re = tmp1;
        this.im = tmp2;
        return this;
    }

    public static Complex mul(Complex c1, Complex c2) {
        return new Complex(c1.re * c2.re - c1.im * c2.im, c1.re * c2.im + c1.im * c2.re);
    }

    public Complex div(Complex right) {
        double tmp1 = (this.re * right.re + this.im * right.im) / (right.re * right.re + right.im * right.im);
        double tmp2 = (this.im * right.re - this.re * right.im) / (right.re * right.re + right.im * right.im);
        this.re = tmp1;
        this.im = tmp2;
        return this;
    }

    public static Complex div(Complex c1, Complex c2) {
        return new Complex((c1.re * c2.re + c1.im * c2.im) / (c2.re * c2.re + c2.im * c2.im), (c1.im * c2.re - c1.re * c2.im) / (c2.re * c2.re + c2.im * c2.im));
    }

    public Complex clone() {
        try {
            return (Complex)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer().append(this.re);
        if (this.im > 0.0) {
            sb.append('+');
        }
        return sb.append(this.im).append('i').toString();
    }
}

