/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.util;

import com.spss.ac.acmath.util.ContFunction;

public class NumIntegration {
    private double eps = 1.0E-8;
    private int maxDoublings = 5;
    private int nDoublings = 0;
    private int nSubIntInit = 10;
    private int nSubInt = 0;
    private ContFunction fun = null;
    private double sum1 = 0.0;
    private double sum2 = 0.0;
    private double sum4 = 0.0;
    private double sum4Prev = 0.0;
    private double integral = 0.0;
    private double integralPrev = 0.0;
    private double error = Double.MAX_VALUE;
    private double h = 0.0;
    private double left = 0.0;
    private double right = 0.0;

    public NumIntegration() {
    }

    public NumIntegration(double eps, int maxDoublings, int nSubIntInit, ContFunction fun) {
        this.eps = eps;
        this.maxDoublings = maxDoublings;
        this.nSubIntInit = nSubIntInit;
        this.fun = fun;
    }

    public void setParams(double eps, int maxDoublings, int nSubIntInit) {
        this.eps = eps;
        this.maxDoublings = maxDoublings;
        this.nSubIntInit = nSubIntInit;
        this.reset();
    }

    public void setFunction(ContFunction fun) {
        this.fun = fun;
        this.reset();
    }

    public void reset() {
        this.nDoublings = 0;
        this.nSubInt = this.nSubIntInit;
        this.error = Double.MAX_VALUE;
    }

    public double initialize() {
        int i;
        this.reset();
        this.h = (this.right - this.left) / (double)this.nSubInt;
        double step = this.h * 2.0;
        this.sum1 = this.fun.eval(this.left) + this.fun.eval(this.right);
        this.sum4 = 0.0;
        double x = this.left + this.h;
        for (i = 1; i < this.nSubInt; i += 2) {
            this.sum4 += this.fun.eval(x);
            x += step;
        }
        this.sum2 = 0.0;
        x = this.left + step;
        for (i = 2; i < this.nSubInt; i += 2) {
            this.sum2 += this.fun.eval(x);
            x += step;
        }
        this.integral = (this.sum1 + this.sum4 * 4.0 + this.sum2 * 2.0) * this.h / 3.0;
        return this.integral;
    }

    public double doubleNSubInt() {
        this.sum4Prev = this.sum4;
        this.integralPrev = this.integral;
        ++this.nDoublings;
        this.nSubInt *= 2;
        double hPrev = this.h;
        this.h /= 2.0;
        this.sum4 = 0.0;
        double x = this.left + this.h;
        for (int i = 1; i < this.nSubInt; i += 2) {
            this.sum4 += this.fun.eval(x);
            x += hPrev;
        }
        this.sum2 += this.sum4Prev;
        this.integral = (this.sum1 + 4.0 * this.sum4 + 2.0 * this.sum2) * this.h / 3.0;
        this.error = Math.abs(this.integral - this.integralPrev);
        return this.integral;
    }

    public double estimate(double left, double right) {
        this.left = left;
        this.right = right;
        double integral = this.initialize();
        while (this.nDoublings < this.maxDoublings && this.error > this.eps) {
            integral = this.doubleNSubInt();
        }
        return integral;
    }
}

