/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.util;

import com.spss.ac.acmath.util.ContFunction;
import com.spss.ac.acmath.util.NumIntegration;

public class NumIntegrationInfBound {
    private double epsInfBound = 1.0E-6;
    private double expansionFactor = 1.5;
    private double maxNExpansions = 20.0;
    private double rightBound = Double.POSITIVE_INFINITY;
    private NumIntegration niFinite = null;
    private int nExpansions = 0;
    private double integralLast = 0.0;
    private double leftCur = 0.0;
    private double rightCur = 0.0;
    private double error = Double.MAX_VALUE;
    private double lastIntegral;

    public NumIntegrationInfBound() {
        this.niFinite = new NumIntegration();
    }

    public NumIntegrationInfBound(double epsInfBound, double expansionFactor, int maxNExpansions, double epsFinite, int maxDoublings, int nSubsInit, ContFunction fun) {
        this.epsInfBound = epsInfBound;
        this.expansionFactor = expansionFactor;
        this.maxNExpansions = maxNExpansions;
        this.niFinite = new NumIntegration(epsFinite, maxDoublings, nSubsInit, fun);
    }

    public void setInfParams(double epsInfBound, double expansionFactor, int maxNExpansions) {
        this.epsInfBound = epsInfBound;
        this.expansionFactor = expansionFactor;
        this.maxNExpansions = maxNExpansions;
    }

    public void setRightBound(double rightBound) {
        this.rightBound = rightBound;
    }

    public void setFiniteParams(double epsFinite, int maxDoublings, int nSubsInit) {
        this.niFinite.setParams(epsFinite, maxDoublings, nSubsInit);
    }

    public void setFunction(ContFunction fun) {
        this.niFinite.setFunction(fun);
    }

    public double estimate(double left, double rightInit) {
        this.leftCur = left;
        this.rightCur = rightInit;
        this.nExpansions = 0;
        this.lastIntegral = this.integralLast = this.niFinite.estimate(this.leftCur, this.rightCur);
        this.error = this.integralLast;
        while ((double)this.nExpansions < this.maxNExpansions && this.error > this.epsInfBound && this.rightCur < this.rightBound) {
            double length = this.rightCur - this.leftCur;
            ++this.nExpansions;
            this.leftCur = this.rightCur;
            this.rightCur += (length *= this.expansionFactor);
            this.error = this.niFinite.estimate(this.leftCur, this.rightCur);
            this.lastIntegral = this.integralLast;
            this.integralLast += this.error;
        }
        return this.integralLast;
    }

    public int getNExpansions() {
        return this.nExpansions;
    }

    public double getEstError() {
        return this.error;
    }

    public double getLastIntegral() {
        return this.lastIntegral;
    }
}

