/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.util;

import com.spss.ac.acbase.annotation.FromCppClass;
import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.math.random.MCRNGUTwister;
import com.spss.utilities.i18n.LocMsgId;
import java.util.Arrays;

@FromCppClass(value="CFNoRepSampler")
class Sampler {
    private MCRNGUTwister randGen;
    private double totalSize = 0.0;
    private double sampleSize;
    private double selected;
    private double processed;
    private double samplePercent;
    double[] partitionWeights = new double[2];

    public Sampler(double seed, double totalSize, double sampleSize) {
        if (totalSize < 1.0 || totalSize != Math.floor(totalSize) || sampleSize < 0.0 || sampleSize != Math.floor(sampleSize) || sampleSize > totalSize) {
            throw new ACException((LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
        this.totalSize = totalSize;
        this.sampleSize = sampleSize;
        this.randGen = new MCRNGUTwister(seed);
    }

    public Sampler(double seed, double samplePercent) {
        if (samplePercent < 0.0 || samplePercent > 1.0) {
            throw new ACException((LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
        this.samplePercent = samplePercent;
        this.randGen = new MCRNGUTwister(seed);
    }

    public double[] getWeights(double freqWeight) {
        Arrays.fill(this.partitionWeights, 0.0);
        if (freqWeight >= 1.0) {
            if (this.totalSize > 0.0) {
                double stillToProcess;
                double stillToSelect = this.sampleSize - this.selected;
                if (stillToSelect > 0.0) {
                    long f = (long)freqWeight;
                    while (f-- > 0L && stillToSelect > 0.0) {
                        double u01 = this.randGen.nextDouble();
                        if ((this.totalSize - this.processed) * u01 < stillToSelect) {
                            this.partitionWeights[0] = this.partitionWeights[0] + 1.0;
                            this.selected += 1.0;
                            stillToSelect -= 1.0;
                        } else {
                            this.partitionWeights[1] = this.partitionWeights[1] + 1.0;
                        }
                        this.processed += 1.0;
                    }
                    if (stillToSelect == 0.0) {
                        freqWeight -= this.partitionWeights[0] + this.partitionWeights[1];
                    }
                }
                if (stillToSelect == 0.0 && (stillToProcess = this.totalSize - this.processed) > 0.0) {
                    if (stillToProcess < (freqWeight = Math.floor(freqWeight))) {
                        freqWeight = stillToProcess;
                    }
                    this.partitionWeights[1] = this.partitionWeights[1] + freqWeight;
                    this.processed += freqWeight;
                }
            } else {
                long f = (long)freqWeight;
                while (f-- > 0L) {
                    double u01 = this.randGen.nextDouble();
                    if (u01 < this.samplePercent) {
                        this.partitionWeights[0] = this.partitionWeights[0] + 1.0;
                        this.selected += 1.0;
                    } else {
                        this.partitionWeights[1] = this.partitionWeights[1] + 1.0;
                    }
                    this.processed += 1.0;
                }
            }
        }
        return this.partitionWeights;
    }

    public boolean isSampleFilled() {
        return this.totalSize == 0.0 || this.sampleSize <= this.selected;
    }
}

