/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.util;

import com.spss.ac.accode.ACException;
import com.spss.ac.accode.i18n.ACMessages;
import com.spss.ac.acmath.util.Sampler;
import com.spss.utilities.i18n.LocMsgId;
import java.util.Arrays;
import java.util.Random;

public class StratifiedTwoWayInnerPartition {
    private Sampler[] sampler = null;
    private double randomSeed = 0.0;
    private double totalCount = 0.0;
    private boolean bContinues = false;
    private boolean allTraining = false;
    private boolean allTesting = false;
    private double[] partitionWeights = new double[2];

    public StratifiedTwoWayInnerPartition(double seed, double totalFreqCount, double[] tgtCatFreqCounts, int training_percentage) {
        boolean vaild = true;
        Arrays.fill(this.partitionWeights, 0.0);
        if (0 < training_percentage && training_percentage < 100) {
            this.totalCount = Math.floor(totalFreqCount);
            this.randomSeed = seed;
            if (Math.abs(this.randomSeed) < 1.0) {
                this.randomSeed = Math.floor(this.randomSeed * 1000000.0);
            }
            Random rand = new Random((long)this.randomSeed);
            double trainPercent = (double)training_percentage / 100.0;
            if (tgtCatFreqCounts == null || tgtCatFreqCounts.length == 1) {
                this.bContinues = true;
                this.sampler = new Sampler[1];
                double sampleCount = trainPercent * this.totalCount;
                double sampleCountReal = Math.floor(sampleCount);
                double leftCount = sampleCount - sampleCountReal;
                if (leftCount != 0.0) {
                    Sampler leftSample = new Sampler(rand.nextLong(), leftCount);
                    double[] wgtCnt = leftSample.getWeights(1.0);
                    sampleCountReal += wgtCnt[0];
                }
                this.sampler[0] = new Sampler(rand.nextLong(), this.totalCount, sampleCountReal);
            } else {
                this.bContinues = false;
                this.sampler = new Sampler[tgtCatFreqCounts.length];
                double catCount = 0.0;
                for (int i = 0; i < tgtCatFreqCounts.length; ++i) {
                    double catFreq = Math.floor(tgtCatFreqCounts[i]);
                    if (catFreq <= 0.0) {
                        vaild = false;
                    }
                    catCount += catFreq;
                    double sampleCount = trainPercent * catFreq;
                    double sampleCountReal = Math.floor(trainPercent * catFreq);
                    double leftCount = sampleCount - sampleCountReal;
                    if (leftCount != 0.0) {
                        Sampler leftSample = new Sampler(rand.nextLong(), leftCount);
                        double[] wgtCnt = leftSample.getWeights(1.0);
                        sampleCountReal += wgtCnt[0];
                    }
                    if (catFreq == 1.0) {
                        sampleCountReal = trainPercent >= 0.5 ? 1.0 : 0.0;
                    }
                    this.sampler[i] = new Sampler(rand.nextLong(), catFreq, sampleCountReal);
                }
                if (this.totalCount < catCount) {
                    vaild = false;
                }
            }
        } else if (training_percentage == 100) {
            this.allTraining = true;
            this.partitionWeights[0] = 1.0;
        } else if (training_percentage == 0) {
            this.allTesting = true;
            this.partitionWeights[1] = 1.0;
        } else {
            vaild = false;
        }
        if (!vaild) {
            throw new ACException((LocMsgId)ACMessages.INTERNAL_ERROR, new Object[0]);
        }
    }

    public double[] getPartitionWeights(double value, double freqWeight) {
        if (!this.allTraining && !this.allTesting) {
            if (this.bContinues) {
                if (freqWeight >= 1.0) {
                    return this.sampler[0].getWeights(freqWeight);
                }
            } else {
                int catInd = (int)value;
                if (freqWeight >= 1.0 && catInd < this.sampler.length) {
                    return this.sampler[catInd].getWeights(freqWeight);
                }
            }
        }
        return this.partitionWeights;
    }
}

