/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;

public class TopNKeeper<T> {
    protected int maxSize;
    protected PriorityQueue<T> container;

    public TopNKeeper(int maxSize, final Comparator<T> comparator) {
        this.maxSize = maxSize = Math.max(maxSize, 1);
        this.container = new PriorityQueue(maxSize, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return -comparator.compare(o1, o2);
            }
        });
    }

    public void update(T value) {
        if (this.container.size() < this.maxSize) {
            this.container.add(value);
        } else {
            T frontValue = this.container.peek();
            if (this.container.comparator().compare(value, frontValue) > 0) {
                this.container.poll();
                this.container.add(value);
            }
        }
    }

    public int size() {
        return this.container.size();
    }

    public List<T> getAll() {
        ArrayList<T> list = new ArrayList<T>();
        Iterator<T> it = this.container.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        Collections.sort(list, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return -TopNKeeper.this.container.comparator().compare(o1, o2);
            }
        });
        return list;
    }
}

