/*
 * Decompiled with CFR 0.152.
 */
package com.spss.ac.acmath.util;

import com.spss.ac.acmath.util.ContFunction;

public class Uniroot {
    ContFunction fun = null;
    double tol = 1.0E-8;

    public Uniroot(ContFunction fun, double tol) {
        this.fun = fun;
        this.tol = tol;
    }

    public Uniroot(ContFunction fun) {
        this(fun, 1.0E-8);
    }

    public double findRoot(double a, double b) {
        if (this.fun.eval(a) * this.fun.eval(b) > 0.0) {
            return Double.NaN;
        }
        if (Math.abs(this.fun.eval(a)) < Math.abs(this.fun.eval(b))) {
            double temp = a;
            a = b;
            b = temp;
        }
        double c = a;
        boolean mFlag = true;
        double s = Double.MAX_VALUE;
        double d = Double.MAX_VALUE;
        double delta = this.tol;
        double f_a = this.fun.eval(a);
        double f_b = this.fun.eval(b);
        double f_c = f_a;
        double f_s = Double.MAX_VALUE;
        while (Math.abs(f_b) > this.tol && Math.abs(f_s) > this.tol && Math.abs(b - a) > this.tol) {
            s = f_a != f_c && f_b != f_c ? a * f_b * f_c / (f_a - f_b) / (f_a - f_c) + b * f_a * f_c / (f_b - f_a) / (f_b - f_c) * c * f_a * f_b / (f_c - f_a) / (f_c - f_b) : b - f_b * (b - a) / (f_b - f_a);
            if (this.condition1((3.0 * a + b) / 4.0, b, s) || this.condition2(mFlag, s, b, c) || this.condition3(mFlag, s, b, c, d) || this.condition4(mFlag, b, c, delta) || this.condition5(mFlag, c, d, delta)) {
                s = (a + b) / 2.0;
                mFlag = true;
            } else {
                mFlag = false;
            }
            f_s = this.fun.eval(s);
            d = c;
            c = b;
            if (f_a * f_s < 0.0) {
                b = s;
            } else {
                a = s;
            }
            if (Math.abs(f_a) < Math.abs(f_b)) {
                double temp = a;
                a = b;
                b = temp;
            }
            f_a = this.fun.eval(a);
            f_b = this.fun.eval(b);
            f_c = this.fun.eval(c);
        }
        if (Math.abs(f_b) <= this.tol || Math.abs(b - a) <= this.tol) {
            return b;
        }
        return s;
    }

    private boolean condition1(double v1, double v2, double v) {
        boolean notBetween = true;
        if (v1 > v2) {
            double temp = v1;
            v1 = v2;
            v2 = temp;
        }
        notBetween = !(v >= v1 && v < v2 || v > v1 && v <= v2);
        return notBetween;
    }

    private boolean condition2(boolean mFlag, double s, double b, double c) {
        boolean result = false;
        if (mFlag) {
            result = Math.abs(s - b) >= Math.abs(b - c) / 2.0;
        }
        return result;
    }

    private boolean condition3(boolean mFlag, double s, double b, double c, double d) {
        boolean result = false;
        if (!mFlag) {
            result = Math.abs(s - b) >= Math.abs(c - d) / 2.0;
        }
        return result;
    }

    private boolean condition4(boolean mFlag, double b, double c, double delta) {
        boolean result = false;
        if (mFlag) {
            result = Math.abs(b - c) < Math.abs(delta);
        }
        return result;
    }

    private boolean condition5(boolean mFlag, double c, double d, double delta) {
        boolean result = false;
        if (!mFlag) {
            result = Math.abs(c - d) < Math.abs(delta);
        }
        return result;
    }
}

