/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore;

import com.ibm.bi.predict.data.DataContext;
import com.ibm.bi.predict.data.DataPrep;
import com.ibm.bi.predict.data.StandardDataPrep;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.explore.ExploreContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;

public class ExploreDataPrep {
    private ExploreDataPrep() {
    }

    public static DataPrep prepareData(DataAccessProvider provider, ExploreContext context) {
        return StandardDataPrep.prepareData((DataAccessProvider)provider, (DataContext)context, Optional.empty(), (int[])ExploreDataPrep.getDriversIndexes(provider, context));
    }

    private static int[] getDriversIndexes(DataAccessProvider provider, ExploreContext context) {
        HashSet<String> drivers = new HashSet<String>();
        String target = context.getString("target", null);
        if (target != null) {
            drivers.add(target);
        }
        drivers.addAll(context.getStringList("explore-params.candidates", new ArrayList()));
        int[] driversIndex = drivers.stream().map(field -> ExploreDataPrep.findIndex(provider, field)).mapToInt(Integer::intValue).toArray();
        return driversIndex;
    }

    private static int findIndex(DataAccessProvider provider, String fieldName) {
        MetaData meta = provider.getMetaData();
        for (int i = 0; i < meta.fieldCount(); ++i) {
            if (!fieldName.equals(meta.getFieldIdentifier(i))) continue;
            return i;
        }
        throw new BadParametersException(fieldName + " isn't a valid data field name.");
    }
}

