/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore;

import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.explore.ExploreConfig;
import com.ibm.bi.predict.explore.ExploreParams;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;

public class ExploreParamsParser {
    public static final String REQUESTID = "requestId";
    public static final String VERSION = "version";
    public static final String LOCALE = "locale";
    public static final String TARGET = "target";
    public static final String CANDIDATES = "candidates";
    public static final String GROUPINGS = "groupings";
    public static final String ID = "id";
    public static final String GROUPS = "groups";
    public static final String MEMBERS = "members";
    public static final String MAXRELATIONSHIPS = "maxRelationships";
    public static final String MINSTRENGTH = "minStrength";
    public static final String SAMPLEDDATA = "sampledData";
    public static final String REQUESTEDITEMCOUNT = "requestedItemCount";

    private ExploreParamsParser() {
    }

    public static ExploreParams parse(JSONObject obj, ExploreConfig config) {
        String version = ExploreParamsParser.getRequiredString(obj, VERSION);
        String requestId = ExploreParamsParser.getOptionalString(obj, REQUESTID);
        String locale = ExploreParamsParser.getOptionalString(obj, LOCALE);
        String target = ExploreParamsParser.getOptionalString(obj, TARGET);
        List<String> candidates = ExploreParamsParser.getStringArray(obj, CANDIDATES);
        List<ExploreParams.Grouping> groupings = ExploreParamsParser.getGroupings(obj);
        boolean sampledData = ExploreParamsParser.getOptionalBoolean(obj, SAMPLEDDATA, false);
        int nnv = ExploreParamsParser.getOptionalInt(obj, REQUESTEDITEMCOUNT, -1);
        Optional<Integer> nnodes = nnv <= 0 ? Optional.empty() : Optional.of(nnv);
        int maxRelationships = ExploreParamsParser.getOptionalInt(obj, MAXRELATIONSHIPS, config.maxNumberRelationships());
        double minStrength = ExploreParamsParser.getOptionalDouble(obj, MINSTRENGTH, config.minimumRelationshipStrength());
        config.maxNumberRelationships(maxRelationships);
        config.minimumRelationshipStrength(minStrength);
        return new ExploreParams(version, requestId, locale, target, candidates, groupings, sampledData, nnodes);
    }

    private static List<ExploreParams.Grouping> getGroupings(JSONObject obj) {
        JSONArray array = ExploreParamsParser.getRequiredJSONArray(obj, GROUPINGS);
        int n = array.length();
        ArrayList<ExploreParams.Grouping> result = new ArrayList<ExploreParams.Grouping>();
        for (int i = 0; i < n; ++i) {
            JSONObject entry = ExploreParamsParser.getRequiredJSONObject(array, i, GROUPINGS);
            String id = ExploreParamsParser.getRequiredString(entry, ID);
            List<ExploreParams.Group> groups = ExploreParamsParser.getGroups(entry);
            result.add(new ExploreParams.Grouping(id, groups));
        }
        return result;
    }

    private static List<ExploreParams.Group> getGroups(JSONObject obj) {
        JSONArray array = ExploreParamsParser.getRequiredJSONArray(obj, GROUPS);
        int n = array.length();
        ArrayList<ExploreParams.Group> result = new ArrayList<ExploreParams.Group>();
        for (int i = 0; i < n; ++i) {
            JSONObject entry = ExploreParamsParser.getRequiredJSONObject(array, i, GROUPS);
            String id = ExploreParamsParser.getRequiredString(entry, ID);
            List<String> members = ExploreParamsParser.getStringArray(entry, MEMBERS);
            result.add(new ExploreParams.Group(id, members));
        }
        return result;
    }

    private static JSONArray getRequiredJSONArray(JSONObject obj, String key) {
        try {
            return obj.getJSONArray(key);
        }
        catch (Exception e) {
            throw new BadParametersException("Required field '" + key + "' missing or not JSONArray", (Throwable)e);
        }
    }

    private static JSONObject getRequiredJSONObject(JSONArray array, int i, String key) {
        try {
            return array.getJSONObject(i);
        }
        catch (Exception e) {
            throw new BadParametersException("Entry " + i + " in field '" + key + "' missing or not JSONObject", (Throwable)e);
        }
    }

    private static String getRequiredString(JSONObject obj, String key) {
        try {
            return ExploreParamsParser.asString(obj.get(key));
        }
        catch (Exception e) {
            throw new BadParametersException("Required field '" + key + "' missing or not string", (Throwable)e);
        }
    }

    private static String getOptionalString(JSONObject obj, String key) {
        try {
            Object o = obj.opt(key);
            if (o == null) {
                return null;
            }
            return (String)o;
        }
        catch (Exception e) {
            throw new BadParametersException("Optional field '" + key + "' not string", (Throwable)e);
        }
    }

    private static int getOptionalInt(JSONObject obj, String key, int defaultValue) {
        return obj.optInt(key, defaultValue);
    }

    private static boolean getOptionalBoolean(JSONObject obj, String key, boolean defaultValue) {
        return obj.optBoolean(key, defaultValue);
    }

    private static double getOptionalDouble(JSONObject obj, String key, double defaultValue) {
        return obj.optDouble(key, defaultValue);
    }

    private static List<String> getStringArray(JSONObject obj, String key) {
        JSONArray array;
        try {
            array = obj.getJSONArray(key);
        }
        catch (Exception e) {
            throw new BadParametersException("Required field '" + key + "' missing or not array", (Throwable)e);
        }
        int n = array.length();
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            try {
                result.add(ExploreParamsParser.asString(array.get(i)));
                continue;
            }
            catch (Exception e) {
                throw new BadParametersException("Field '" + key + "' entry " + i + " missing or not string", (Throwable)e);
            }
        }
        return result;
    }

    private static String asString(Object o) {
        if (o == null) {
            throw new BadParametersException("object is null");
        }
        return (String)o;
    }
}

