/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.provider.TextProvider;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.json.JSONObject;

public class RequestCreator {
    private RequestCreator() {
    }

    public static Request create(JSONObject tree, Locale locale) {
        HashMap contents = new HashMap();
        contents.put(JSONObject.class, tree);
        ChartInsightsContext context = new ChartInsightsContext();
        context.setTree(tree);
        contents.put(ChartInsightsContext.class, (Object)((Object)context));
        RequestCreator.addLocaleAndTextProviderToMap(locale, contents);
        return Request.create(contents);
    }

    public static Request create(DataAccessProvider provider, ChartInsightsContext params, Locale locale) {
        HashMap contents = new HashMap();
        contents.put(DataAccessProvider.class, provider);
        contents.put(ChartInsightsContext.class, (Object)((Object)params));
        RequestCreator.addLocaleAndTextProviderToMap(locale, contents);
        return Request.create(contents);
    }

    public static Request derive(Request original, JSONObject tree) {
        HashMap contents = new HashMap();
        contents.put(JSONObject.class, tree);
        ChartInsightsContext context = new ChartInsightsContext();
        context.setTree(tree);
        contents.put(ChartInsightsContext.class, (Object)((Object)context));
        RequestCreator.addOriginalRequestToMap(original, contents);
        return Request.create(contents);
    }

    public static Request derive(Request original, DataAccessProvider provider, ChartInsightsContext params) {
        HashMap contents = new HashMap();
        contents.put(DataAccessProvider.class, provider);
        contents.put(ChartInsightsContext.class, (Object)((Object)params));
        contents.put(Request.class, original);
        RequestCreator.addOriginalRequestToMap(original, contents);
        return Request.create(contents);
    }

    private static void addLocaleAndTextProviderToMap(Locale locale, Map<Class<?>, Object> contents) {
        Locale l = locale == null ? Locale.getDefault() : locale;
        contents.put(Locale.class, l);
        contents.put(TextProvider.class, new TextProvider(l));
    }

    private static void addOriginalRequestToMap(Request original, Map<Class<?>, Object> contents) {
        contents.put(Request.class, original);
        contents.put(Locale.class, original.get(Locale.class));
        contents.put(TextProvider.class, original.get(TextProvider.class));
    }
}

