/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.changepoint;

import com.ibm.bi.predict.explore.changepoint.RegressionFitMeasure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class ChangePointAnalysis {
    private final int n;
    private double beta;
    private double[] values;

    public ChangePointAnalysis(double[] values) {
        this.values = values;
        this.n = values.length;
        RegressionFitMeasure overall = new RegressionFitMeasure(values);
        this.beta = (double)(2 * overall.parameters().length) * Math.log(this.n);
    }

    public int[] run() {
        double[] F = new double[this.n];
        TreeSet<Integer> cp = new TreeSet<Integer>();
        double[] scores = new double[this.n];
        F[0] = -this.beta;
        ArrayList<Integer> R = new ArrayList<Integer>();
        R.add(0);
        for (int t = 1; t < this.n; ++t) {
            double minScore = Double.POSITIVE_INFINITY;
            int minIndex = -1;
            Iterator iterator = R.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                scores[i] = F[i] + this.C(i + 1, t) + this.beta;
                if (!(scores[i] < minScore)) continue;
                minIndex = i;
                minScore = scores[i];
            }
            F[t] = minScore;
            cp.add(minIndex);
            Iterator it = R.iterator();
            while (it.hasNext()) {
                Integer i = (Integer)it.next();
                if (!(scores[i] > F[t])) continue;
                it.remove();
            }
            R.add(t);
        }
        cp.remove(0);
        return this.asIntArray(cp);
    }

    private int[] asIntArray(Collection<Integer> list) {
        return list.stream().mapToInt(i -> i - 1).sorted().toArray();
    }

    private double C(int start, int end) {
        if (end - start < 3) {
            return 0.0;
        }
        double[] data = Arrays.copyOfRange(this.values, start - 1, end);
        double v = new RegressionFitMeasure(data).fitError();
        return Math.max(v, 0.0);
    }
}

