/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.data;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.ChartInsightsContextFactory;
import com.ibm.bi.predict.explore.RequestCreator;
import com.ibm.bi.predict.explore.data.DataAccessProviderBuilder;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.types.RoleType;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ChartInsightsBuilder {
    final DataAccessProviderBuilder builder = new DataAccessProviderBuilder();
    final Map<String, RoleType> roleMap = new HashMap<String, RoleType>();
    boolean skipSAinsights = false;
    Request originalRequest = null;

    public DataAccessProviderBuilder getDataBuilder() {
        return this.builder;
    }

    public void addField(String role, String fieldId, String fieldLabel, String type, double[] data) {
        this.addField(role, fieldId, fieldLabel, type, null, 0, data);
    }

    public void addField(String role, String fieldId, String fieldLabel, String type, String agg, double[] data) {
        this.addField(role, fieldId, fieldLabel, type, agg, 0, data);
    }

    public void addField(String role, String fieldId, String fieldLabel, String type, int ncats, double[] data) {
        this.addField(role, fieldId, fieldLabel, type, null, ncats, data);
    }

    public void addField(String role, String fieldId, String fieldLabel, String type, String agg, int ncats, double[] data) {
        this.builder.addField(fieldId).label(fieldLabel).type(FieldType.fromString((String)type)).aggregation(AggregationType.fromString((String)agg)).categories(ncats).data(data);
        this.roleMap.put(fieldId, RoleType.fromString((String)role));
    }

    public void addField(String role, String fieldId, String fieldLabel, String type, List<String> data) {
        String[] labels = data.toArray(new String[0]);
        double[] doubles = data.stream().mapToDouble(a -> data.indexOf(a)).toArray();
        this.builder.addField(fieldId).label(fieldLabel).type(FieldType.fromString((String)type)).aggregation(null).categories(labels).data(doubles);
        this.roleMap.put(fieldId, RoleType.fromString((String)role));
    }

    public void addStat(String statName, String fieldId, double[] data) {
        this.builder.getField(fieldId).statistic(statName, data);
    }

    public void setDerivedData(Request original) {
        this.originalRequest = original;
    }

    public void setSkipSAinsights(boolean skipSAinsights) {
        this.skipSAinsights = skipSAinsights;
    }

    public Request getServiceParams() {
        return this.getServiceParams(Locale.ENGLISH);
    }

    public Request getServiceParams(Locale locale) {
        return this.originalRequest == null ? RequestCreator.create(this.getProvider(), this.getParams(), locale) : RequestCreator.derive(this.originalRequest, this.getProvider(), this.getParams());
    }

    public ChartInsightsContext getParams() {
        return ChartInsightsContextFactory.create(this.roleMap, !this.skipSAinsights);
    }

    public DataAccessProvider getProvider() {
        return this.builder.makeProvider();
    }
}

