/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.data;

import com.ibm.bi.predict.explore.data.RecordingDecorator;
import java.util.ArrayList;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class CoefficientsFinder {
    private CoefficientsFinder() {
    }

    public static double[] find(RecordingDecorator.Deco deco) {
        ArrayList<Double> betas = new ArrayList<Double>();
        try {
            JSONArray fitArray = (JSONArray)JSON.parse((String)deco.value.toString());
            JSONObject fit = fitArray.getJSONObject(0);
            String[] betaNames = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "end-marker"};
            int i = 0;
            String name = betaNames[i];
            while (fit.has(name)) {
                String beta = fit.getString(name);
                betas.add(Double.parseDouble(beta));
                name = betaNames[++i];
            }
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("No coefficients array found", e);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number found in coefficients array", e);
        }
        return betas.stream().mapToDouble(d -> d).toArray();
    }
}

