/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt;

import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.ProcessorResults;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.provider.TextProvider;
import com.ibm.bi.predict.service.PredictServiceResponse;
import java.util.Collection;
import java.util.List;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ChartInsights
extends ProcessorResults<ChartInsight>
implements PredictServiceResponse {
    public static final String VERSION_KEY = "version";
    public static final String CURRENT_VERSION = "1.0";
    public static final String INSIGHTS_KEY = "insights";
    public static final String STATE_KEY = "state";
    public static final String ERRORS_KEY = "errors";
    public static final String WARNINGS_KEY = "warnings";
    public static final String INSIGHTS_SUCCESS = "INSIGHTS_SUCCESS";
    public static final String INSIGHTS_ERROR = "INSIGHTS_ERROR";
    public static final String INSIGHTS_WARNING = "INSIGHTS_WARNING";
    private final Request request;

    public ChartInsights(ProcessorResults<ChartInsight> insights, Request request) {
        this.merge(insights);
        this.request = request;
    }

    public ChartInsights(Request request) {
        this.request = request;
    }

    public List<ChartInsight> getInsights() {
        return this.content();
    }

    public void add(ChartInsight insight) {
        this.content().add(insight);
    }

    private String getState() {
        String msgKey = !this.errorMessages().isEmpty() && this.content().isEmpty() ? INSIGHTS_ERROR : (!this.errorMessages().isEmpty() && !this.content().isEmpty() ? INSIGHTS_WARNING : INSIGHTS_SUCCESS);
        TextProvider provider = this.request.get(TextProvider.class);
        return provider.humanize(msgKey, new Object[0]);
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put(VERSION_KEY, (Object)CURRENT_VERSION);
        obj.put(STATE_KEY, (Object)this.getState());
        JSONArray errorsArr = new JSONArray();
        errorsArr.addAll(this.errorMessages());
        obj.put(ERRORS_KEY, (Collection)errorsArr);
        JSONArray warningsArr = new JSONArray();
        warningsArr.addAll(this.warningMessages());
        obj.put(WARNINGS_KEY, (Collection)warningsArr);
        JSONArray a = new JSONArray();
        for (ChartInsight i : this.content()) {
            a.add((Object)i.toJSON());
        }
        obj.put(INSIGHTS_KEY, (Collection)a);
        return obj;
    }

    public JSONObject getResponseBody() throws JSONException {
        return this.toJSON();
    }
}

