/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.deriveddata.detectors;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.nlt.deriveddata.detectors.DerivedDataDetector;
import com.ibm.bi.predict.explore.nlt.deriveddata.operations.ChangeAggregationOperation;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.types.RoleType;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ChangeAggregationDetector
extends DerivedDataDetector {
    @Override
    public List<Operation<Request>> detectOperation(Request request) {
        ChartInsightsContext params;
        if (!request.has(DataAccessProvider.class)) {
            return Collections.emptyList();
        }
        MetaData metadata = request.get(DataAccessProvider.class).getMetaData();
        List<Integer> respFields = this.getResponseFields(metadata, params = request.get(ChartInsightsContext.class));
        if (respFields.isEmpty()) {
            return Collections.emptyList();
        }
        List<Integer> inputFields = this.getInputFields(metadata, params);
        Optional<Integer> weight = this.getWeightField(metadata, params);
        return respFields.stream().map(responseIndex -> metadata.getFieldAggregation(responseIndex.intValue()) == AggregationType.SUM ? ChangeAggregationOperation.sumToAvg(request, responseIndex, inputFields, weight) : ChangeAggregationOperation.avgToSum(request, responseIndex, inputFields, weight)).collect(Collectors.toList());
    }

    @Override
    public boolean isSuitableResponse(MetaData metadata, ChartInsightsContext params, int idx) {
        AggregationType aggType = metadata.getFieldAggregation(idx);
        return params.getRole(metadata.getFieldIdentifier(idx)) == RoleType.RESPONSE && metadata.getFieldType(idx) == FieldType.NUMERICAL && (aggType == AggregationType.SUM || aggType == AggregationType.AVERAGE) && metadata.getStatisticStatus("rowCount", idx) == StatisticStatus.AVAILABLE;
    }
}

