/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.deriveddata.operations;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.ChartInsightsContextFactory;
import com.ibm.bi.predict.explore.RequestCreator;
import com.ibm.bi.predict.explore.data.DataAccessProviderBuilder;
import com.ibm.bi.predict.explore.nlt.deriveddata.operations.DerivedDataOperation;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.types.RoleType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class ChangeAggregationOperation
extends DerivedDataOperation {
    private final int response;
    private final int[] inputs;
    private final Optional<Integer> weightIndex;
    private final AggregationType aggType;
    private final ConvertFunc convertFunc;
    private final boolean hasRowCount;
    private final boolean hasSumSqr;
    private final double[] responseValues;
    private final double[] responseRowCounts;
    private final double[] responseSumSqr;
    private final double[] weightValues;
    private final double[][] inputValues;
    private int currentRow;
    private static final String ROWCOUNT = "rowCount";
    private static final String SUMSQR = "sumSqr";

    public ChangeAggregationOperation(Request request, int response, List<Integer> inputs, Optional<Integer> weightIndex, AggregationType aggType, ConvertFunc convertFunc) {
        super(request);
        this.response = response;
        int ninputs = inputs.size();
        this.inputs = new int[ninputs];
        for (int i = 0; i < ninputs; ++i) {
            this.inputs[i] = inputs.get(i);
        }
        this.weightIndex = weightIndex;
        this.aggType = aggType;
        this.convertFunc = convertFunc;
        MetaData meta = request.get(DataAccessProvider.class).getMetaData();
        this.hasRowCount = meta.getStatisticStatus(ROWCOUNT, response) == StatisticStatus.AVAILABLE;
        this.hasSumSqr = meta.getStatisticStatus(SUMSQR, response) == StatisticStatus.AVAILABLE;
        int nrows = meta.rowCount();
        this.responseValues = new double[nrows];
        this.responseRowCounts = new double[nrows];
        this.responseSumSqr = new double[nrows];
        this.inputValues = new double[ninputs][nrows];
        this.weightValues = weightIndex.isPresent() ? new double[nrows] : null;
    }

    public int getResponseIndex() {
        return this.response;
    }

    @Override
    public Operation<Request> preUpdate() {
        this.currentRow = 0;
        return this;
    }

    @Override
    public Operation<Request> update(DataRow row) {
        double rc = this.hasRowCount ? row.getStatistic(ROWCOUNT, this.response) : 1.0;
        this.responseValues[this.currentRow] = this.convertFunc.apply(row.getValue(this.response), rc);
        this.responseRowCounts[this.currentRow] = rc;
        if (this.hasSumSqr) {
            this.responseSumSqr[this.currentRow] = row.getStatistic(SUMSQR, this.response);
        }
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputValues[i][this.currentRow] = row.getValue(this.inputs[i]);
        }
        this.weightIndex.ifPresent(wgt -> {
            this.weightValues[this.currentRow] = this.convertFunc.apply(row.getValue(wgt.intValue()), rc);
        });
        ++this.currentRow;
        return this;
    }

    @Override
    public List<Request> getResults() {
        MetaData metadata = this.request.get(DataAccessProvider.class).getMetaData();
        ChartInsightsContext params = this.request.get(ChartInsightsContext.class);
        DataAccessProviderBuilder builder = new DataAccessProviderBuilder();
        HashMap<String, RoleType> roles = new HashMap<String, RoleType>();
        String id = metadata.getFieldIdentifier(this.response);
        DataAccessProviderBuilder.FieldBuilder fbuilder = builder.addField(id).label(metadata.getFieldDisplayLabel(this.response)).type(metadata.getFieldType(this.response)).aggregation(this.aggType).data(this.responseValues).statistic(ROWCOUNT, this.responseRowCounts);
        if (this.hasSumSqr) {
            fbuilder.statistic(SUMSQR, this.responseSumSqr);
        }
        roles.put(id, params.getRole(id));
        for (int i = 0; i < this.inputs.length; ++i) {
            int inputIndex = this.inputs[i];
            id = metadata.getFieldIdentifier(inputIndex);
            builder.addField(id).label(metadata.getFieldDisplayLabel(inputIndex)).type(metadata.getFieldType(inputIndex)).categories(this.getCategoryLabels(metadata, inputIndex)).data(this.inputValues[i]);
            roles.put(id, this.getInputRole(metadata, params, inputIndex));
        }
        this.weightIndex.ifPresent(wgt -> {
            String idx = metadata.getFieldIdentifier(wgt.intValue());
            builder.addField(idx).label(metadata.getFieldDisplayLabel(wgt.intValue())).type(metadata.getFieldType(wgt.intValue())).data(this.weightValues);
            roles.put(idx, params.getRole(idx));
        });
        return Collections.singletonList(RequestCreator.derive(this.request, builder.makeProvider(), ChartInsightsContextFactory.create(roles, params.doSmartAnnotations())));
    }

    public static ChangeAggregationOperation sumToAvg(Request request, int response, List<Integer> inputs, Optional<Integer> weightIndex) {
        return new ChangeAggregationOperation(request, response, inputs, weightIndex, AggregationType.AVERAGE, (value, rowcount) -> !NumericUtils.equals((double)rowcount, (double)0.0) ? value / rowcount : value);
    }

    public static ChangeAggregationOperation avgToSum(Request request, int response, List<Integer> inputs, Optional<Integer> weightIndex) {
        return new ChangeAggregationOperation(request, response, inputs, weightIndex, AggregationType.SUM, (value, rowcount) -> value * rowcount);
    }

    @FunctionalInterface
    public static interface ConvertFunc {
        public double apply(double var1, double var3);
    }
}

