/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.slf4j.Logger;

public class ProcessorResults<T> {
    private final Map<Level, List<String>> messages = new HashMap<Level, List<String>>();
    private final List<T> content = new ArrayList<T>();

    public ProcessorResults<T> addAll(Collection<? extends T> items) {
        this.content.addAll(items);
        return this;
    }

    public ProcessorResults<T> addError(String message, Throwable throwable, Logger logger) {
        if (logger != null) {
            if (throwable == null) {
                logger.error(message);
            } else {
                logger.error(message, throwable);
            }
        }
        if (throwable != null && throwable.getMessage() != null) {
            return this.addError(message + ": " + throwable.getMessage());
        }
        return this.addError(message);
    }

    public ProcessorResults<T> addError(String message) {
        this.messages.computeIfAbsent(Level.ERROR, lvl -> new ArrayList()).add(message);
        return this;
    }

    public <S> ProcessorResults<T> addMessagesFrom(ProcessorResults<S> other) {
        other.messages.forEach((k, v) -> this.messages.computeIfAbsent((Level)k, o -> new ArrayList()).addAll(v));
        return this;
    }

    public ProcessorResults<T> addWarning(String message, Logger logger) {
        if (logger != null) {
            logger.warn(message);
        }
        return this.addWarning(message);
    }

    public ProcessorResults<T> addWarning(String message) {
        this.messages.computeIfAbsent(Level.WARN, lvl -> new ArrayList()).add(message);
        return this;
    }

    public List<T> content() {
        return this.content;
    }

    public List<String> errorMessages() {
        return this.messages.getOrDefault(Level.ERROR, Collections.emptyList());
    }

    public ProcessorResults<T> merge(ProcessorResults<T> other) {
        return this.addMessagesFrom(other).addAll(other.content);
    }

    public ProcessorResults<T> replaceContent(List<T> newContent) {
        if (newContent == this.content) {
            return this;
        }
        this.content.clear();
        return this.addAll(newContent);
    }

    public List<String> warningMessages() {
        return this.messages.getOrDefault(Level.WARN, Collections.emptyList());
    }
}

