/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.framework;

import com.ibm.bi.predict.explore.nlt.framework.RequestProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;

public class Request
implements RequestProvider {
    private final Map<Class<?>, Object> contents;

    public Request(Map<Class<?>, Object> contents) {
        this.contents = new HashMap(contents);
        for (Map.Entry<Class<?>, Object> entry : contents.entrySet()) {
            Class<?> k = entry.getKey();
            Object v = entry.getValue();
            if (v == null) {
                throw new IllegalArgumentException("Cannot store null values for type: " + k);
            }
            if (!k.isInstance(v)) {
                throw new IllegalArgumentException(v + " is not an instance of " + k);
            }
            this.contents.put(k, v);
        }
    }

    @Override
    public Request getRequest() {
        return this;
    }

    public <T> T get(Class<? extends T> type) {
        return this.getOpt(type).orElseThrow(() -> new NoSuchElementException("Expected content not present: " + type));
    }

    public boolean has(Class<?> type) {
        return this.getOpt(type).isPresent();
    }

    public <T> Optional<T> getOpt(Class<? extends T> type) {
        return Optional.ofNullable(this.contents.get(type));
    }

    public static Request create(Map<Class<?>, Object> contents) {
        return new Request(contents);
    }

    public boolean isOriginal() {
        return !this.contents.containsKey(Request.class);
    }

    public boolean isDerived() {
        return this.contents.containsKey(Request.class);
    }

    public Map<Class<?>, Object> getContents() {
        return this.contents;
    }

    public Request original() {
        Request r = this;
        while (r.isDerived()) {
            r = r.get(Request.class);
        }
        return r;
    }
}

