/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.OperationType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;

public class InsightSemantics {
    private final OperationType functionType;
    private final String responseField;
    private final Set<String> fieldsUsedInCalculation;
    private final Set<String> fieldsUsedInDescription;
    private final Set<String> categoriesDefined;

    private InsightSemantics(OperationType funcType, String responseField, String[] fieldsUsedInCalculation, String[] fieldsUsedInDescription) {
        this.functionType = funcType == null ? OperationType.UNIQUE : funcType;
        this.responseField = responseField;
        this.fieldsUsedInCalculation = new LinkedHashSet<String>(Arrays.asList(fieldsUsedInCalculation));
        this.fieldsUsedInDescription = new LinkedHashSet<String>(Arrays.asList(fieldsUsedInDescription));
        this.categoriesDefined = Collections.emptySet();
        this.fieldsUsedInCalculation.remove(responseField);
        this.fieldsUsedInDescription.removeAll(this.fieldsUsedInCalculation);
        this.fieldsUsedInDescription.remove(responseField);
    }

    private InsightSemantics(OperationType functionType, String responseField, Set<String> fieldsUsedInCalculation, Set<String> fieldsUsedInDescription, Set<String> categoriesDefined) {
        this.functionType = functionType;
        this.responseField = responseField;
        this.fieldsUsedInCalculation = fieldsUsedInCalculation;
        this.categoriesDefined = categoriesDefined;
        this.fieldsUsedInDescription = fieldsUsedInDescription;
    }

    public Set<String> categoriesDefined() {
        return this.categoriesDefined;
    }

    public OperationType functionType() {
        return this.functionType;
    }

    public String responseField() {
        return this.responseField;
    }

    public Set<String> fieldsUsedInCalculation() {
        return this.fieldsUsedInCalculation;
    }

    public Set<String> fieldsUsedInDescription() {
        return this.fieldsUsedInDescription;
    }

    public static InsightSemantics makeFor(OperationType funcType, String responseField, String[] fieldsUsedInCalculation, String ... fieldsUsedInDescription) {
        return new InsightSemantics(funcType, responseField, fieldsUsedInCalculation, fieldsUsedInDescription);
    }

    public static InsightSemantics empty() {
        return InsightSemantics.makeFor(OperationType.UNIQUE, "", new String[0], new String[0]);
    }

    public static BiPredicate<InsightSemantics, InsightSemantics> subsumeFunctionGivenRequest(Request request) {
        Request original = InsightSemantics.getOriginal(request);
        Optional<MetaData> optMeta = InsightSemantics.getMetaDataFrom(original);
        MetaData metaData = optMeta.orElse(null);
        return (a, b) -> a.subsumes((InsightSemantics)b, metaData);
    }

    static Request getOriginal(Request request) {
        return request.getOpt(Request.class).map(InsightSemantics::getOriginal).orElse(request);
    }

    private static Optional<MetaData> getMetaDataFrom(Request request) {
        Optional<MetaData> optMeta = request.getOpt(MetaData.class);
        if (!optMeta.isPresent()) {
            optMeta = request.getOpt(DataAccessProvider.class).map(DataAccessProvider::getMetaData);
        }
        return optMeta;
    }

    public InsightSemantics withCategories(Collection<String> categories) {
        return new InsightSemantics(this.functionType, this.responseField, this.fieldsUsedInCalculation, this.fieldsUsedInDescription, new LinkedHashSet<String>(categories));
    }

    public InsightSemantics withExplanatoryIndices(List<Integer> explanatoryIndices, MetaData meta) {
        String[] usedIDs = (String[])explanatoryIndices.stream().map(arg_0 -> ((MetaData)meta).getFieldIdentifier(arg_0)).toArray(String[]::new);
        String[] descr = this.fieldsUsedInDescription.toArray(new String[this.fieldsUsedInDescription.size()]);
        return new InsightSemantics(this.functionType, this.responseField, usedIDs, descr);
    }

    private boolean subsumes(InsightSemantics other, MetaData metaData) {
        OperationType otherFunctionType = other.functionType;
        if (!this.functionType.comparableBases(otherFunctionType)) {
            return false;
        }
        if (!Objects.equals(this.responseField, other.responseField)) {
            return false;
        }
        if (!this.fieldsUsedInCalculation.equals(other.fieldsUsedInCalculation)) {
            return false;
        }
        if (this.functionType.aggregation() != otherFunctionType.aggregation()) {
            AggregationType fromMeta = this.getAggregationFromMeta(metaData);
            return this.functionType.aggregation() == fromMeta;
        }
        return this.hasMoreImportantFields(other, metaData);
    }

    private boolean hasMoreImportantFields(InsightSemantics other, MetaData metaData) {
        for (int i = 0; i < metaData.fieldCount(); ++i) {
            boolean containedInTheirs;
            String name = metaData.getFieldIdentifier(i);
            boolean containedInMine = this.fieldsUsedInDescription.contains(name);
            if (containedInMine == (containedInTheirs = other.fieldsUsedInDescription.contains(name))) continue;
            return containedInMine;
        }
        return true;
    }

    private AggregationType getAggregationFromMeta(MetaData metaData) {
        if (this.responseField == null) {
            return AggregationType.NONE;
        }
        for (int i = 0; i < metaData.fieldCount(); ++i) {
            if (!this.responseField.equals(metaData.getFieldIdentifier(i))) continue;
            return metaData.getFieldAggregation(i);
        }
        return AggregationType.NONE;
    }

    public String toString() {
        String descriptives = this.fieldsUsedInDescription.isEmpty() ? "" : "-labeledWith-" + this.fieldsUsedInDescription;
        return this.functionType + "(" + this.responseField + " using " + this.fieldsUsedInCalculation + ")" + descriptives;
    }
}

