/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.detectors;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.detectors.InsightsDetector;
import com.ibm.bi.predict.explore.nlt.insights.operations.CountByExplanatoryOperation;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CountByExplanatoryDetector
extends InsightsDetector {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(CountByExplanatoryDetector.class);

    @Override
    public List<Operation<ChartInsight>> detectOperation(Request request) {
        ChartInsightsContext params;
        if (!this.isBasicInsightRequest(request)) {
            return NONE;
        }
        MetaData metaData = request.get(DataAccessProvider.class).getMetaData();
        List<Integer> responseIndexes = this.getResponseIndexes(metaData, params = request.get(ChartInsightsContext.class));
        if (responseIndexes.isEmpty()) {
            return Collections.emptyList();
        }
        int responseIndex = responseIndexes.get(0);
        List<Integer> expFields = this.getCategoricalExplanatoryIndexes(metaData, params);
        List<Integer> explanatoryFieldList = this.getExplanatoryIndexesWithMoreThanOneCategory(metaData, expFields);
        if (explanatoryFieldList.isEmpty()) {
            return Collections.emptyList();
        }
        LOGGER.debug(String.format("Detected CountByExplanatory operation with responseIndex = [%s] and explanatory fields = %s", responseIndex, explanatoryFieldList.toString()));
        return Arrays.asList(new CountByExplanatoryOperation(request, explanatoryFieldList, responseIndex));
    }

    @Override
    protected boolean isSuitableResponseField(int idx, MetaData metaData) {
        return metaData.getStatisticStatus("rowCount", idx) == StatisticStatus.AVAILABLE;
    }
}

