/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.detectors;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.detectors.InsightsDetector;
import com.ibm.bi.predict.explore.nlt.insights.operations.RangeOperation;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class RangeDetector
extends InsightsDetector {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(RangeDetector.class);

    @Override
    public List<Operation<ChartInsight>> detectOperation(Request request) {
        ChartInsightsContext params;
        if (!request.has(DataAccessProvider.class)) {
            return NONE;
        }
        MetaData metadata = request.get(DataAccessProvider.class).getMetaData();
        List<Integer> responseIndexes = this.getResponseIndexes(metadata, params = request.get(ChartInsightsContext.class));
        if (responseIndexes.isEmpty()) {
            return Collections.emptyList();
        }
        List<Integer> explanatoryIndexes = this.getCategoricalExplanatoryIndexes(metadata, params);
        if (explanatoryIndexes.isEmpty()) {
            return Collections.emptyList();
        }
        LOGGER.debug(String.format("Detected range operation with responseIndex = %s and explanatoryIndexes = %s", responseIndexes.toString(), explanatoryIndexes.toString()));
        return responseIndexes.stream().map(idx -> new RangeOperation(request, (int)idx, explanatoryIndexes)).collect(Collectors.toList());
    }

    @Override
    protected boolean isSuitableResponseField(int idx, MetaData metadata) {
        return metadata.getFieldAggregation(idx) != AggregationType.COUNT && metadata.getFieldAggregation(idx) != AggregationType.COUNT_DISTINCT;
    }
}

