/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.detectors;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.detectors.InsightsDetector;
import com.ibm.bi.predict.explore.nlt.insights.operations.SmartAnnotationOperation;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Arrays;
import java.util.List;

public class SmartAnnotationDetector
extends InsightsDetector {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(SmartAnnotationDetector.class);

    @Override
    public List<Operation<ChartInsight>> detectOperation(Request request) {
        if (!request.has(DataAccessProvider.class)) {
            return NONE;
        }
        MetaData metaData = request.get(DataAccessProvider.class).getMetaData();
        ChartInsightsContext params = request.get(ChartInsightsContext.class);
        if (!params.doSmartAnnotations()) {
            return NONE;
        }
        List<Integer> respFields = this.getResponseIndexes(metaData, params);
        if (respFields.isEmpty()) {
            return NONE;
        }
        int responseIndex = respFields.get(0);
        if (this.isChangedAggregationRequest(request, metaData.getFieldAggregation(responseIndex), metaData.getFieldIdentifier(responseIndex))) {
            return NONE;
        }
        LOGGER.debug("Detected SmartAnnotation operation");
        return Arrays.asList(new SmartAnnotationOperation(request));
    }

    @Override
    protected boolean isSuitableResponseField(int idx, MetaData metaData) {
        return metaData.getStatisticStatus("rowCount", idx) == StatisticStatus.AVAILABLE && metaData.getStatisticStatus("sumSqr", idx) == StatisticStatus.AVAILABLE;
    }
}

