/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.detectors;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.detectors.InsightsDetector;
import com.ibm.bi.predict.explore.nlt.insights.detectors.OverallCountDetector;
import com.ibm.bi.predict.explore.nlt.insights.operations.OverallAverageOperation;
import com.ibm.bi.predict.explore.nlt.insights.operations.OverallSumOperation;
import com.ibm.bi.predict.explore.nlt.insights.operations.SumByExplanatoryOperation;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SumAndAverageDetector
extends InsightsDetector {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(OverallCountDetector.class);

    @Override
    public List<Operation<ChartInsight>> detectOperation(Request request) {
        ChartInsightsContext params;
        if (!this.isBasicInsightRequest(request)) {
            return NONE;
        }
        MetaData metaData = request.get(DataAccessProvider.class).getMetaData();
        List<Integer> respFields = this.getResponseIndexes(metaData, params = request.get(ChartInsightsContext.class));
        if (respFields.size() != 1) {
            return NONE;
        }
        int responseIndex = respFields.get(0);
        return this.getOperationsForOneResponse(request, metaData, params, responseIndex);
    }

    @Override
    protected boolean isSuitableResponseField(int idx, MetaData metaData) {
        AggregationType agg = metaData.getFieldAggregation(idx);
        return agg == AggregationType.SUM || agg == AggregationType.NONE || agg == AggregationType.AVERAGE && metaData.getStatisticStatus("rowCount", idx) == StatisticStatus.AVAILABLE;
    }

    private List<Operation<ChartInsight>> getOperationsForOneResponse(Request request, MetaData metaData, ChartInsightsContext params, int responseIndex) {
        List<Integer> explanatoryForDescriptions;
        boolean hasUsefulExplanatoryFields;
        AggregationType responseAggregation = metaData.getFieldAggregation(responseIndex);
        String responseFieldID = metaData.getFieldIdentifier(responseIndex);
        boolean aggregationWasChanged = this.isChangedAggregationRequest(request, responseAggregation, responseFieldID);
        if (metaData.rowCount() == 1) {
            return NONE;
        }
        if (responseAggregation == AggregationType.SUM && aggregationWasChanged) {
            return NONE;
        }
        List<Integer> expFields = this.getCategoricalExplanatoryIndexes(metaData, params);
        List<Integer> expFieldsWithMoreThanOneCategory = this.getExplanatoryIndexesWithMoreThanOneCategory(metaData, expFields);
        boolean bl = hasUsefulExplanatoryFields = !expFieldsWithMoreThanOneCategory.isEmpty();
        if (metaData.getStatisticStatus("rowCount", responseIndex) != StatisticStatus.AVAILABLE) {
            if (responseAggregation == AggregationType.AVERAGE) {
                return NONE;
            }
            return Collections.singletonList(new OverallSumOperation(request, expFields, responseIndex, false));
        }
        List<Integer> list = explanatoryForDescriptions = hasUsefulExplanatoryFields ? expFields : Collections.emptyList();
        if (responseAggregation == AggregationType.AVERAGE) {
            return Collections.singletonList(new OverallAverageOperation(request, explanatoryForDescriptions, responseIndex, true));
        }
        LOGGER.debug(String.format("Detected overall sum and average operation with responseIndex = [%d], explanatoryFields = %s", responseIndex, expFields));
        ArrayList<Operation<ChartInsight>> result = new ArrayList<Operation<ChartInsight>>();
        result.add(new OverallSumOperation(request, explanatoryForDescriptions, responseIndex, false));
        result.add(new OverallAverageOperation(request, explanatoryForDescriptions, responseIndex, false));
        if (hasUsefulExplanatoryFields) {
            LOGGER.debug(String.format("Detected SumByExplanatory operation with responseIndex = [%d], explanatoryFields = %s", responseIndex, expFieldsWithMoreThanOneCategory));
            result.add(new SumByExplanatoryOperation(request, expFieldsWithMoreThanOneCategory, responseIndex, false));
        }
        return result;
    }
}

