/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.detectors;

import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.detectors.InsightsDetector;
import com.ibm.bi.predict.explore.nlt.insights.operations.TreeOperation;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class TreeDetector
extends InsightsDetector {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(TreeDetector.class);

    @Override
    public List<Operation<ChartInsight>> detectOperation(Request request) {
        if (!request.has(JSONObject.class)) {
            return Collections.emptyList();
        }
        return this.findTreeResults(request.get(JSONObject.class)).stream().map(v -> new TreeOperation(request, (JSONObject)v)).collect(Collectors.toList());
    }

    private List<JSONObject> findTreeResults(JSONObject req) {
        try {
            ArrayList<JSONObject> result = new ArrayList<JSONObject>();
            JSONArray jresults = req.getJSONArray("results");
            int nr = jresults.size();
            for (int i = 0; i < nr; ++i) {
                JSONObject jr = jresults.getJSONObject(i);
                if (!jr.containsKey((Object)"type") || !"TREE".equals(jr.getString("type")) || !jr.containsKey((Object)"fields") || !jr.containsKey((Object)"details")) continue;
                result.add(jr);
            }
            return result;
        }
        catch (JSONException e) {
            LOGGER.debug("Exception finding tree results", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

