/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.operations;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.insights.OperationType;
import com.ibm.bi.predict.explore.nlt.insights.operations.InsightsOperation;
import com.ibm.bi.predict.explore.nlt.math.Range;
import com.ibm.bi.predict.explore.nlt.math.RangeFinder;
import com.ibm.bi.predict.explore.nlt.provider.TextProvider;
import java.util.Collections;
import java.util.List;

public class RangeOperation
extends InsightsOperation {
    public static final String INSIGHT_RANGE = "INSIGHT_RANGE";
    public static final String RANGEOPERATION_NONE = "RANGEOPERATION_NONE";
    public static final String RANGEOPERATION_SUM = "RANGEOPERATION_SUM";
    public static final String RANGEOPERATION_AVERAGE = "RANGEOPERATION_AVERAGE";
    public static final String RANGEOPERATION_MIN = "RANGEOPERATION_MIN";
    public static final String RANGEOPERATION_MAX = "RANGEOPERATION_MAX";
    public static final String RANGEOPERATION_NONE_WITH_EXPLANATORY = "RANGEOPERATION_NONE_WITH_EXPLANATORY";
    public static final String RANGEOPERATION_SUM_WITH_EXPLANATORY = "RANGEOPERATION_SUM_WITH_EXPLANATORY";
    public static final String RANGEOPERATION_AVERAGE_WITH_EXPLANATORY = "RANGEOPERATION_AVERAGE_WITH_EXPLANATORY";
    public static final String RANGEOPERATION_MIN_WITH_EXPLANATORY = "RANGEOPERATION_MIN_WITH_EXPLANATORY";
    public static final String RANGEOPERATION_MAX_WITH_EXPLANATORY = "RANGEOPERATION_MAX_WITH_EXPLANATORY";
    final List<Integer> explanatoryFieldIndexes;
    private final AggregationType aggregation;
    RangeFinder finder;

    public RangeOperation(Request request, int responseIndex, List<Integer> explanatoryFieldIndexes) {
        super(request, responseIndex, true);
        MetaData meta = request.get(DataAccessProvider.class).getMetaData();
        this.explanatoryFieldIndexes = explanatoryFieldIndexes;
        this.aggregation = meta.getFieldAggregation(responseIndex);
    }

    public int getResponseIndex() {
        return this.responseIndex;
    }

    public List<Integer> getInputIndexes() {
        return this.explanatoryFieldIndexes;
    }

    @Override
    protected InsightSemantics makeSemantics() {
        OperationType functionType = new OperationType(OperationType.Base.range, this.aggregation);
        return RangeOperation.makeSemanticsUsingIndices(this.request, functionType, this.responseIndex, Collections.emptyList(), this.explanatoryFieldIndexes);
    }

    public InsightsOperation preUpdate() {
        this.finder = new RangeFinder(this.request.get(DataAccessProvider.class).getMetaData(), this.responseIndex, this.explanatoryFieldIndexes);
        return this;
    }

    public InsightsOperation update(DataRow row) {
        this.finder.update(row);
        return this;
    }

    public InsightsOperation postUpdate() {
        this.finder.postUpdate();
        return this;
    }

    @Override
    public List<ChartInsight> getResults() {
        Range range = this.finder.getRange();
        ChartInsight insight = null;
        if (range.getMinValue().isPresent() && range.getMinValue().get() < range.getMaxValue().get()) {
            TextProvider textProvider = this.request.get(TextProvider.class);
            switch (this.aggregation) {
                case NONE: 
                case SUM: 
                case AVERAGE: {
                    insight = this.makeNonExtremalInsight(textProvider, range);
                    break;
                }
                case MINIMUM: 
                case MAXIMUM: {
                    insight = this.makeExtremalInsight(textProvider, range);
                    break;
                }
            }
        }
        return insight == null ? Collections.emptyList() : Collections.singletonList(insight);
    }

    private ChartInsight makeNonExtremalInsight(TextProvider textProvider, Range range) {
        if (this.explanatoryFieldIndexes.size() == 1) {
            String messageKey = this.aggregation == AggregationType.SUM ? RANGEOPERATION_SUM_WITH_EXPLANATORY : (this.aggregation == AggregationType.AVERAGE ? RANGEOPERATION_AVERAGE_WITH_EXPLANATORY : RANGEOPERATION_NONE_WITH_EXPLANATORY);
            return textProvider.humanize(this.request, INSIGHT_RANGE, messageKey, new Object[]{this.responseLabel, this.fieldLabel(this.explanatoryFieldIndexes.get(0)), range.getMinValue().get(), range.getMinCategories().get(0), range.getMaxValue().get(), range.getMaxCategories().get(0)}, this.semantics());
        }
        String messageKey = this.aggregation == AggregationType.SUM ? RANGEOPERATION_SUM : (this.aggregation == AggregationType.AVERAGE ? RANGEOPERATION_AVERAGE : RANGEOPERATION_NONE);
        return textProvider.humanize(this.request, INSIGHT_RANGE, messageKey, new Object[]{this.responseLabel, range.getMinValue().get(), range.getMaxValue().get()}, this.semantics());
    }

    private ChartInsight makeExtremalInsight(TextProvider textProvider, Range range) {
        double value = 0.0;
        List<Object> cats = Collections.emptyList();
        if (this.aggregation == AggregationType.MINIMUM) {
            value = range.getMinValue().get();
            cats = range.getMinCategories();
        } else if (this.aggregation == AggregationType.MAXIMUM) {
            value = range.getMaxValue().get();
            cats = range.getMaxCategories();
        }
        if (this.explanatoryFieldIndexes.size() == 1) {
            String messageKey = this.aggregation == AggregationType.MINIMUM ? RANGEOPERATION_MIN_WITH_EXPLANATORY : RANGEOPERATION_MAX_WITH_EXPLANATORY;
            return textProvider.humanize(this.request, INSIGHT_RANGE, messageKey, new Object[]{this.responseLabel, value, this.fieldLabel(this.explanatoryFieldIndexes.get(0)), cats.get(0)}, this.semantics());
        }
        String messageKey = this.aggregation == AggregationType.MINIMUM ? RANGEOPERATION_MIN : RANGEOPERATION_MAX;
        return textProvider.humanizeWithList(this.request, INSIGHT_RANGE, messageKey, cats, new Object[]{this.responseLabel, value}, this.semantics());
    }
}

