/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.operations;

import com.ibm.bi.predict.exceptions.InvalidDataException;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.insights.OperationType;
import com.ibm.bi.predict.explore.nlt.insights.operations.InsightsOperation;
import com.ibm.bi.predict.explore.nlt.provider.TextProvider;
import com.ibm.bi.predict.math.NumberFormatter;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class TreeOperation
extends InsightsOperation {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(TreeOperation.class);
    public static final String INSIGHT_TREE_FIELDS = "INSIGHT_TREE_FIELDS";
    public static final String TREE_FIELDS = "TREE_FIELDS";
    public static final String INSIGHT_TREE_MOST_IMPORTANT_FIELD = "INSIGHT_TREE_MOST_IMPORTANT_FIELD";
    public static final String TREE_MOST_IMPORTANT_FIELD_TWO = "TREE_MOST_IMPORTANT_FIELD_TWO";
    public static final String TREE_MOST_IMPORTANT_FIELD_THREE = "TREE_MOST_IMPORTANT_FIELD_THREE";
    public static final String TREE_MOST_IMPORTANT_FIELD_FOUR = "TREE_MOST_IMPORTANT_FIELD_FOUR";
    public static final String TREE_MOST_IMPORTANT_FIELD_FIVE = "TREE_MOST_IMPORTANT_FIELD_FIVE";
    public static final String TREE_MOST_IMPORTANT_FIELD_EIGHT = "TREE_MOST_IMPORTANT_FIELD_EIGHT";
    public static final String TREE_MOST_IMPORTANT_FIELD_TEN = "TREE_MOST_IMPORTANT_FIELD_TEN";
    public static final String INSIGHT_TREE_LEAST_IMPORTANT_FIELD = "INSIGHT_TREE_LEAST_IMPORTANT_FIELD";
    public static final String TREE_LEAST_IMPORTANT_FIELD = "TREE_LEAST_IMPORTANT_FIELD";
    private static final String LABEL = "label";
    private static final String IMPORTANCE = "importance";
    private final JSONObject tree;
    private Optional<String> targetLabel;
    private double accuracy;
    private List<String> inputFieldLabels;
    private Optional<String> mostImportantLabel;
    private double mostImportantMultiplier;
    private Optional<String> leastImportantLabel;
    private double leastImportantImprovement;

    public TreeOperation(Request request, JSONObject tree) {
        super(request, -1, false);
        this.tree = tree;
        this.targetLabel = Optional.empty();
        this.accuracy = 0.0;
        this.inputFieldLabels = new ArrayList<String>();
        this.mostImportantLabel = Optional.empty();
        this.mostImportantMultiplier = 0.0;
        this.leastImportantLabel = Optional.empty();
        this.leastImportantImprovement = 0.0;
    }

    public JSONObject getTree() {
        return this.tree;
    }

    public InsightsOperation preUpdate() {
        LOGGER.debug("Generating tree insights");
        this.targetLabel = Optional.empty();
        try {
            JSONObject fields = this.tree.getJSONObject("fields");
            JSONArray inputs = fields.getJSONArray("inputs");
            this.getInputFields(inputs);
            this.getMostImportantInsightInformation(inputs);
            this.getLeastImportantInsightInformation(inputs);
            this.getAccuracyAndTargetLabel(fields);
        }
        catch (JSONException e) {
            LOGGER.warn("Exception processing FPD tree result for insights", (Throwable)e);
            throw new InvalidDataException("Exception processing FPD tree result for insights", (Throwable)e);
        }
        return this;
    }

    private void getInputFields(JSONArray inputs) throws JSONException {
        int n = inputs.size();
        for (int i = 0; i < n; ++i) {
            this.inputFieldLabels.add(inputs.getJSONObject(i).getString(LABEL));
        }
    }

    @Override
    protected InsightSemantics makeSemantics() {
        String[] explanatoryLabels = this.inputFieldLabels.toArray(new String[this.inputFieldLabels.size()]);
        return InsightSemantics.makeFor(OperationType.UNIQUE, this.targetLabel.orElse(null), explanatoryLabels, new String[0]);
    }

    private void getMostImportantInsightInformation(JSONArray inputs) throws JSONException {
        if (inputs.size() > 1) {
            JSONObject first = inputs.getJSONObject(0);
            double mostImportantAccuracy = first.getDouble(IMPORTANCE);
            double secondMostImportantAccuracy = inputs.getJSONObject(1).getDouble(IMPORTANCE);
            this.mostImportantMultiplier = mostImportantAccuracy / secondMostImportantAccuracy;
            if (this.mostImportantMultiplier >= 2.0) {
                this.mostImportantLabel = Optional.of(first.getString(LABEL));
            }
        }
    }

    private void getLeastImportantInsightInformation(JSONArray inputs) throws JSONException {
        if (inputs.size() > 1) {
            JSONObject last = inputs.getJSONObject(inputs.size() - 1);
            this.leastImportantImprovement = last.getDouble(IMPORTANCE);
            if (this.leastImportantImprovement < 0.001) {
                this.leastImportantLabel = Optional.of(last.getString(LABEL));
            }
        }
    }

    private void getAccuracyAndTargetLabel(JSONObject fields) throws JSONException {
        this.accuracy = this.tree.getDouble("accuracy");
        this.targetLabel = Optional.of(fields.getJSONObject("target").getString(LABEL));
    }

    @Override
    public List<ChartInsight> getResults() {
        ArrayList<ChartInsight> result = new ArrayList<ChartInsight>();
        if (this.targetLabel.isPresent()) {
            String percent;
            TextProvider textProvider = this.request.get(TextProvider.class);
            if (!this.inputFieldLabels.isEmpty()) {
                percent = TreeOperation.asPercent(this.locale, this.accuracy);
                result.add(textProvider.humanizeWithList(this.request, INSIGHT_TREE_FIELDS, TREE_FIELDS, this.inputFieldLabels, new Object[]{this.targetLabel.get(), percent}, this.semantics()));
            }
            if (this.mostImportantLabel.isPresent()) {
                result.add(textProvider.humanize(this.request, INSIGHT_TREE_MOST_IMPORTANT_FIELD, this.getMultiplierMessage(), new Object[]{this.mostImportantLabel.get(), this.targetLabel.get()}, this.semantics()));
            }
            if (this.leastImportantLabel.isPresent()) {
                percent = TreeOperation.asPercent(this.locale, this.leastImportantImprovement);
                result.add(textProvider.humanize(this.request, INSIGHT_TREE_LEAST_IMPORTANT_FIELD, TREE_LEAST_IMPORTANT_FIELD, new Object[]{this.leastImportantLabel.get(), this.targetLabel.get(), percent}, this.semantics()));
            }
        }
        return result;
    }

    static String asPercent(Locale locale, double v) {
        double p = v * 100.0;
        if (p < 0.1) {
            return "<" + NumberFormatter.formatAsPercent((Locale)locale, (double)0.1);
        }
        return NumberFormatter.formatAsPercent((Locale)locale, (double)p);
    }

    private String getMultiplierMessage() {
        if (this.mostImportantMultiplier >= 10.0) {
            return TREE_MOST_IMPORTANT_FIELD_TEN;
        }
        if (this.mostImportantMultiplier >= 8.0) {
            return TREE_MOST_IMPORTANT_FIELD_EIGHT;
        }
        if (this.mostImportantMultiplier >= 5.0) {
            return TREE_MOST_IMPORTANT_FIELD_FIVE;
        }
        if (this.mostImportantMultiplier >= 4.0) {
            return TREE_MOST_IMPORTANT_FIELD_FOUR;
        }
        if (this.mostImportantMultiplier >= 3.0) {
            return TREE_MOST_IMPORTANT_FIELD_THREE;
        }
        return TREE_MOST_IMPORTANT_FIELD_TWO;
    }
}

