/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.operations;

import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.operations.InsightsOperation;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.math.PickNAlgorithm;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.StatUtils;

public abstract class XByExplanatoryOperation
extends InsightsOperation {
    private static final int MAX_N = 5;
    protected final List<Integer> explanatoryFieldIndices;
    protected final List<XByExplanatoryField> listForTextGeneration;
    private Map<Integer, XByExplanatoryField> countMap;
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(XByExplanatoryOperation.class);

    protected XByExplanatoryOperation(Request request, List<Integer> explanatoryFieldIndices, int responseIndex) {
        super(request, responseIndex, true);
        this.explanatoryFieldIndices = explanatoryFieldIndices;
        this.listForTextGeneration = new ArrayList<XByExplanatoryField>();
    }

    Map<Integer, XByExplanatoryField> getCountMap() {
        return this.countMap;
    }

    List<XByExplanatoryField> getListForTextGeneration() {
        return this.listForTextGeneration;
    }

    public InsightsOperation preUpdate() {
        this.countMap = new HashMap<Integer, XByExplanatoryField>();
        this.explanatoryFieldIndices.forEach(explanatoryFieldIndex -> {
            XByExplanatoryField xByExplanatoryField = new XByExplanatoryField((int)explanatoryFieldIndex);
            this.countMap.put((Integer)explanatoryFieldIndex, xByExplanatoryField);
        });
        return this;
    }

    public InsightsOperation update(DataRow row) {
        this.explanatoryFieldIndices.forEach(explanatoryFieldIndex -> this.updateField((int)explanatoryFieldIndex, row));
        return this;
    }

    private void updateField(int explanatoryFieldIndex, DataRow row) {
        XByExplanatoryField xByExplanatoryField = this.countMap.get(explanatoryFieldIndex);
        Double explanatoryCategoryIndexAsDouble = row.getValue(explanatoryFieldIndex);
        if (Double.isNaN(explanatoryCategoryIndexAsDouble)) {
            return;
        }
        double countValue = this.getResponseValue(row);
        if (Double.isNaN(countValue)) {
            return;
        }
        int explanatoryCategoryIndex = explanatoryCategoryIndexAsDouble.intValue();
        String categoryLabel = this.getFieldCategoryLabel(explanatoryFieldIndex, explanatoryCategoryIndex);
        Map<String, Double> categoryCounts = xByExplanatoryField.getCategoryCounts();
        if (categoryCounts.containsKey(categoryLabel)) {
            countValue += categoryCounts.get(categoryLabel).doubleValue();
        }
        categoryCounts.put(categoryLabel, countValue);
    }

    private String getFieldCategoryLabel(int fieldIndex, int categoryIndex) {
        try {
            return this.meta.getFieldCategoryLabel(fieldIndex, categoryIndex);
        }
        catch (Exception e) {
            LOGGER.debug("Some metadata providers to not support getFieldIdentifier, so build one.", (Throwable)e);
            return this.meta.getFieldDisplayLabel(fieldIndex) + "_CAT" + categoryIndex;
        }
    }

    abstract double getResponseValue(DataRow var1);

    public InsightsOperation postUpdate() {
        this.countMap.values().forEach(countByExplanatoryField -> {
            LinkedHashMap sortedMap = countByExplanatoryField.getCategoryCounts().entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            countByExplanatoryField.setCategoryCounts(sortedMap);
            this.callPickNAlgorithm((XByExplanatoryField)countByExplanatoryField);
            if (countByExplanatoryField.isValid) {
                this.listForTextGeneration.add((XByExplanatoryField)countByExplanatoryField);
            }
        });
        return this;
    }

    private void callPickNAlgorithm(XByExplanatoryField field) {
        double[] counts = field.getCategoryCounts().values().stream().filter(v -> v > 0.0).mapToDouble(Double::doubleValue).toArray();
        if (counts.length > 1) {
            double range = counts[0] - counts[counts.length - 1];
            field.isValid = true;
            int n = NumericUtils.equals((double)0.0, (double)range) ? 0 : PickNAlgorithm.pickTopN((double[])counts, (int)5);
            double sumOfN = StatUtils.sum((double[])counts, (int)0, (int)n);
            double sumTotal = StatUtils.sum((double[])counts);
            double percentage = sumOfN / sumTotal * 100.0;
            field.setN(n);
            field.setSumOfN(sumOfN);
            field.setPercentageOfN(percentage);
            ArrayList<String> allCategoryLabels = new ArrayList<String>(field.getCategoryCounts().keySet());
            List<String> nCategoryLabels = allCategoryLabels.subList(0, n);
            field.setNCategoryLabels(nCategoryLabels);
        } else {
            field.isValid = false;
        }
    }

    public static class XByExplanatoryField {
        boolean isValid = false;
        double sumOfN;
        double percentageOfN;
        List<String> nCategoryLabels;
        final int explanatoryIndex;
        int n;
        Map<String, Double> categoryCounts;

        XByExplanatoryField(int explanatoryIndex) {
            this.explanatoryIndex = explanatoryIndex;
            this.categoryCounts = new HashMap<String, Double>();
        }

        public double getSumOfN() {
            return this.sumOfN;
        }

        public double getPercentageOfN() {
            return this.percentageOfN;
        }

        public int getExplanatoryIndex() {
            return this.explanatoryIndex;
        }

        public Map<String, Double> getCategoryCounts() {
            return this.categoryCounts;
        }

        public void setCategoryCounts(Map<String, Double> categoryCounts) {
            this.categoryCounts = categoryCounts;
        }

        public void setSumOfN(double sumOfN) {
            this.sumOfN = sumOfN;
        }

        public void setPercentageOfN(double percentageOfN) {
            this.percentageOfN = percentageOfN;
        }

        public List<String> getNCategoryLabels() {
            return this.nCategoryLabels;
        }

        public List<Double> getNCategoryPercentages() {
            double sum = this.categoryCounts.values().stream().mapToDouble(Number::doubleValue).sum();
            return this.nCategoryLabels.stream().map(v -> 100.0 * this.categoryCounts.get(v) / sum).collect(Collectors.toList());
        }

        public void setNCategoryLabels(List<String> nCategoryLabels) {
            this.nCategoryLabels = nCategoryLabels;
        }

        public void setN(int n) {
            this.n = n;
        }

        public int getN() {
            return this.n;
        }
    }
}

