/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.math;

import com.ibm.bi.predict.explore.nlt.math.CriticalPoint;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.analysis.solvers.LaguerreSolver;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.exception.NoDataException;

public class CriticalPointsFinder {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(CriticalPointsFinder.class);

    public List<CriticalPoint> findExtrema(double[] coefficients, int columnIndex, String explanatoryName) {
        ArrayList<CriticalPoint> results = new ArrayList<CriticalPoint>();
        try {
            Complex[] extremaXs;
            PolynomialFunction poly = new PolynomialFunction(coefficients);
            PolynomialFunction derivative = poly.polynomialDerivative();
            double[] derCoeffs = derivative.getCoefficients();
            LaguerreSolver solver = new LaguerreSolver();
            for (Complex extremaX : extremaXs = solver.solveAllComplex(derCoeffs, 0.0)) {
                double i = extremaX.getImaginary();
                if (NumericUtils.equals((double)i, (double)0.0)) {
                    CriticalPoint ex = this.buildExtrema(poly, extremaX, columnIndex, explanatoryName);
                    results.add(ex);
                    continue;
                }
                LOGGER.debug("found imaginary result");
            }
        }
        catch (NoDataException e) {
            LOGGER.debug("No solutions found by solver", (Throwable)e);
        }
        return results;
    }

    private CriticalPoint buildExtrema(PolynomialFunction poly, Complex extremaX, int columnIndex, String explanatoryName) {
        double x = extremaX.getReal();
        double y = poly.value(x);
        double y2 = poly.value(x + 0.1);
        CriticalPoint.CriticalPointType direction = y2 > y ? CriticalPoint.CriticalPointType.MIN : CriticalPoint.CriticalPointType.MAX;
        return new CriticalPoint(x, y, direction, columnIndex, explanatoryName);
    }
}

