/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.provider;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.data.RecordingDecorator;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.insights.OperationType;
import com.ibm.bi.predict.explore.nlt.provider.TextProvider;
import com.ibm.bi.predict.types.RoleType;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class PredictiveStrengthComparisonProvider {
    public static final String INSIGHT_PREDICTIVE_STRENGTH_COMPARISON = "INSIGHT_PREDICTIVE_STRENGTH_COMPARISON";
    public static final String NO_EFFECT = "PREDICTIVE_STRENGTH_COMPARISON_NO_EFFECT";
    public static final String ONE_SIGNIFICANT = "PREDICTIVE_STRENGTH_COMPARISON_ONE_SIGNIFICANT";
    public static final String TWO_SIGNIFICANT_STRONGLY = "PREDICTIVE_STRENGTH_COMPARISON_TWO_SIGNIFICANT_STRONGLY";
    public static final String TWO_SIGNIFICANT_MODERATELY = "PREDICTIVE_STRENGTH_COMPARISON_TWO_SIGNIFICANT_MODERATELY";
    public static final String TWO_SIGNIFICANT_WEAKLY = "PREDICTIVE_STRENGTH_COMPARISON_TWO_SIGNIFICANT_WEAKLY";
    private static final double STRONG_CUTOFF = 0.66;
    private static final double MODERATE_CUTOFF = 0.33;
    private static final double WEAK_CUTOFF = 0.1;
    private double jointStrength;
    private double[] individualStrength = new double[2];
    private String[] explanatoryFieldIds = new String[2];
    private String[] explanatoryFieldNames = new String[2];
    private String responseFieldId;
    private String responseFieldName;

    public void process(List<ChartInsight> chartInsightList) {
        List<ChartInsight> predictiveStrengthsInsight = chartInsightList.stream().filter(insight -> "PREDICTIVE_STRENGTH".equals(insight.getType())).collect(Collectors.toList());
        if (predictiveStrengthsInsight.size() == 3) {
            HashMap<String, FieldWithStrength> explanatoryStrengthMap = new HashMap<String, FieldWithStrength>();
            predictiveStrengthsInsight.forEach(insight -> {
                Request serviceParam = insight.getParams();
                Optional<RecordingDecorator.Deco> strengthDeco = this.findPredictiveStrengthDeco(serviceParam);
                strengthDeco.ifPresent(deco -> {
                    double strength = Double.parseDouble(deco.value.toString());
                    this.setFieldNameAndStrength(strength, serviceParam, explanatoryStrengthMap);
                });
            });
            if (this.responseFieldId != null && explanatoryStrengthMap.size() == 2) {
                this.sortAndSetExplanatoryAndStrength(explanatoryStrengthMap);
            }
        }
    }

    private void setFieldNameAndStrength(double strength, Request serviceParam, Map<String, FieldWithStrength> explanatoryStrengthMap) {
        ChartInsightsContext param = serviceParam.get(ChartInsightsContext.class);
        Set<String> vars = param.keySet();
        MetaData metaData = serviceParam.get(DataAccessProvider.class).getMetaData();
        List explanatoryFields = vars.stream().filter(var -> param.getRole((String)var) == RoleType.EXPLANATORY).collect(Collectors.toList());
        Optional<String> responseField = vars.stream().filter(var -> param.getRole((String)var) == RoleType.RESPONSE).findFirst();
        if (explanatoryFields.size() == 2) {
            this.jointStrength = strength;
            this.responseFieldId = responseField.get();
            this.responseFieldName = this.getFieldNameForIdentifiers(metaData, this.responseFieldId);
        } else if (explanatoryFields.size() == 1) {
            String fieldId = (String)explanatoryFields.get(0);
            String fieldName = this.getFieldNameForIdentifiers(metaData, fieldId);
            FieldWithStrength fieldWithStrength = new FieldWithStrength(fieldName, strength);
            explanatoryStrengthMap.put((String)explanatoryFields.get(0), fieldWithStrength);
        }
    }

    private String getFieldNameForIdentifiers(MetaData metaData, String fieldIdentifier) {
        for (int i = 0; i < metaData.fieldCount(); ++i) {
            if (!fieldIdentifier.equals(metaData.getFieldIdentifier(i))) continue;
            return metaData.getFieldDisplayLabel(i);
        }
        return fieldIdentifier;
    }

    private Optional<RecordingDecorator.Deco> findPredictiveStrengthDeco(Request serviceParam) {
        RecordingDecorator decorator = (RecordingDecorator)serviceParam.get(DataAccessProvider.class).getDecorator();
        List<RecordingDecorator.Deco> decos = decorator.getCalls();
        return decos.stream().filter(deco -> "predictive_strength".equals(deco.key)).findFirst();
    }

    private void sortAndSetExplanatoryAndStrength(Map<String, FieldWithStrength> explanatoryStrengthMap) {
        Map sortedExplanatoryStrengthMap = explanatoryStrengthMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Collections.reverseOrder())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        int i = 0;
        for (Map.Entry entry : sortedExplanatoryStrengthMap.entrySet()) {
            this.explanatoryFieldIds[i] = (String)entry.getKey();
            FieldWithStrength fieldWithStrength = (FieldWithStrength)entry.getValue();
            this.explanatoryFieldNames[i] = fieldWithStrength.getFieldName();
            this.individualStrength[i] = fieldWithStrength.getStrength();
            ++i;
        }
    }

    public boolean isValid() {
        return this.responseFieldId != null && this.explanatoryFieldIds[0] != null && this.explanatoryFieldIds[1] != null;
    }

    public String getResponseFieldId() {
        return this.responseFieldId;
    }

    public String[] getExplanatoryFieldIds() {
        return this.explanatoryFieldIds;
    }

    public String getResponseFieldName() {
        return this.responseFieldName;
    }

    public String[] getExplanatoryFieldNames() {
        return this.explanatoryFieldNames;
    }

    public String getMessageKey() {
        if (this.isSignificant(this.jointStrength, this.individualStrength[0]) && this.isSignificant(this.jointStrength, this.individualStrength[1])) {
            if (this.isStrong(this.jointStrength, this.individualStrength[0]) && this.isStrong(this.jointStrength, this.individualStrength[1])) {
                return TWO_SIGNIFICANT_STRONGLY;
            }
            if (this.isModerate(this.jointStrength, this.individualStrength[0]) && this.isModerate(this.jointStrength, this.individualStrength[1])) {
                return TWO_SIGNIFICANT_MODERATELY;
            }
            return TWO_SIGNIFICANT_WEAKLY;
        }
        if (!this.isSignificant(this.jointStrength, this.individualStrength[0]) && !this.isSignificant(this.jointStrength, this.individualStrength[1])) {
            return NO_EFFECT;
        }
        return ONE_SIGNIFICANT;
    }

    private boolean isStrong(double a, double b) {
        return Math.abs(a - b) > 0.66;
    }

    private boolean isModerate(double a, double b) {
        return Math.abs(a - b) > 0.33;
    }

    private boolean isSignificant(double a, double b) {
        return Math.abs(a - b) > 0.1;
    }

    public List<ChartInsight> getInsight(Request request) {
        TextProvider textProvider = request.get(TextProvider.class);
        if (this.isValid()) {
            Object[] args = new Object[]{this.getExplanatoryFieldNames()[0], this.getExplanatoryFieldNames()[1], this.getResponseFieldName()};
            InsightSemantics semantics = InsightSemantics.makeFor(OperationType.UNIQUE, this.getResponseFieldId(), this.getExplanatoryFieldIds(), new String[0]);
            ChartInsight insight = textProvider.humanize(request, INSIGHT_PREDICTIVE_STRENGTH_COMPARISON, this.getMessageKey(), args, semantics);
            return Collections.singletonList(insight);
        }
        return Collections.emptyList();
    }

    private static class FieldWithStrength
    implements Comparable<FieldWithStrength> {
        final String fieldName;
        final double strength;

        public FieldWithStrength(String fieldName, double strength) {
            this.fieldName = fieldName;
            this.strength = strength;
        }

        @Override
        public int compareTo(FieldWithStrength o) {
            return Double.compare(this.strength, o.strength);
        }

        public boolean equals(Object o) {
            if (!(o instanceof FieldWithStrength)) {
                return false;
            }
            FieldWithStrength other = (FieldWithStrength)o;
            return this.fieldName.equals(other.fieldName) && Double.compare(this.strength, other.strength) == 0;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.fieldName.hashCode();
            long strengthLong = Double.doubleToLongBits(this.strength);
            result = 31 * result + (int)(strengthLong ^ strengthLong >> 32);
            return result;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public double getStrength() {
            return this.strength;
        }
    }
}

