/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.provider;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.ChartInsights;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.insights.OperationType;
import com.ibm.bi.predict.explore.nlt.smartannotations.AnnotationServiceCaller;
import com.ibm.bi.predict.explore.nlt.smartannotations.DecorationProcessor;
import com.ibm.bi.predict.explore.nlt.smartannotations.ExecutionResponseProcessor;
import com.ibm.bi.predict.explore.nlt.smartannotations.SAExecutionServiceCaller;
import com.ibm.bi.predict.sa.execution.annotation.result.ExecutionResult;
import com.ibm.bi.predict.sa.execution.api.ExecutionResponse;
import com.ibm.bi.predict.sa.suggestion.domain.Annotation;
import com.ibm.bi.predict.sa.suggestion.domain.Annotations;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleInsightType;
import com.ibm.bi.predict.sa.suggestion.service.AnnotationService;
import com.ibm.bi.predict.sa.suggestion.service.AnnotationsGenerator;
import com.ibm.bi.predict.sa.suggestion.service.DefinitionDrivenAnnotationService;
import com.ibm.bi.predict.sa.suggestion.service.DefinitionLoader;
import com.ibm.bi.predict.sa.suggestion.service.JsonFileDefinitionLoader;
import com.ibm.bi.predict.thirdparty.smarts.Concept;
import com.ibm.bi.predict.thirdparty.smarts.SmartsModule;
import com.ibm.bi.predict.thirdparty.smarts.SmartsService;
import com.ibm.bi.predict.types.RoleType;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.json.JSONException;
import org.slf4j.Logger;

public class SmartAnnotationsProvider {
    private static final com.ibm.bi.predict.utils.Logger LOGGER = PredictLoggerFactory.getLogger(SmartAnnotationsProvider.class);
    final AnnotationServiceCaller annotationCaller;
    final SAExecutionServiceCaller executionCaller;
    final ExecutionResponseProcessor responseProcessor;
    final Locale locale;

    public SmartAnnotationsProvider() {
        this(Locale.getDefault());
    }

    public SmartAnnotationsProvider(Locale locale) {
        DefinitionDrivenAnnotationService as = new DefinitionDrivenAnnotationService((DefinitionLoader)new JsonFileDefinitionLoader(), new AnnotationsGenerator());
        this.annotationCaller = new AnnotationServiceCaller((AnnotationService)as, locale);
        this.executionCaller = new SAExecutionServiceCaller(locale);
        this.responseProcessor = new ExecutionResponseProcessor();
        this.locale = locale;
    }

    public ChartInsights runRequest(Request serviceParams) {
        ChartInsights combined = new ChartInsights(serviceParams);
        try {
            combined.addAll(this.run(serviceParams));
        }
        catch (Exception e) {
            combined.addError("Error providing smart annotations", e, (Logger)LOGGER);
        }
        return combined;
    }

    private List<ChartInsight> run(Request serviceParams) throws JSONException {
        DataAccessProvider provider = serviceParams.get(DataAccessProvider.class);
        ChartInsightsContext context = serviceParams.get(ChartInsightsContext.class);
        Annotations annotations = this.annotationCaller.run(provider, context);
        if (serviceParams.isDerived()) {
            annotations = this.removeTimeseries(annotations);
        }
        if (this.needsConcepts(annotations)) {
            Map<String, List<Concept>> concepts = this.conceptsForDateFields(provider.getMetaData(), context);
            provider.getMetaData().setConcepts(this.convertConcepts(concepts));
        }
        List<ExecutionResult> execResults = this.executionCaller.executeAllRequests(provider, annotations);
        ExecutionResponse execResponse = this.executionCaller.processExecutionResults(execResults);
        MetaData metadata = provider.getMetaData();
        List<Integer> explanatoryIndexes = IntStream.range(0, metadata.fieldCount()).filter(idx -> this.isSuitableExplanatoryField(idx, metadata, context)).boxed().collect(Collectors.toList());
        String responseID = this.getResponse(metadata, context);
        String[] explanatory = (String[])explanatoryIndexes.stream().map(arg_0 -> ((MetaData)metadata).getFieldIdentifier(arg_0)).toArray(String[]::new);
        InsightSemantics semantics = InsightSemantics.makeFor(OperationType.UNIQUE, responseID, explanatory, new String[0]);
        List<ChartInsight> insights = this.responseProcessor.createChartInsights(serviceParams, execResponse, execResults, semantics);
        if (!explanatoryIndexes.isEmpty()) {
            DecorationProcessor decorationProcessor = new DecorationProcessor(serviceParams, provider, (Integer)explanatoryIndexes.get(0), explanatoryIndexes, metadata);
            List<ChartInsight> decoInsights = decorationProcessor.createChartInsights();
            insights.addAll(decoInsights);
        }
        return insights;
    }

    private Map<String, List<Concept>> conceptsForDateFields(MetaData metadata, ChartInsightsContext context) {
        if (!this.hasSmartsService(context)) {
            LOGGER.warn("Smart Annotations request needs concepts, but SmartsService is not available in the request");
            return Collections.emptyMap();
        }
        SmartsService smartsService = context.getSmartsService();
        SmartsModule smartsModule = context.getShapedModule() != false ? smartsService.smartsModuleByTempModule(context.getTempModule()) : smartsService.smartsModuleByModuleId(context.getModuleId());
        HashMap<String, List<Concept>> conceptsByField = new HashMap<String, List<Concept>>();
        for (int i = 0; i < metadata.fieldCount(); ++i) {
            if (metadata.getFieldType(i) != FieldType.DATETIME) continue;
            String id = metadata.getFieldIdentifier(i);
            Map idMap = metadata.getUniqueIdentifiersMap(i);
            if (idMap.size() > 1) {
                for (String uniqueId : idMap.values()) {
                    conceptsByField.put(uniqueId, smartsModule.concepts(uniqueId));
                }
                continue;
            }
            String uniqueId = metadata.getUniqueIdentifiersMap(i).getOrDefault(id, null);
            conceptsByField.put(uniqueId, smartsModule.concepts(uniqueId));
        }
        return conceptsByField;
    }

    private boolean hasSmartsService(ChartInsightsContext context) {
        return context.getSmartsService() != null;
    }

    private Map<String, List<Tuple<String, Double>>> convertConcepts(Map<String, List<Concept>> concepts) {
        HashMap<String, List<Tuple<String, Double>>> conceptsMap = new HashMap<String, List<Tuple<String, Double>>>();
        for (Map.Entry<String, List<Concept>> entry : concepts.entrySet()) {
            String id = entry.getKey();
            List cs = entry.getValue().stream().map(c -> Tuple.of((Object)c.id(), (Object)c.confidence())).collect(Collectors.toList());
            conceptsMap.put(id, cs);
        }
        return conceptsMap;
    }

    private Annotations removeTimeseries(Annotations annotations) {
        List filtered = annotations.annotations.stream().filter(a -> !RuleInsightType.TIME_SERIES.toString().equals(a.getType())).collect(Collectors.toList());
        return new Annotations(filtered, annotations.captions, annotations.messageBundle);
    }

    private boolean needsConcepts(Annotations annotations) {
        for (Annotation annotation : annotations.annotations) {
            if (!annotation.getType().equals(RuleInsightType.TIME_SERIES.toString())) continue;
            return true;
        }
        return false;
    }

    private String getResponse(MetaData metadata, ChartInsightsContext params) {
        for (int i = 0; i < metadata.fieldCount(); ++i) {
            String id = metadata.getFieldIdentifier(i);
            if (!params.getRole(id).equals((Object)RoleType.RESPONSE)) continue;
            return id;
        }
        return null;
    }

    private boolean isSuitableExplanatoryField(int idx, MetaData metadata, ChartInsightsContext params) {
        return metadata.getFieldType(idx) == FieldType.NUMERICAL && params.getRole(metadata.getFieldIdentifier(idx)) == RoleType.EXPLANATORY;
    }
}

