/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.provider;

import com.ibm.bi.predict.explore.Tag;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class TagsProvider {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(TagsProvider.class);
    private static final Map<String, Set<Tag>> tags;
    static final String RESOURCE_FILE = "insight-tags.json";

    private TagsProvider() {
    }

    static Tuple<Map<String, Set<Tag>>, List<String>> load(String filename) {
        HashMap<String, Set<Tag>> map = new HashMap<String, Set<Tag>>();
        ArrayList<String> errors = new ArrayList<String>();
        try (InputStream annotationStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);){
            if (annotationStream == null) {
                throw new FileNotFoundException("File not found");
            }
            JSONObject json = new JSONObject(annotationStream);
            annotationStream.close();
            TagsProvider.parse(json, map, errors);
        }
        catch (Exception e) {
            String msg = "Error loading '" + filename + "': " + e.getMessage();
            LOGGER.debug(msg, (Throwable)e);
            errors.add(msg);
        }
        return new Tuple(map, errors);
    }

    static void parse(JSONObject json, Map<String, Set<Tag>> map, List<String> errors) throws JSONException {
        for (Object key : json.keySet()) {
            String insightName = key.toString();
            JSONArray values = json.getJSONArray(insightName);
            HashSet<Tag> tags = new HashSet<Tag>();
            for (Object v : values) {
                String tagName = v.toString();
                Tag tag = Tag.fromString(tagName);
                if (tag != null) {
                    tags.add(tag);
                    continue;
                }
                errors.add("Unknown tag name '" + tagName + "' for key '" + key + "'");
            }
            map.put(insightName, tags);
        }
    }

    public static Set<String> keySet() {
        return tags.keySet();
    }

    public static Set<Tag> getTags(String key) {
        return tags.getOrDefault(key, Collections.emptySet());
    }

    static {
        Tuple<Map<String, Set<Tag>>, List<String>> result = TagsProvider.load(RESOURCE_FILE);
        tags = (Map)result._1;
        for (String s : (List)result._2) {
            LOGGER.warn(s);
        }
    }
}

