/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.smartannotations;

import com.ibm.bi.predict.explore.Tag;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.smartannotations.TimeSeriesInsights;
import com.ibm.bi.predict.messages.Messages;
import com.ibm.bi.predict.sa.execution.annotation.response.Message;
import com.ibm.bi.predict.sa.execution.annotation.result.ExecutionResult;
import com.ibm.bi.predict.sa.execution.api.ExecutionResponse;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.json.JSONObject;

public class ExecutionResponseProcessor {
    public List<ChartInsight> createChartInsights(Request params, ExecutionResponse executionResponse, List<ExecutionResult> execResults, InsightSemantics semantics) {
        ArrayList<ChartInsight> chartInsights = new ArrayList<ChartInsight>();
        Messages messages = Messages.getMessagesFor((String)"Predict_Smart_Annotations", (Locale)((Locale)params.getContents().get(Locale.class)));
        List executionMessages = executionResponse.getStatus().getMessages();
        for (Message message : executionMessages) {
            if ("AVERAGE".equalsIgnoreCase(message.type) || "MODE".equalsIgnoreCase(message.type)) continue;
            if ("TIME_SERIES".equalsIgnoreCase(message.type)) {
                List<ChartInsight> timeSeriesInsights = TimeSeriesInsights.getInsights(params, execResults, semantics, message);
                chartInsights.addAll(timeSeriesInsights);
                continue;
            }
            Set<Tag> tags = Tag.getTags(message.type);
            for (Tuple tuple : message.shortAndLongMessages) {
                if (UselessResponse.contains((String)tuple._1, messages)) continue;
                String longMessage = (String)tuple._2;
                ChartInsight insight = new ChartInsight(params, longMessage, new JSONObject(), tags, message.type, semantics);
                chartInsights.add(insight);
            }
        }
        return chartInsights;
    }

    private static enum UselessResponse {
        TOO_FEW_CATEGORIES("TOO_FEW_CATEGORIES"),
        TOO_FEW_RECORDS("TOO_FEW_RECORDS"),
        NONE_FOUND("MEANINGFUL_DIFFERENCES_SHORT_NO_RESULTS"),
        NO_PREDICTIVE_RELATIONSHIP("PREDICTIVE_STRENGTH_SHORT_NO_RESULTS"),
        CLIPPED_DATA("CLIPPED_DATA"),
        INVALID_DATA_RECORD("INVALID_DATA_RECORD"),
        INVALID_DATA_RECORD_WARNING("INVALID_DATA_RECORD_WARNING"),
        INVALID_INPUT("VALUES_ABOVE_THRESHOLD"),
        INVALID_FIELD("INVALID_FIELD"),
        NO_DATA("EMPTY_DATA_OBJECT");

        private final String key;

        private UselessResponse(String key) {
            this.key = key;
        }

        public static boolean contains(String response, Messages messages) {
            for (UselessResponse uselessResponse : UselessResponse.values()) {
                String caption = messages.get(uselessResponse.key, new Object[0]);
                if (!caption.equals(response)) continue;
                return true;
            }
            return false;
        }
    }
}

