/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.smartannotations;

import com.google.common.collect.ImmutableMap;
import com.ibm.bi.predict.data.Context;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.sa.execution.annotation.result.ExecutionResult;
import com.ibm.bi.predict.sa.execution.api.ExecutionContext;
import com.ibm.bi.predict.sa.execution.api.ExecutionResponse;
import com.ibm.bi.predict.sa.execution.api.ExecutionServiceImpl;
import com.ibm.bi.predict.sa.execution.api.SuggestedAnnotation;
import com.ibm.bi.predict.sa.execution.service.ExecutionServiceFactoryImpl;
import com.ibm.bi.predict.sa.suggestion.domain.Annotation;
import com.ibm.bi.predict.sa.suggestion.domain.Annotations;
import com.ibm.bi.predict.sa.suggestion.rules.domain.RuleInsightType;
import com.ibm.bi.predict.service.DataProvider;
import com.ibm.bi.predict.service.PredictServiceFramework;
import com.ibm.bi.predict.service.PredictServiceRequest;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SAExecutionServiceCaller {
    public static final String NLT_LOCALE_VARIANT = "NLT";
    private final Locale locale;
    private final PredictServiceFramework executionService;

    public SAExecutionServiceCaller(Locale locale) {
        this(new ExecutionServiceFactoryImpl().make(), locale);
    }

    public SAExecutionServiceCaller(PredictServiceFramework executionService, Locale locale) {
        this.executionService = executionService;
        this.locale = locale;
    }

    public ExecutionResponse callExecutionService(DataAccessProvider dataAccessProvider, Annotations annotations) {
        Set<PredictServiceRequest> request = this.makeExecutionRequest(dataAccessProvider, annotations);
        return (ExecutionResponse)this.executionService.run(request, this.getLocale());
    }

    public List<ExecutionResult> executeAllRequests(DataAccessProvider dataAccessProvider, Annotations annotations) {
        Set<PredictServiceRequest> request = this.makeExecutionRequest(dataAccessProvider, annotations);
        return ((ExecutionServiceImpl)this.executionService).executeAll(request);
    }

    public ExecutionResponse processExecutionResults(List<ExecutionResult> execResults) {
        return ((ExecutionServiceImpl)this.executionService).getExecutionResponse(execResults, this.getLocale());
    }

    private Set<PredictServiceRequest> makeExecutionRequest(DataAccessProvider dataAccessProvider, Annotations annotations) {
        MetaData metadata = dataAccessProvider.getMetaData();
        Set suggestions = annotations.annotations.stream().map(v -> this.makeSuggestedAnnotation((Annotation)v, metadata)).collect(Collectors.toSet());
        ExecutionContext context = new ExecutionContext();
        context.setSuggestedAnnotations(suggestions);
        return Collections.singleton(new PredictServiceRequest(SAExecutionServiceCaller.dataProviderFromDataAccessProvider(dataAccessProvider), (Context)context, Locale.ENGLISH, Collections.emptyMap()));
    }

    private SuggestedAnnotation makeSuggestedAnnotation(Annotation a, MetaData metadata) {
        List dataItems = a.getDataItems();
        List roles = a.getRoles();
        int targetIndex = this.getFieldIndex(metadata, (String)dataItems.get(roles.indexOf("response")));
        List allExplIndexes = IntStream.range(0, roles.size()).boxed().filter(i -> "explanatory".equals(roles.get((int)i))).map(i -> this.getFieldIndex(metadata, (String)dataItems.get((int)i))).collect(Collectors.toList());
        String algorithm = a.getParts().isEmpty() ? null : (String)a.getParts().get(0);
        return new SuggestedAnnotation(dataItems, roles, a.getType(), algorithm, targetIndex, allExplIndexes, a.getRequirements().stream().collect(Collectors.toList()), this.makeModelOptions(a));
    }

    private Map<String, Object> makeModelOptions(Annotation annotation) {
        String annType = annotation.getType();
        if (annType.equals(RuleInsightType.TIME_SERIES.toString())) {
            return ImmutableMap.of((Object)"includeOutliers", (Object)true);
        }
        return Collections.emptyMap();
    }

    private int getFieldIndex(MetaData metadata, String fieldId) {
        return IntStream.range(0, metadata.fieldCount()).filter(i -> fieldId.equals(metadata.getFieldIdentifier(i))).findFirst().orElse(-1);
    }

    Locale getLocale() {
        return new Locale(this.locale.getLanguage(), this.locale.getCountry(), NLT_LOCALE_VARIANT);
    }

    private static Supplier<DataProvider> dataProviderFromDataAccessProvider(DataAccessProvider dataProvider) {
        return () -> DataProvider.fromDataAccessProvider((DataAccessProvider)dataProvider);
    }
}

