/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.smartannotations;

import com.ibm.bi.predict.algorithms.forecasting.result.SeriesResult;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.smartannotations.TimeSeriesOutlierInsights;
import com.ibm.bi.predict.explore.nlt.smartannotations.TimeSeriesSeasonalityInsights;
import com.ibm.bi.predict.explore.nlt.smartannotations.TimeSeriesTrendInsights;
import com.ibm.bi.predict.sa.execution.annotation.response.Message;
import com.ibm.bi.predict.sa.execution.annotation.result.AnnotationResult;
import com.ibm.bi.predict.sa.execution.annotation.result.ExecutionResult;
import com.ibm.bi.predict.sa.execution.annotation.result.TimeSeriesResult;
import java.util.ArrayList;
import java.util.List;

public final class TimeSeriesInsights {
    private TimeSeriesInsights() {
    }

    public static List<ChartInsight> getInsights(Request params, Iterable<ExecutionResult> execResults, InsightSemantics semantics, Message message) {
        ArrayList<ChartInsight> insights = new ArrayList<ChartInsight>();
        for (ExecutionResult execResult : execResults) {
            for (AnnotationResult annResult : execResult.getResults().values()) {
                if (!(annResult instanceof TimeSeriesResult)) continue;
                insights.addAll(TimeSeriesInsights.getTimeSeriesInsights((TimeSeriesResult)annResult, params, semantics, message));
            }
        }
        return insights;
    }

    static List<ChartInsight> getTimeSeriesInsights(TimeSeriesResult tsRes, Request params, InsightSemantics semantics, Message message) {
        ArrayList<ChartInsight> insights = new ArrayList<ChartInsight>();
        if (tsRes.getResult().size() == 1) {
            TimeSeriesResult.TimeSeriesData data = (TimeSeriesResult.TimeSeriesData)tsRes.getResult().get(0);
            SeriesResult sr = data.seriesResult;
            if (sr.isForecastSuccessful()) {
                insights.addAll(TimeSeriesTrendInsights.getTrendInsights(sr, params, semantics, message));
                insights.addAll(TimeSeriesOutlierInsights.getOutlierInsights(sr, params, semantics, message));
                insights.addAll(TimeSeriesSeasonalityInsights.getSeasonalityInsights(sr, params, semantics, message));
            }
        }
        return insights;
    }
}

