/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.smartannotations;

import com.ibm.bi.predict.algorithms.forecasting.result.Outlier;
import com.ibm.bi.predict.algorithms.forecasting.result.OutlierType;
import com.ibm.bi.predict.algorithms.forecasting.result.SeriesResult;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.explore.Tag;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.messages.Messages;
import com.ibm.bi.predict.sa.execution.annotation.response.Message;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.commons.json.JSONObject;

public final class TimeSeriesOutlierInsights {
    private static final Logger LOG = PredictLoggerFactory.getLogger(TimeSeriesOutlierInsights.class);
    private static final int TOP_N_OUTLIERS = 5;
    private static final String OUTLIER_MSG_PREFIX = "TIME_SERIES_OUTLIERS_";
    private static final String LAST_POINT_IS_OUTLIER_MSG_KEY = "TIME_SERIES_OUTLIERS_LAST_TIME_POINT_ALERT";

    private TimeSeriesOutlierInsights() {
    }

    static List<ChartInsight> getOutlierInsights(SeriesResult sr, Request params, InsightSemantics semantics, Message message) {
        Outlier[] outliers = sr.getOutliers();
        if (outliers.length == 0) {
            return Collections.emptyList();
        }
        Outlier lastObservedPoint = null;
        PriorityQueue<Outlier> topOutliers = new PriorityQueue<Outlier>(5);
        int invalidOutliers = 0;
        for (Outlier outlier : outliers) {
            if (!TimeSeriesOutlierInsights.isInterpolatedPoint(sr, outlier)) {
                if (topOutliers.size() < 5) {
                    topOutliers.add(outlier);
                } else if (((Outlier)topOutliers.peek()).compareTo(outlier) < 0) {
                    topOutliers.remove();
                    topOutliers.add(outlier);
                }
                if (!outlier.isLastObservedPoint()) continue;
                lastObservedPoint = outlier;
                continue;
            }
            ++invalidOutliers;
        }
        if (topOutliers.isEmpty()) {
            return Collections.emptyList();
        }
        boolean allHigh = true;
        boolean allLow = true;
        for (Outlier outlier : topOutliers) {
            if (outlier.getType() == OutlierType.low) {
                allHigh = false;
                continue;
            }
            allLow = false;
        }
        Locale locale = TimeSeriesOutlierInsights.extractLocale(params);
        String columnLabel = TimeSeriesOutlierInsights.getColumnLabel(params);
        int outlierCount = outliers.length - invalidOutliers;
        String genOutlierMessageKey = OUTLIER_MSG_PREFIX + TimeSeriesOutlierInsights.getMsgKeySuffix(outlierCount, allHigh, allLow);
        String genOutlierMessage = Messages.getMessagesFor((String)"Predict_Insights", (Locale)locale).get(genOutlierMessageKey, TimeSeriesOutlierInsights.getMsgArgs(columnLabel, outlierCount, topOutliers));
        return TimeSeriesOutlierInsights.createInsights(lastObservedPoint, genOutlierMessage, genOutlierMessageKey, columnLabel, params, message, semantics);
    }

    static boolean isInterpolatedPoint(SeriesResult sr, Outlier outlier) {
        int[] rowOrder = sr.getTimeDimension().getRowOrder();
        return sr.getMissingValueIndices().contains(rowOrder[outlier.getIndex()]);
    }

    static List<ChartInsight> createInsights(Outlier lastObservedPoint, String genOutlierMessage, String genOutlierMessageKey, String fieldLabel, Request params, Message message, InsightSemantics semantics) {
        ArrayList<ChartInsight> insights = new ArrayList<ChartInsight>();
        insights.add(new ChartInsight(params, genOutlierMessage, new JSONObject(), Tag.getTags(message.type), genOutlierMessageKey, semantics));
        if (lastObservedPoint != null) {
            Messages messageBundle = Messages.getMessagesFor((String)"Predict_Insights", (Locale)TimeSeriesOutlierInsights.extractLocale(params));
            insights.add(new ChartInsight(params, messageBundle.get(LAST_POINT_IS_OUTLIER_MSG_KEY, new Object[]{fieldLabel, String.join((CharSequence)"|", lastObservedPoint.getTime().getValues())}), new JSONObject(), Tag.getTags(message.type), LAST_POINT_IS_OUTLIER_MSG_KEY, semantics));
        }
        return insights;
    }

    static Object[] getMsgArgs(String fieldName, int outliersCount, Queue<Outlier> topOutliers) {
        Object[] msgArgs = new String[outliersCount > 5 ? 7 : outliersCount + 1];
        msgArgs[0] = fieldName;
        for (int i = topOutliers.size() - 1; i >= 0; --i) {
            msgArgs[i + 1] = String.join((CharSequence)"|", topOutliers.poll().getTime().getValues());
        }
        if (outliersCount > 5) {
            msgArgs[msgArgs.length - 1] = Integer.toString(outliersCount);
        }
        return msgArgs;
    }

    static String getMsgKeySuffix(int outliersCount, boolean allHigh, boolean allLow) {
        String msgKeySuffix = "";
        switch (outliersCount) {
            case 1: {
                msgKeySuffix = "ONE_";
                break;
            }
            case 2: {
                msgKeySuffix = "TWO_";
                break;
            }
            case 3: {
                msgKeySuffix = "THREE_";
                break;
            }
            case 4: {
                msgKeySuffix = "FOUR_";
                break;
            }
            case 5: {
                msgKeySuffix = "FIVE_";
                break;
            }
            default: {
                msgKeySuffix = "MORE_THAN_FIVE_";
            }
        }
        msgKeySuffix = allHigh ? msgKeySuffix + "HIGH" : (allLow ? msgKeySuffix + "LOW" : msgKeySuffix + "LOW_AND_HIGH");
        return msgKeySuffix;
    }

    private static Locale extractLocale(Request params) {
        Locale locale;
        try {
            locale = params.get(Locale.class);
        }
        catch (Exception e) {
            LOG.warn("Failed to get Locale from request. Continuing with default.", (Throwable)e);
            locale = Locale.getDefault();
        }
        return locale;
    }

    static String getColumnLabel(Request params) {
        MetaData md = params.get(DataAccessProvider.class).getMetaData();
        for (int i = 0; i < md.fieldCount(); ++i) {
            if (md.getFieldType(i) != FieldType.NUMERICAL) continue;
            return md.getFieldDisplayLabel(i);
        }
        return "";
    }
}

