/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.smartannotations;

import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.es.ESDiagnostics;
import com.ibm.bi.predict.algorithms.forecasting.es.ESFit;
import com.ibm.bi.predict.algorithms.forecasting.es.ESMethod;
import com.ibm.bi.predict.algorithms.forecasting.result.ForecastingStatisticalDetails;
import com.ibm.bi.predict.algorithms.forecasting.result.SeriesResult;
import com.ibm.bi.predict.algorithms.forecasting.result.TimeValue;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeDelta;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeUnit;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.explore.Tag;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.messages.Messages;
import com.ibm.bi.predict.sa.execution.annotation.response.Message;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.commons.json.JSONObject;

public final class TimeSeriesSeasonalityInsights {
    private static final String MSG_KEY_PREFIX = "TIME_SERIES_SEASONALITY_";
    private static final String ANNUAL = "ANNUAL";
    private static final String DAILY = "DAILY";
    private static final String WEEKLY = "WEEKLY";
    private static final String WEEK = "WEEK";
    private static final String QUARTER = "QUARTER";
    private static final String PERIOD = "PERIOD";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String NUMERIC_PERIOD = "NUMERIC_PERIOD";
    private static final String NUMERIC_KNOWN = "NUMERIC_KNOWN";
    private static final String NUMERIC_UNKNOWN = "NUMERIC_UNKNOWN";
    private static final String TIME_UNIT_MESSAGE_KEY_PREFIX = "FORECASTING_TIME_UNIT_";
    private static final String STRONG = "STRONG";
    private static final String MODERATE = "MODERATE";
    private static final String WEAK = "WEAK";
    private static final double STRONG_THRESHOLD = 0.5;
    private static final double MODERATE_THRESHOLD = 0.3;
    private static final double WEAK_THRESHOLD = 0.05;
    private static final String SMALLEST = "SMALLEST";
    private static final String LARGEST = "LARGEST";
    private static final String LARGEST_AND_SMALLEST = "LARGEST_AND_SMALLEST";

    private TimeSeriesSeasonalityInsights() {
    }

    public static List<ChartInsight> getSeasonalityInsights(SeriesResult sr, Request params, InsightSemantics semantics, Message message) {
        ForecastingStatisticalDetails statDetails = sr.getStatisticalDetails();
        if (statDetails.getSeasonType() == ESMethod.Seasonality.NONE || TimeSeriesSeasonalityInsights.getContributionStrength(sr) < 0.05) {
            return Collections.emptyList();
        }
        ArrayList<ChartInsight> insights = new ArrayList<ChartInsight>();
        String strengthMessage = TimeSeriesSeasonalityInsights.getStrengthMessage(sr, params);
        String extremaMessage = TimeSeriesSeasonalityInsights.getExtremaMessage(sr, params);
        insights.add(new ChartInsight(params, strengthMessage + " " + extremaMessage, new JSONObject(), Tag.getTags(message.type), message.type, semantics));
        return insights;
    }

    static String getExtremaMessage(SeriesResult sr, Request params) {
        TimeDelta delta = TimeSeriesSeasonalityInsights.adjustUnitForQuarterOrWeek(sr.getTimeDimension());
        String seasonUnit = TimeSeriesSeasonalityInsights.getSeasonUnit(sr, delta);
        if (seasonUnit.equalsIgnoreCase(NUMERIC_UNKNOWN)) {
            return "";
        }
        Locale locale = TimeSeriesSeasonalityInsights.extractLocale(params);
        TimeValue max = TimeSeriesSeasonalityInsights.getSeasonalMax(sr, locale, delta);
        TimeValue min = TimeSeriesSeasonalityInsights.getSeasonalMin(sr, locale, delta);
        if (max == null && min == null) {
            return "";
        }
        String extremaTypeKey = TimeSeriesSeasonalityInsights.getExtremaTypeKey(max, min);
        String timeDeltaUnitKey = TimeSeriesSeasonalityInsights.getTimeDeltaUnitKey(sr, seasonUnit, max, min, delta);
        Object[] msgArgs = TimeSeriesSeasonalityInsights.getExtremaMsgArgs(timeDeltaUnitKey, sr, max, min, delta);
        Messages messageBundle = Messages.getMessagesFor((String)"Predict_Insights", (Locale)locale);
        return messageBundle.get(MSG_KEY_PREFIX + timeDeltaUnitKey + "_" + extremaTypeKey, msgArgs);
    }

    static TimeDelta adjustUnitForQuarterOrWeek(TimeDimension timeDimension) {
        TimeDelta delta = timeDimension.getTimeDelta();
        TimeUnit unit = delta.getUnit();
        long steps = delta.getSteps();
        if (unit == TimeUnit.MONTH && steps == 3L && !timeDimension.getIndexOfUnit(TimeUnit.MONTH).isPresent() && timeDimension.getIndexOfUnit(TimeUnit.QUARTER).isPresent()) {
            return new TimeDelta(1L, TimeUnit.QUARTER);
        }
        if (unit == TimeUnit.DAY && steps == 7L && !timeDimension.getIndexOfUnit(TimeUnit.DAY).isPresent() && timeDimension.getIndexOfUnit(TimeUnit.WEEK).isPresent()) {
            return new TimeDelta(1L, TimeUnit.WEEK);
        }
        return delta;
    }

    static String getExtremaTypeKey(TimeValue max, TimeValue min) {
        if (max == null) {
            return SMALLEST;
        }
        if (min == null) {
            return LARGEST;
        }
        return LARGEST_AND_SMALLEST;
    }

    static String getTimeDeltaUnitKey(SeriesResult sr, String seasonUnit, TimeValue max, TimeValue min, TimeDelta delta) {
        String timeDeltaUnitKey = delta.getUnit().toString().toUpperCase();
        int period = sr.getStatisticalDetails().getSeasonalityPeriod();
        if (seasonUnit.equalsIgnoreCase(NUMERIC_KNOWN) || seasonUnit.equalsIgnoreCase(WEEKLY) && !sr.getTimeDimension().canDetermineDayOfWeek() || seasonUnit.equalsIgnoreCase(ANNUAL) && timeDeltaUnitKey.equalsIgnoreCase(TimeUnit.DAY.toString()) || timeDeltaUnitKey.equalsIgnoreCase(QUARTER) && period != 4 || timeDeltaUnitKey.equalsIgnoreCase(WEEK) && period != 52 && period != 53 || max != null && !max.hasValidLabels() || min != null && !min.hasValidLabels()) {
            timeDeltaUnitKey = PERIOD;
        }
        if (TimeSeriesSeasonalityInsights.checkAnnualAndNumeric(seasonUnit, timeDeltaUnitKey, sr)) {
            timeDeltaUnitKey = UNKNOWN;
        }
        return timeDeltaUnitKey;
    }

    static boolean checkAnnualAndNumeric(String seasonUnit, String timeDeltaUnitKey, SeriesResult sr) {
        Optional index = sr.getTimeDimension().getIndexOfUnit(TimeUnit.MONTH);
        if (index.isPresent()) {
            return seasonUnit.equalsIgnoreCase(ANNUAL) && timeDeltaUnitKey.equalsIgnoreCase(TimeUnit.MONTH.toString()) && sr.getTimeDimension().getNumberOfComponents() > 1 && sr.getTimeDimension().isComponentNumeric(((Integer)index.get()).intValue());
        }
        return false;
    }

    static String getSeasonUnit(SeriesResult sr, TimeDelta delta) {
        String timeUnit = delta.getUnit().toString();
        long d = delta.getSteps();
        int p = sr.getStatisticalDetails().getSeasonalityPeriod();
        return TimeSeriesSeasonalityInsights.getTimeUnitKey(timeUnit, d, p, true);
    }

    static Object[] getExtremaMsgArgs(String givenUnitKey, SeriesResult sr, TimeValue max, TimeValue min, TimeDelta delta) {
        if (givenUnitKey.contentEquals(PERIOD)) {
            if (max != null) {
                max.setValues(new String[]{Integer.toString(max.getIndex() + 1)});
            }
            if (min != null) {
                min.setValues(new String[]{Integer.toString(min.getIndex() + 1)});
            }
        }
        String timeHeader = sr.getTimeDimension().getTimeColumnHeader();
        if (givenUnitKey.equalsIgnoreCase(TimeUnit.UNKNOWN.toString()) && sr.getTimeDimension().getNumberOfComponents() >= 2) {
            TimeUnit deltaUnit = delta.getUnit();
            Optional index = sr.getTimeDimension().getIndexOfUnit(deltaUnit);
            if (index.isPresent()) {
                timeHeader = sr.getTimeDimension().getTimeComponentHeader(((Integer)index.get()).intValue());
            }
        }
        boolean seasonalityIsUnknown = givenUnitKey.equalsIgnoreCase(TimeUnit.UNKNOWN.toString());
        return TimeSeriesSeasonalityInsights.buildExtremaMsgArgs(timeHeader, max, min, seasonalityIsUnknown);
    }

    static Object[] buildExtremaMsgArgs(String timeHeader, TimeValue max, TimeValue min, boolean seasonalityIsUnknown) {
        Object[] msgArgs = max == null ? (seasonalityIsUnknown ? new Object[]{timeHeader, min.toString()} : new Object[]{min.toString()}) : (min == null ? (seasonalityIsUnknown ? new Object[]{timeHeader, max.toString()} : new Object[]{max.toString()}) : (seasonalityIsUnknown ? new Object[]{timeHeader, max.toString(), timeHeader, min.toString()} : new Object[]{max.toString(), min.toString()}));
        return msgArgs;
    }

    static TimeValue getSeasonalMax(SeriesResult sr, Locale locale, TimeDelta delta) {
        TimeValue max = null;
        double[] meanS = sr.getESFit().getModel().getMeanSeasonalValues();
        int candidate = NumericUtils.argmax((double[])meanS);
        if (sr.getESFit().getModel().isValidSeasonalMax(candidate, 0.5)) {
            max = TimeSeriesSeasonalityInsights.makeSeasonalTimeValueAtIndex(candidate, sr, locale, delta);
        }
        return max;
    }

    static TimeValue getSeasonalMin(SeriesResult sr, Locale locale, TimeDelta delta) {
        TimeValue min = null;
        double[] meanS = sr.getESFit().getModel().getMeanSeasonalValues();
        int candidate = NumericUtils.argmin((double[])meanS);
        if (sr.getESFit().getModel().isValidSeasonalMin(candidate, 0.5)) {
            min = TimeSeriesSeasonalityInsights.makeSeasonalTimeValueAtIndex(candidate, sr, locale, delta);
        }
        return min;
    }

    static TimeValue makeSeasonalTimeValueAtIndex(int candidate, SeriesResult sr, Locale locale, TimeDelta delta) {
        TimeDimension timeDimension = sr.getTimeDimension();
        TimeUnit unit = delta.getUnit();
        long d = delta.getSteps();
        int p = sr.getStatisticalDetails().getSeasonalityPeriod();
        int candidateRowIndex = timeDimension.getRowOrder()[candidate];
        String label = null;
        TimeConcept concept = timeDimension.concept(0);
        if (unit == TimeUnit.DAY && (long)p * d == 7L && concept != null && concept.isTimestamp()) {
            label = timeDimension.getDayOfWeekFromTimestamp(candidateRowIndex, locale);
        } else if (unit == TimeUnit.DAY && (long)p * d == 7L) {
            label = timeDimension.getDayOfWeekFromNestedTime(candidateRowIndex, locale);
        } else if (concept != null && concept.isTimestamp()) {
            Date date = timeDimension.getDate(candidateRowIndex);
            int period = sr.getESFit().period();
            long timeUnitPeriod = delta.getSteps() * (long)period;
            label = TimeSeriesSeasonalityInsights.getSuitableSeasonalLabel(date, delta.getUnit(), timeUnitPeriod, locale);
        }
        if (label == null || "".equals(label)) {
            label = timeDimension.getDateLabel(candidateRowIndex, unit);
        }
        return label == null ? null : new TimeValue(candidate, new String[]{label});
    }

    static String getStrengthMessage(SeriesResult sr, Request params) {
        TimeDelta delta = TimeSeriesSeasonalityInsights.adjustUnitForQuarterOrWeek(sr.getTimeDimension());
        long d = delta.getSteps();
        int p = sr.getStatisticalDetails().getSeasonalityPeriod();
        String timeUnitKey = TimeSeriesSeasonalityInsights.getTimeUnitKey(delta.getUnit().toString(), d, p, false);
        String strengthKey = TimeSeriesSeasonalityInsights.getStrengthKey(TimeSeriesSeasonalityInsights.getContributionStrength(sr));
        String colLabel = TimeSeriesSeasonalityInsights.getColumnLabel(params);
        Object[] msgArgs = TimeSeriesSeasonalityInsights.getStrengtMsgArgs(sr, params, d, p, delta, timeUnitKey, colLabel);
        Messages messageBundle = Messages.getMessagesFor((String)"Predict_Insights", (Locale)TimeSeriesSeasonalityInsights.extractLocale(params));
        return messageBundle.get(MSG_KEY_PREFIX + timeUnitKey + "_" + strengthKey, msgArgs);
    }

    static Object[] getStrengtMsgArgs(SeriesResult sr, Request params, long d, int p, TimeDelta delta, String timeUnitKey, String colLabel) {
        Object[] msgArgs = !timeUnitKey.contains("NUMERIC") ? new Object[]{colLabel} : (timeUnitKey.contains(UNKNOWN) ? new Object[]{colLabel, d * (long)p} : new Object[]{colLabel, "", TimeSeriesSeasonalityInsights.getTimeUnitLabel(sr, params, d, p, delta)});
        return msgArgs;
    }

    static String getTimeUnitLabel(SeriesResult sr, Request params, long d, int p, TimeDelta delta) {
        String timeUnitLabel = "";
        Messages messageBundle = Messages.getMessagesFor((String)"Predict_Messages", (Locale)TimeSeriesSeasonalityInsights.extractLocale(params));
        timeUnitLabel = d * (long)p == 1L ? messageBundle.get(TIME_UNIT_MESSAGE_KEY_PREFIX + delta.getUnit().toString() + "_SINGULAR", new Object[0]) : messageBundle.get(TIME_UNIT_MESSAGE_KEY_PREFIX + delta.getUnit().toString(), new Object[]{d * (long)p});
        return timeUnitLabel;
    }

    static String getColumnLabel(Request params) {
        String colLabel = "";
        MetaData md = params.get(DataAccessProvider.class).getMetaData();
        for (int i = 0; i < md.fieldCount(); ++i) {
            if (md.getFieldType(i) != FieldType.NUMERICAL) continue;
            colLabel = md.getFieldDisplayLabel(i);
            break;
        }
        return colLabel;
    }

    static String getTimeUnitKey(String unit, long d, int p, boolean forExtrema) {
        long pUnitLength = d * (long)p;
        String unitKey = pUnitLength == 12L && unit.equalsIgnoreCase(TimeUnit.MONTH.toString()) ? ANNUAL : (pUnitLength == 4L && unit.equalsIgnoreCase(TimeUnit.QUARTER.toString()) ? ANNUAL : ((pUnitLength == 52L || pUnitLength == 53L) && unit.equalsIgnoreCase(TimeUnit.WEEK.toString()) ? ANNUAL : ((pUnitLength == 364L || pUnitLength == 365L || pUnitLength == 366L || pUnitLength == 371L) && unit.equalsIgnoreCase(TimeUnit.DAY.toString()) ? ANNUAL : (pUnitLength == 24L && unit.equalsIgnoreCase(TimeUnit.HOUR.toString()) ? DAILY : (pUnitLength == 7L && unit.equalsIgnoreCase(TimeUnit.DAY.toString()) ? WEEKLY : (forExtrema && unit.equalsIgnoreCase(TimeUnit.WEEK.toString()) ? WEEK : (forExtrema && unit.equalsIgnoreCase(TimeUnit.QUARTER.toString()) ? QUARTER : (unit.equalsIgnoreCase(TimeUnit.PERIOD.toString()) ? NUMERIC_PERIOD : (unit.equalsIgnoreCase(TimeUnit.UNKNOWN.toString()) ? NUMERIC_UNKNOWN : NUMERIC_KNOWN)))))))));
        return unitKey;
    }

    static String getSuitableSeasonalLabel(Date date, TimeUnit unit, long period, Locale locale) {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        if (unit == TimeUnit.DAY && period == 7L) {
            SimpleDateFormat format = new SimpleDateFormat("EEEEE", locale);
            format.setTimeZone(utc);
            return format.format(date);
        }
        if (unit == TimeUnit.MONTH && period == 12L) {
            SimpleDateFormat format = new SimpleDateFormat("MMMMM", locale);
            format.setTimeZone(utc);
            return format.format(date);
        }
        if (unit == TimeUnit.QUARTER && period == 4L) {
            return "Q" + period;
        }
        if (unit == TimeUnit.HOUR && period == 24L) {
            DateFormat df = DateFormat.getTimeInstance(0, locale);
            if (df instanceof SimpleDateFormat) {
                SimpleDateFormat f = (SimpleDateFormat)df;
                f.setTimeZone(utc);
                String pattern = f.toPattern();
                pattern = pattern.replaceAll(":?(\\.)?[MmSs]+('.')?", "");
                pattern = pattern.replaceAll("z", "");
                pattern = pattern.replaceAll(" ", "");
                f.applyPattern(pattern);
                return f.format(date);
            }
            SimpleDateFormat format = new SimpleDateFormat("H", locale);
            format.setTimeZone(utc);
            return format.format(date);
        }
        return null;
    }

    static double getContributionStrength(SeriesResult sr) {
        ESMethod nonSeason;
        ESFit esfit = sr.getESFit();
        Map fittedDiag = esfit.getFittedDiagnostics();
        if (fittedDiag.get(nonSeason = ESMethod.make((ESMethod.Trend)esfit.method().trend(), (ESMethod.Seasonality)ESMethod.Seasonality.NONE)) != null) {
            return 1.0 - esfit.diagnostics().MASE() / ((ESDiagnostics)fittedDiag.get(nonSeason)).MASE();
        }
        throw new IllegalStateException("Failed to calculate season contribution strength because the required de-seasoned model is missing.");
    }

    static String getStrengthKey(double strength) {
        if (strength > 0.5) {
            return STRONG;
        }
        if (strength > 0.3) {
            return MODERATE;
        }
        return WEAK;
    }

    private static Locale extractLocale(Request params) {
        return params.getOpt(Locale.class).orElse(Locale.getDefault());
    }
}

