/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.relationship;

import com.ibm.bi.predict.explore.ExploreContext;
import com.ibm.bi.predict.explore.ExploreParams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class RelationshipStrengthGroupingIndexer {
    private final String targetId;
    private final ExploreParams.Grouping grouping;
    private final List<ExploreParams.Group> allGroups;
    private final List<List<String>> indexToGroup;

    public RelationshipStrengthGroupingIndexer(ExploreContext context, ExploreParams.Grouping grouping, Map<String, Integer> dfIndexes) {
        this.targetId = context.getString("target", null);
        this.grouping = grouping;
        this.allGroups = new ArrayList<ExploreParams.Group>();
        int nFields = dfIndexes.size();
        this.indexToGroup = new ArrayList<List<String>>();
        for (int i = 0; i < nFields; ++i) {
            this.indexToGroup.add(new ArrayList());
        }
        this.processGroups(context, dfIndexes);
    }

    private void processGroups(ExploreContext context, Map<String, Integer> dfIndexes) {
        int index = 0;
        HashSet<String> allMembers = new HashSet<String>();
        for (ExploreParams.Group group : this.grouping.getGroups()) {
            this.processGroup(group, allMembers, dfIndexes, index++);
        }
        this.processField(this.targetId, allMembers, dfIndexes, index++);
        this.processField(context.getString("target", null), allMembers, dfIndexes, index++);
        Iterator fit = context.getStringList("explore-params.candidates", new ArrayList()).iterator();
        while (fit.hasNext()) {
            this.processField((String)fit.next(), allMembers, dfIndexes, index++);
        }
    }

    private void processGroup(ExploreParams.Group group, Set<String> allMembers, Map<String, Integer> dfIndexes, int groupIndex) {
        HashSet<Integer> members = new HashSet<Integer>();
        for (String m : group.getMembers()) {
            if (dfIndexes.containsKey(m)) {
                members.add(dfIndexes.get(m));
            }
            allMembers.add(m);
        }
        String id = group.getId();
        if (!members.isEmpty()) {
            members.stream().forEach(ix -> this.indexToGroup.get((int)ix).add(id));
            this.allGroups.add(group);
        }
    }

    private void processField(String fname, Set<String> allMembers, Map<String, Integer> dfIndexes, int groupIndex) {
        if (!allMembers.contains(fname) && dfIndexes.containsKey(fname)) {
            this.allGroups.add(new ExploreParams.Group(fname, Collections.singletonList(fname)));
            int ix = dfIndexes.get(fname);
            this.indexToGroup.get(ix).add(fname);
            allMembers.add(fname);
        }
    }

    public List<String> indexToGroup(int fieldIndex) {
        return this.indexToGroup.get(fieldIndex);
    }

    public ExploreParams.Grouping createGrouping(Set<String> fieldIds) {
        return RelationshipStrengthGroupingIndexer.createGrouping(this.grouping.getId(), this.allGroups, fieldIds);
    }

    public static ExploreParams.Grouping createGrouping(String id, List<ExploreParams.Group> groups, Set<String> fieldIds) {
        List<ExploreParams.Group> outputGroups = groups.stream().map(g -> RelationshipStrengthGroupingIndexer.createGroup(g, fieldIds)).filter(v -> v != null).collect(Collectors.toList());
        return new ExploreParams.Grouping(id, outputGroups);
    }

    private static ExploreParams.Group createGroup(ExploreParams.Group inputGroup, Set<String> fieldIds) {
        List<String> members = inputGroup.getMembers().stream().filter(v -> fieldIds.contains(v)).collect(Collectors.toList());
        return members.isEmpty() ? null : new ExploreParams.Group(inputGroup.getId(), members);
    }
}

