/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.relationship;

import com.ibm.bi.predict.explore.result.RelationshipStrength;

public class RelationshipStrengthIntermediate
implements Comparable<RelationshipStrengthIntermediate> {
    private final String a;
    private final int[] aSort;
    private final String b;
    private final int[] bSort;
    private final double strength;
    private final String fieldA;
    private final String fieldB;
    private final boolean containsTarget;

    protected RelationshipStrengthIntermediate(String a, int[] aSort, String fieldA, String b, int[] bSort, String fieldB, double strength) {
        if (RelationshipStrengthIntermediate.compareArrays(aSort, bSort) < 0) {
            this.a = a;
            this.aSort = aSort;
            this.fieldA = fieldA;
            this.b = b;
            this.bSort = bSort;
            this.fieldB = fieldB;
        } else {
            this.a = b;
            this.aSort = bSort;
            this.fieldA = fieldB;
            this.b = a;
            this.bSort = aSort;
            this.fieldB = fieldA;
        }
        this.strength = strength;
        this.containsTarget = aSort[0] == 0 || bSort[0] == 0;
    }

    protected RelationshipStrength toRelationshipStrength() {
        return new RelationshipStrength(this.a, this.b, this.strength, this.fieldA, this.fieldB);
    }

    protected double getStrength() {
        return this.strength;
    }

    protected static int sortPrioritizingTarget(RelationshipStrengthIntermediate a, RelationshipStrengthIntermediate b) {
        if (a.containsTarget && !b.containsTarget) {
            return -1;
        }
        if (!a.containsTarget && b.containsTarget) {
            return 1;
        }
        return a.compareTo(b);
    }

    @Override
    public int compareTo(RelationshipStrengthIntermediate o) {
        int c = Double.compare(o.strength, this.strength);
        if (c != 0) {
            return c;
        }
        c = RelationshipStrengthIntermediate.compareArrays(this.aSort, o.aSort);
        if (c != 0) {
            return c;
        }
        return RelationshipStrengthIntermediate.compareArrays(this.bSort, o.bSort);
    }

    protected static int compareArrays(int[] a, int[] b) {
        int l = a.length < b.length ? a.length : b.length;
        for (int i = 0; i < l; ++i) {
            int c = Integer.compare(a[i], b[i]);
            if (c == 0) continue;
            return c;
        }
        return Integer.compare(a.length, b.length);
    }

    public boolean equals(Object o) {
        if (!(o instanceof RelationshipStrengthIntermediate)) {
            return false;
        }
        RelationshipStrengthIntermediate other = (RelationshipStrengthIntermediate)o;
        return this.a.equals(other.a) && this.b.equals(other.b) && Double.compare(this.strength, other.strength) == 0;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.a.hashCode();
        result = 31 * result + this.b.hashCode();
        long strengthLong = Double.doubleToLongBits(this.strength);
        result = 31 * result + (int)(strengthLong ^ strengthLong >> 32);
        return result;
    }
}

