/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.relationship;

import com.ibm.bi.predict.data.FrequencyTable;
import com.ibm.bi.predict.utils.Tuple;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class RelationshipStrengthsGraphAlgorithm {
    private final FrequencyTable table;
    private final int targetIndex;
    private final int maxNodes;
    private final int maxLinks;
    private final double minStrength;

    public RelationshipStrengthsGraphAlgorithm(FrequencyTable table, int targetIndex, int maxNodes, int maxLinks, double minStrength) {
        this.table = table;
        this.targetIndex = targetIndex;
        this.maxNodes = maxNodes;
        this.maxLinks = maxLinks;
        this.minStrength = minStrength;
    }

    public Tuple<List<Integer>, List<GraphLink>> run() {
        List<GraphLink> sortedLinks = this.buildInputLinks();
        LinkedHashSet<Integer> nodeSet = new LinkedHashSet<Integer>();
        LinkedHashSet<GraphLink> linkSet = new LinkedHashSet<GraphLink>();
        this.growGraph(this.targetIndex, sortedLinks, nodeSet, linkSet);
        this.addLinks(sortedLinks, nodeSet, linkSet);
        return new Tuple(new ArrayList<Integer>(nodeSet), new ArrayList<GraphLink>(linkSet));
    }

    private List<GraphLink> buildInputLinks() {
        ArrayList<GraphLink> inputLinks = new ArrayList<GraphLink>();
        int N = this.table.getNumCols();
        double[][] data = this.table.getData();
        for (int a = 0; a < N; ++a) {
            for (int b = a + 1; b < N; ++b) {
                double s = data[a][b];
                if (!(s >= this.minStrength) || !(s > 0.0)) continue;
                inputLinks.add(new GraphLink(a, b, s, this.targetIndex));
            }
        }
        return inputLinks.stream().sorted(GraphLink::sortPrioritizingTarget).collect(Collectors.toList());
    }

    private void growGraph(int targetIndex, List<GraphLink> sortedLinks, Set<Integer> nodeSet, Set<GraphLink> linkSet) {
        nodeSet.add(targetIndex);
        boolean nodeAdded = true;
        while (nodeAdded && nodeSet.size() < this.maxNodes) {
            nodeAdded = false;
            Iterator<GraphLink> it = sortedLinks.iterator();
            while (it.hasNext() && !nodeAdded) {
                GraphLink link = it.next();
                if (nodeSet.contains(link.a) && !nodeSet.contains(link.b)) {
                    nodeSet.add(link.b);
                    linkSet.add(link);
                    nodeAdded = true;
                    it.remove();
                    continue;
                }
                if (!nodeSet.contains(link.b) || nodeSet.contains(link.a)) continue;
                nodeSet.add(link.a);
                linkSet.add(link);
                nodeAdded = true;
                it.remove();
            }
        }
    }

    private void addLinks(List<GraphLink> sortedLinks, Set<Integer> nodeSet, Set<GraphLink> linkSet) {
        Iterator<GraphLink> it = sortedLinks.iterator();
        while (it.hasNext() && linkSet.size() < this.maxLinks) {
            GraphLink link = it.next();
            if (!nodeSet.contains(link.a) || !nodeSet.contains(link.b)) continue;
            linkSet.add(link);
        }
    }

    static class GraphLink {
        public final int a;
        public final int b;
        public final double strength;
        public final boolean containsTarget;

        GraphLink(int a, int b, double strength, int target) {
            this.a = a;
            this.b = b;
            this.strength = strength;
            this.containsTarget = a == target || b == target;
        }

        public String toString() {
            return this.a + "<->" + this.b + " " + this.strength;
        }

        public boolean equals(Object o) {
            if (!(o instanceof GraphLink)) {
                return false;
            }
            GraphLink other = (GraphLink)o;
            return this.a == other.a && this.b == other.b;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.a;
            result = 31 * result + this.b;
            return result;
        }

        static int sortPrioritizingTarget(GraphLink l0, GraphLink l1) {
            if (l0.containsTarget && !l1.containsTarget) {
                return -1;
            }
            if (!l0.containsTarget && l1.containsTarget) {
                return 1;
            }
            int v = Double.compare(l1.strength, l0.strength);
            if (v != 0) {
                return v;
            }
            v = Integer.compare(l0.a, l1.a);
            if (v != 0) {
                return v;
            }
            return Integer.compare(l0.b, l1.b);
        }
    }
}

