/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.visrecommender;

import com.ibm.bi.predict.explore.visrecommender.ChartType;
import com.ibm.bi.predict.types.DataItem;
import com.ibm.bi.predict.types.Slot;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class VisRecommendation {
    public static final String CHARTTYPE_KEY = "chartType";
    public static final String DATAITEMS_KEY = "dataItems";
    public static final String SLOTMAPPING_KEY = "slotmapping";
    public static final String SLOTS_KEY = "slots";
    public static final String ANNOTATIONS_KEY = "annotations";
    private final ChartType chartType;
    private final List<DataItem> dataItems;
    private final List<Slot> slotMappings;
    private final List<String> annotations;

    public VisRecommendation(ChartType chartType, List<DataItem> dataItems, List<Slot> slotMappings, List<String> annotations) {
        this.chartType = chartType;
        this.dataItems = dataItems;
        this.slotMappings = slotMappings;
        this.annotations = annotations;
    }

    public ChartType getChartType() {
        return this.chartType;
    }

    public List<DataItem> getDataItems() {
        return this.dataItems;
    }

    public List<Slot> getSlotMappings() {
        return this.slotMappings;
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject o = new JSONObject();
        o.put(CHARTTYPE_KEY, (Object)this.chartType.toString());
        JSONArray a = new JSONArray();
        for (DataItem i : this.dataItems) {
            a.add((Object)i.toJSON());
        }
        o.put(DATAITEMS_KEY, (Collection)a);
        a = new JSONArray();
        for (Slot s : this.slotMappings) {
            a.add((Object)s.toJSON());
        }
        JSONObject s = new JSONObject();
        s.put(SLOTS_KEY, (Collection)a);
        o.put(SLOTMAPPING_KEY, (Map)s);
        o.put(ANNOTATIONS_KEY, (Collection)new JSONArray(this.annotations));
        return o;
    }
}

