/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.visrecommender;

import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.explore.visrecommender.VisRecommendation;
import com.ibm.bi.predict.explore.visrecommender.rules.VisRecommenderResource;
import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationData;
import com.ibm.bi.predict.sa.suggestion.api.request.AnnotationRequest;
import com.ibm.bi.predict.sa.suggestion.domain.Annotations;
import com.ibm.bi.predict.sa.suggestion.service.AnnotationService;
import com.ibm.bi.predict.sa.suggestion.service.AnnotationsGenerator;
import com.ibm.bi.predict.sa.suggestion.service.DefinitionDrivenAnnotationService;
import com.ibm.bi.predict.sa.suggestion.service.DefinitionLoader;
import com.ibm.bi.predict.sa.suggestion.service.JsonFileDefinitionLoader;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class VisRecommender {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(VisRecommender.class);
    private final AnnotationService service = this.createService();
    private final Locale locale;
    private final Map<String, DataColumn.ColumnMeta> fieldInfo;

    public VisRecommender(List<DataColumn.ColumnMeta> fields, Locale locale) {
        this.locale = locale;
        this.fieldInfo = new HashMap<String, DataColumn.ColumnMeta>();
        fields.stream().forEach(fi -> this.fieldInfo.put(fi.getId(), (DataColumn.ColumnMeta)fi));
    }

    private AnnotationService createService() {
        return new DefinitionDrivenAnnotationService((DefinitionLoader)new JsonFileDefinitionLoader(), new AnnotationsGenerator());
    }

    public List<VisRecommendation> oneway(String targetId, String driverId) {
        return this.recommend("oneway", targetId, new String[]{driverId});
    }

    public List<VisRecommendation> twoway(String targetId, String driverId0, String driverId1) {
        return this.recommend("twoway", targetId, new String[]{driverId0, driverId1});
    }

    public List<VisRecommendation> tree(String targetId, String[] driverIds) {
        return this.recommend("tree", targetId, driverIds);
    }

    private List<VisRecommendation> recommend(String type, String targetId, String[] driverIds) {
        DataColumn.ColumnMeta targetInfo = this.fieldInfo.get(targetId);
        if (targetInfo == null) {
            LOGGER.warn("VISREC: recommendation for {} driver with unknown targetId {}", (Object)type, (Object)targetId);
            return Collections.emptyList();
        }
        ArrayList<DataColumn.ColumnMeta> driversInfo = new ArrayList<DataColumn.ColumnMeta>();
        for (String driverId : driverIds) {
            DataColumn.ColumnMeta driverInfo = this.fieldInfo.get(driverId);
            if (driverInfo == null) {
                LOGGER.warn("VISREC: recommendation for {} driver with unknown driverId {}", (Object)type, (Object)driverId);
                return Collections.emptyList();
            }
            driversInfo.add(driverInfo);
        }
        List<VisRecommendation> result = VisRecommenderResource.getRules().getRecommendations(type, targetInfo, driversInfo);
        if (!"tree".equals(type)) {
            result.forEach(this::addAnnotations);
        }
        return result;
    }

    private void addAnnotations(VisRecommendation rec) {
        Annotations suggestions = this.service.getSuitableAnnotations(VisRecommender.buildRequest(rec), this.locale);
        List annotations = suggestions.annotations.stream().map(v -> v.getType()).collect(Collectors.toList());
        rec.getAnnotations().addAll(annotations);
    }

    static AnnotationRequest buildRequest(VisRecommendation rec) {
        AnnotationRequest request = new AnnotationRequest();
        request.setVersion("0.0.1");
        request.setData(Collections.singletonList(new AnnotationData("a generated ID", rec.getDataItems())));
        request.setUse(rec.getSlotMappings());
        return request;
    }
}

