/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.visrecommender.rules;

import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.explore.visrecommender.ChartType;
import com.ibm.bi.predict.explore.visrecommender.VisRecommendation;
import com.ibm.bi.predict.explore.visrecommender.rules.VisRecommenderSlot;
import com.ibm.bi.predict.types.DataItem;
import com.ibm.bi.predict.types.Slot;
import com.ibm.bi.predict.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;

class VisRecommenderChart {
    static final String CHARTTYPE_KEY = "chartType";
    static final String SLOTS_KEY = "slots";
    final ChartType chartType;
    final List<VisRecommenderSlot> slotAssignments;

    VisRecommenderChart(ChartType chartType, List<VisRecommenderSlot> slotAssignments) {
        this.chartType = chartType;
        this.slotAssignments = slotAssignments;
    }

    VisRecommendation createChart(DataColumn.ColumnMeta target, List<DataColumn.ColumnMeta> drivers) {
        ArrayList<DataItem> dataItems = new ArrayList<DataItem>();
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < this.slotAssignments.size(); ++i) {
            this.slotAssignments.get(i).createDataItemsAndSlot(i, target, drivers, dataItems, slots);
        }
        return new VisRecommendation(this.chartType, dataItems, slots, new ArrayList<String>());
    }

    static VisRecommenderChart fromJSON(JSONObject obj) {
        try {
            ChartType chartType = ChartType.fromString(JsonUtils.getRequiredString((JSONObject)obj, (String)CHARTTYPE_KEY));
            if (chartType == null) {
                throw new RuntimeException("Unknown chart type");
            }
            JSONArray a = JsonUtils.getRequiredJSONArray((JSONObject)obj, (String)SLOTS_KEY);
            ArrayList<VisRecommenderSlot> slots = new ArrayList<VisRecommenderSlot>();
            for (int i = 0; i < a.size(); ++i) {
                slots.add(VisRecommenderSlot.fromJSON(JsonUtils.getRequiredJSONObject((JSONArray)a, (int)i, (String)SLOTS_KEY)));
            }
            return new VisRecommenderChart(chartType, slots);
        }
        catch (Exception e) {
            throw new BadParametersException("Parsing recommendation: " + e.getMessage(), (Throwable)e);
        }
    }
}

