/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.visrecommender.rules;

import com.google.common.collect.Sets;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.explore.visrecommender.VisRecommendation;
import com.ibm.bi.predict.explore.visrecommender.rules.VisRecommenderRule;
import com.ibm.bi.predict.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;

public class VisRecommenderRuleset {
    static final String RULES_KEY = "rules";
    private final Map<String, List<VisRecommenderRule>> ruleset = new HashMap<String, List<VisRecommenderRule>>();
    public static final String ONEWAY = "oneway";
    public static final String TWOWAY = "twoway";
    public static final String TREE = "tree";

    VisRecommenderRuleset() {
    }

    public List<VisRecommenderRule> getRules(String type) {
        return this.ruleset.getOrDefault(type, Collections.emptyList());
    }

    int size() {
        int s = 0;
        for (List<VisRecommenderRule> v : this.ruleset.values()) {
            s += v.size();
        }
        return s;
    }

    public List<VisRecommendation> getRecommendations(String type, DataColumn.ColumnMeta target, List<DataColumn.ColumnMeta> drivers) {
        for (VisRecommenderRule rule : this.getRules(type)) {
            Optional<List<VisRecommendation>> rec = rule.getRecommendations(type, target, drivers);
            if (!rec.isPresent()) continue;
            return rec.get();
        }
        return Collections.emptyList();
    }

    public static VisRecommenderRuleset fromJSON(JSONObject obj) {
        try {
            HashSet allowedRules = Sets.newHashSet((Object[])new String[]{ONEWAY, TWOWAY, TREE});
            VisRecommenderRuleset ruleset = new VisRecommenderRuleset();
            JSONArray a = JsonUtils.getRequiredJSONArray((JSONObject)obj, (String)RULES_KEY);
            for (int i = 0; i < a.size(); ++i) {
                JSONObject o = JsonUtils.getRequiredJSONObject((JSONArray)a, (int)i, (String)RULES_KEY);
                VisRecommenderRule rule = VisRecommenderRule.fromJSON(o);
                if (!allowedRules.contains(rule.getType())) {
                    throw new BadParametersException("Unknown rule type " + rule.getType());
                }
                List rules = ruleset.ruleset.computeIfAbsent(rule.getType(), t -> new ArrayList());
                rules.add(rule);
            }
            return ruleset;
        }
        catch (Exception e) {
            throw new BadParametersException("Parsing visualization recommendations: " + e.getMessage(), (Throwable)e);
        }
    }
}

