/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.visrecommender.rules;

import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.explore.visrecommender.rules.VisRecommenderMetadata;
import com.ibm.bi.predict.utils.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;

class VisRecommenderWhen {
    static final String TYPE_KEY = "type";
    static final String TARGET_KEY = "target";
    static final String DRIVERS_KEY = "drivers";
    final String type;
    final VisRecommenderMetadata target;
    final List<VisRecommenderMetadata> drivers;

    VisRecommenderWhen(String type, VisRecommenderMetadata target, List<VisRecommenderMetadata> drivers) {
        this.type = type;
        this.target = target;
        this.drivers = drivers;
    }

    static VisRecommenderWhen fromJSON(JSONObject obj) {
        try {
            String type = JsonUtils.getRequiredString((JSONObject)obj, (String)TYPE_KEY);
            VisRecommenderMetadata target = VisRecommenderMetadata.fromJSON(JsonUtils.getRequiredJSONObject((JSONObject)obj, (String)TARGET_KEY));
            ArrayList<VisRecommenderMetadata> drivers = new ArrayList<VisRecommenderMetadata>();
            JSONArray a = JsonUtils.getRequiredJSONArray((JSONObject)obj, (String)DRIVERS_KEY);
            for (int i = 0; i < a.size(); ++i) {
                drivers.add(VisRecommenderMetadata.fromJSON(JsonUtils.getRequiredJSONObject((JSONArray)a, (int)i, (String)DRIVERS_KEY)));
            }
            return new VisRecommenderWhen(type, target, drivers);
        }
        catch (Exception e) {
            throw new BadParametersException("Parsing visualization recommendation input pattern: " + e.getMessage(), (Throwable)e);
        }
    }

    Optional<List<DataColumn.ColumnMeta>> matches(String type, DataColumn.ColumnMeta target, List<DataColumn.ColumnMeta> drivers) {
        if (!this.type.equals(type)) {
            return Optional.empty();
        }
        switch (this.type) {
            case "oneway": {
                return this.onewayMatch(target, drivers.get(0));
            }
            case "twoway": {
                return this.twowayMatch(target, drivers.get(0), drivers.get(1));
            }
            case "tree": {
                return this.treeMatch(target, drivers);
            }
        }
        return Optional.empty();
    }

    private Optional<List<DataColumn.ColumnMeta>> onewayMatch(DataColumn.ColumnMeta target, DataColumn.ColumnMeta driver) {
        if (this.target.matches(target) && this.drivers.get(0).matches(driver)) {
            return Optional.of(Arrays.asList(driver));
        }
        return Optional.empty();
    }

    private Optional<List<DataColumn.ColumnMeta>> twowayMatch(DataColumn.ColumnMeta target, DataColumn.ColumnMeta driver0, DataColumn.ColumnMeta driver1) {
        if (this.target.matches(target)) {
            if (this.drivers.get(0).matches(driver0) && this.drivers.get(1).matches(driver1)) {
                return Optional.of(Arrays.asList(driver0, driver1));
            }
            if (this.drivers.get(0).matches(driver1) && this.drivers.get(1).matches(driver0)) {
                return Optional.of(Arrays.asList(driver1, driver0));
            }
        }
        return Optional.empty();
    }

    private Optional<List<DataColumn.ColumnMeta>> treeMatch(DataColumn.ColumnMeta target, List<DataColumn.ColumnMeta> drivers) {
        if (this.target.matches(target)) {
            return Optional.of(drivers);
        }
        return Optional.empty();
    }
}

