/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.forecasting;

import com.google.common.collect.Sets;
import com.ibm.bi.predict.algorithms.forecasting.concepts.ConceptUtils;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersExceptionKey;
import com.ibm.bi.predict.algorithms.forecasting.result.SeriesResult;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeIndexMapper;
import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.exceptions.PredictException;
import com.ibm.bi.predict.forecasting.ForecastingContext;
import com.ibm.bi.predict.source.ColumnGroup;
import com.ibm.bi.predict.source.TwoDimensionalList;
import com.ibm.bi.predict.source.jsonstat.ColumnGroupType;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class DataReader {
    private static final Logger LOG = PredictLoggerFactory.getLogger(DataReader.class);
    public static final String NULL_HIERARCHY_KEY = "0";
    private static final Category NULL_HIERARCHY_CATEGORY = Category.forString((String)"0", (int)0);
    private static final int MINIMUM_SERIES_LENGTH = 5;
    private static final double MISSING_VALUE_THRESHOLD = 0.33;

    private DataReader() {
    }

    public static Map<String, SeriesResult> makeSeries(List<DataColumn> columns, ForecastingContext context, List<ColumnGroup> groups) {
        DataColumn timeColumn = DataReader.getTimeColumn(context);
        DataColumn valueColumn = DataReader.getValueColumn(context, columns, groups);
        List<DataColumn> seriesColumns = DataReader.getSeriesColumn(context, columns, groups);
        return DataReader.makeSeries(context, timeColumn, valueColumn, seriesColumns);
    }

    public static Map<String, SeriesResult> makeSeries(List<DataColumn> columns, ForecastingContext context) {
        DataColumn timeColumn = DataReader.getTimeColumn(context);
        DataColumn valueColumn = DataReader.getValueColumn(context, columns);
        List<DataColumn> seriesColumns = DataReader.getSeriesColumn(context, columns, context.getColumnGroups());
        return DataReader.makeSeries(context, timeColumn, valueColumn, seriesColumns);
    }

    private static Map<String, SeriesResult> makeSeries(ForecastingContext context, DataColumn timeColumn, DataColumn valueColumn, List<DataColumn> seriesColumns) {
        int timeCategoryIndex;
        List<Category> orderedTimeCategories = DataReader.getOrderedCategoryList(timeColumn);
        TimeIndexMapper timeMapper = new TimeIndexMapper(context.getTimeDimension(), timeColumn);
        context.getTimeDimension().setTimeIndexMapper(timeMapper);
        long numberOfTimePoints = DataReader.getNumberOfTimePointsToConsider(timeColumn, context, timeMapper);
        context.getTimeDimension().setIsSeriesTooShort(DataReader.isSeriesTooShort(context, numberOfTimePoints, timeMapper.missingCountTo(numberOfTimePoints - 1L)));
        Map<String, SeriesResult> seriesMap = DataReader.getSeriesMap(context, seriesColumns, timeColumn, timeMapper, valueColumn.getId());
        for (int rowIndex = 0; rowIndex < valueColumn.rowCount() && (long)(timeCategoryIndex = (int)DataReader.rowIndexToTimeCategoryIndex(timeColumn, orderedTimeCategories, timeMapper, rowIndex)) < numberOfTimePoints; ++rowIndex) {
            SeriesResult seriesResult = DataReader.getSeriesResult(seriesColumns, seriesMap, rowIndex);
            int missingCount = seriesResult.getHistoricalValuesMissingCount();
            double metricValue = valueColumn.getValue(rowIndex);
            if (!Double.isNaN(seriesResult.getHistoricalValues()[timeCategoryIndex])) {
                LOG.error("Found multiple metric values for the same series category for a particular time point");
                throw new ForecastingParametersException("Found multiple metric values for the same series category for a particular time point", ForecastingParametersExceptionKey.MULTIPLE_VALUES);
            }
            if (!Double.isNaN(metricValue)) {
                --missingCount;
            }
            seriesResult.getHistoricalValues()[timeCategoryIndex] = metricValue;
            seriesResult.setHistoricalValuesMissingCount(missingCount);
        }
        return seriesMap;
    }

    protected static boolean isSeriesTooShort(ForecastingContext context, long numberOfTimePoints, long missingTimeValues) {
        int minSeriesLength = context.getInt("forecast.config.minimumSeriesLength", 5);
        double missingValueThreshold = context.getDouble("forecast.config.missingValueThreshold", 0.33);
        int maxMissingAllowed = (int)((double)numberOfTimePoints * missingValueThreshold);
        return numberOfTimePoints < (long)minSeriesLength || missingTimeValues > (long)maxMissingAllowed;
    }

    private static long rowIndexToTimeCategoryIndex(DataColumn timeColumn, List<Category> orederedTimeCategories, TimeIndexMapper timeMapper, int rowIndex) {
        Category timeCategory = DataReader.getCategory(timeColumn, rowIndex);
        return timeMapper.toTimeIndex(orederedTimeCategories.indexOf(timeCategory));
    }

    private static List<Category> getOrderedCategoryList(DataColumn timeColumn) {
        LinkedHashSet<Category> categories = new LinkedHashSet<Category>();
        for (int i = 0; i < timeColumn.rowCount(); ++i) {
            categories.add(timeColumn.getCategory((int)timeColumn.getValue(i)));
        }
        return new ArrayList<Category>(categories);
    }

    private static SeriesResult getSeriesResult(List<DataColumn> seriesColumns, Map<String, SeriesResult> seriesMap, int rowIndex) {
        if (seriesColumns.isEmpty()) {
            return seriesMap.get(NULL_HIERARCHY_KEY);
        }
        int[] sizes = seriesColumns.stream().map(DataColumn::getCategories).mapToInt(List::size).toArray();
        int[] indices = seriesColumns.stream().mapToInt(d -> (int)d.getValue(rowIndex)).toArray();
        return seriesMap.get(DataReader.getSeriesIdentifierString(indices, sizes));
    }

    private static DataColumn getTimeColumn(ForecastingContext context) {
        TimeDimension time = context.getTimeDimension();
        DataColumn timeColumn = time.consolidate();
        return timeColumn.reorder(time.getRowOrder());
    }

    private static DataColumn getValueColumn(ForecastingContext context, List<DataColumn> columns) {
        int metricColumnIndex = (Integer)context.getIntList("target", new ArrayList()).get(0);
        DataColumn metricColumn = columns.get(metricColumnIndex);
        TimeDimension time = context.getTimeDimension();
        return metricColumn.copyWithoutRows((Collection)time.getInvalidRowIndices()).reorder(time.getRowOrder());
    }

    private static DataColumn getValueColumn(ForecastingContext context, List<DataColumn> columns, List<ColumnGroup> groups) {
        int[] valueColumnIndices = ColumnGroup.columnsIndices(groups, (Set)Sets.newHashSet((Object[])new Enum[]{ColumnGroupType.VALUE}));
        DataColumn valueColumn = columns.get(valueColumnIndices[0]);
        TimeDimension time = context.getTimeDimension();
        return valueColumn.copyWithoutRows((Collection)time.getInvalidRowIndices()).reorder(time.getRowOrder());
    }

    private static List<DataColumn> getSeriesColumn(ForecastingContext context, List<DataColumn> columns, List<ColumnGroup> groups) {
        int[] seriesColumnIndices = ColumnGroup.columnsIndices(groups, (Set)Sets.newHashSet((Object[])new Enum[]{ColumnGroupType.OTHER, ColumnGroupType.METRIC}));
        if (seriesColumnIndices.length == 0) {
            return Collections.emptyList();
        }
        TimeDimension time = context.getTimeDimension();
        ArrayList<DataColumn> seriesColumns = new ArrayList<DataColumn>();
        for (int col : seriesColumnIndices) {
            DataColumn seriesColumn = columns.get(col);
            seriesColumns.add(seriesColumn.copyWithoutRows((Collection)time.getInvalidRowIndices()).reorder(time.getRowOrder()));
        }
        return seriesColumns;
    }

    private static List<Category> getSeriesCategories(List<DataColumn> seriesColumns) {
        if (seriesColumns.isEmpty()) {
            return Collections.singletonList(NULL_HIERARCHY_CATEGORY);
        }
        List categories = seriesColumns.stream().map(DataColumn::getCategories).collect(Collectors.toList());
        int[] sizes = categories.stream().mapToInt(List::size).toArray();
        return new TwoDimensionalList(categories).crossjoin((l, i) -> DataReader.combineCategories(l, i, sizes));
    }

    private static Category combineCategories(List<Category> categories, int[] indices, int[] sizes) {
        String combinedCategoryName = categories.stream().map(Category::toString).collect(Collectors.joining("|"));
        AggregationType aggType = categories.stream().map(Category::getAggregationType).filter(t -> t != null).findFirst().orElse(null);
        return Category.forString((String)combinedCategoryName, (int)DataReader.toOrdinal(indices, sizes)).setAggregationType(aggType);
    }

    private static Map<String, SeriesResult> getSeriesMap(ForecastingContext context, List<DataColumn> seriesColumns, DataColumn timeColumn, TimeIndexMapper timeMapper, String fieldId) {
        int numberOfTimePoints = (int)DataReader.getNumberOfTimePointsToConsider(timeColumn, context, timeMapper);
        int[] columns = seriesColumns.stream().mapToInt(DataColumn::getIndex).toArray();
        HashMap<String, SeriesResult> seriesMap = new HashMap<String, SeriesResult>();
        List<Category> seriesCategories = DataReader.getSeriesCategories(seriesColumns);
        int numberOfSeriesCategories = seriesCategories.size();
        DataReader.updateTimeDimension(context, numberOfTimePoints, numberOfSeriesCategories);
        IntStream.range(0, numberOfSeriesCategories).forEach(i -> {
            double[] historical = DataReader.makeHistoricalDataArray(numberOfTimePoints);
            Category seriesCategory = (Category)seriesCategories.get(i);
            SeriesResult seriesResult = DataReader.makeSeriesResult(numberOfTimePoints, historical, columns, seriesCategory, context);
            seriesResult.setFieldId(fieldId);
            seriesMap.put(seriesResult.id(), seriesResult);
        });
        return seriesMap;
    }

    private static boolean isNullHierarchyCategory(Category c) {
        return c == NULL_HIERARCHY_CATEGORY;
    }

    private static void updateTimeDimension(ForecastingContext context, int numberOfTimePoints, int numberOfSeriesCategories) {
        TimeDimension timeDimension = context.getTimeDimension();
        timeDimension.setNumberOfTimePointsConsidered(numberOfTimePoints);
        timeDimension.setLastNPointsIgnored(context.getLastNPeriodsIgnored());
        context.setTimeDimension(timeDimension);
    }

    private static double[] makeHistoricalDataArray(int numHistoricalPoints) {
        double[] historical = new double[Math.max(0, numHistoricalPoints)];
        Arrays.fill(historical, Double.NaN);
        return historical;
    }

    private static SeriesResult makeSeriesResult(int numberOfTimePoints, double[] historical, int[] columns, Category seriesCategory, ForecastingContext context) {
        String identifier = DataReader.getCategoryIdentifierString(seriesCategory);
        String label = seriesCategory.toString();
        SeriesResult seriesResult = new SeriesResult(identifier, label, columns, new String[]{label}, DataReader.isNullHierarchyCategory(seriesCategory)).setHistoricalValues(historical).setHistoricalValuesMissingCount(numberOfTimePoints).setIgnoreLastNPeriods(context.getLastNPeriodsIgnored()).setAggregationType(seriesCategory.getAggregationType());
        DataReader.setUserInputs(seriesResult, context);
        return seriesResult;
    }

    private static long getNumberOfTimePointsToConsider(DataColumn timeColumn, ForecastingContext context, TimeIndexMapper timeMapper) {
        TimeDimension time = context.getTimeDimension();
        if (DataReader.isPeriodConcept(time)) {
            return Math.max(0, timeColumn.getCategories().size() - context.getLastNPeriodsIgnored());
        }
        return Math.max(0L, (long)(timeColumn.getNonEmptyCategoryCount() - context.getLastNPeriodsIgnored()) + timeMapper.missingCount());
    }

    private static boolean isPeriodConcept(TimeDimension time) {
        return Arrays.stream(time.allConcepts()).allMatch(ConceptUtils::isPeriodConcept);
    }

    private static SeriesResult setUserInputs(SeriesResult result, ForecastingContext context) {
        Optional confidenceLevel = context.getDoubleOpt("forecast.config.confidenceLevel");
        if (!confidenceLevel.isPresent()) {
            throw new PredictException(String.format("Confidence level should be set in configuration using property: %s", "forecast.config.confidenceLevel"));
        }
        return result.setConfidenceLevel(((Double)confidenceLevel.get()).doubleValue());
    }

    private static Category getCategory(DataColumn column, int index) {
        return column.getCategory((int)column.getValue(index));
    }

    private static String getCategoryIdentifierString(Category c) {
        return Integer.toString(c.identifier());
    }

    private static String getSeriesIdentifierString(int[] indices, int[] sizes) {
        return Integer.toString(DataReader.toOrdinal(indices, sizes));
    }

    private static int toOrdinal(int[] indices, int[] sizes) {
        int ord = 0;
        for (int i = 0; i < sizes.length; ++i) {
            ord = ord * sizes[i] + indices[i];
        }
        return ord;
    }
}

