/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.forecasting;

import com.ibm.bi.predict.algorithms.forecasting.ForecastingAlgorithmContext;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersExceptionKey;
import com.ibm.bi.predict.source.jsonstat.OutputFormatType;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.json.JSONObject;

public class ForecastingContext
extends ForecastingAlgorithmContext {
    private static final Logger LOG = PredictLoggerFactory.getLogger(ForecastingContext.class);
    private static final String AUTO = "auto";
    private static final double INVALID = -1.0;
    private static final Map<String, Number> CONFIDENCE_LEVELS = new HashMap<String, Number>();
    private static final int DEFAULT_IGNORE_LAST_N_PERIODS = 0;
    protected static final boolean DEFAULT_INCLUDE_STATISTICAL_DETAILS = true;
    protected static final boolean DEFAULT_INCLUDE_CONFIDENCE_INTERVALS = true;

    public ForecastingContext mixinParameters(JSONObject params) {
        super.mixinParameters(params);
        this.setModelOptions((Map<String, Object>)params);
        return this;
    }

    public ForecastingContext setModelOptions(Map<String, Object> map) {
        this.setConfidenceLevel(ForecastingContext.strippedKey("forecast.config.confidenceLevel"), map);
        this.setModelName(map);
        this.setIncludeStatisticalDetails(map);
        this.setIncludeConfidenceIntervals(map);
        this.setIntegerOrAuto(ForecastingContext.strippedKey("forecast.config.forecastPeriods"), "forecast.config.forecastPeriods", map);
        this.setIntegerOrAuto(ForecastingContext.strippedKey("forecast.config.seasonalityPeriod"), "forecast.config.seasonalityPeriod", map);
        this.setIfPresent("forecast.config.seasonalityType", map);
        this.setIfPresent("forecast.config.trendType", map);
        this.setIfPresent("forecast.config.ignoreLastNPeriods", map);
        this.setIfPresent("forecast.config.missingValueThreshold", map);
        this.setIfPresent("forecast.config.outputFormat", map);
        this.setIfPresent("forecast.config.includeOutliers", map);
        return this;
    }

    protected String configPrefix() {
        return "forecast.config.";
    }

    public int getLastNPeriodsIgnored() {
        return this.getInt("forecast.config.ignoreLastNPeriods", 0);
    }

    public boolean getIncludeStatisticalDetails() {
        return this.getBoolean("forecast.config.includeStatisticalDetails", true);
    }

    public boolean getIncludeConfidenceIntervals() {
        return this.getBoolean("forecast.config.includeConfidenceIntervals", true);
    }

    public OutputFormatType getOutputFormat() {
        String outputFormat = this.getString("forecast.config.outputFormat", AUTO);
        try {
            return OutputFormatType.fromString((String)outputFormat);
        }
        catch (IllegalArgumentException e) {
            String errorString = String.format("Unknown output format: %s", outputFormat);
            LOG.warn(errorString, (Throwable)e);
            throw new ForecastingParametersException(errorString, ForecastingParametersExceptionKey.OUTPUT_FORMAT);
        }
    }

    private void setIntegerOrAuto(String strippedKey, String key, Map<String, Object> map) {
        if (map.containsKey(strippedKey)) {
            Object value = map.get(strippedKey);
            if (value instanceof Integer) {
                this.setValue(key, value);
            } else if (value instanceof String && !AUTO.equals(value)) {
                this.setValue(key, -1.0);
            } else if (!(value instanceof String)) {
                this.setValue(key, -1.0);
            }
        } else {
            LOG.info("No model option passed for {}, default value will be used.", (Object)strippedKey);
        }
    }

    private void setConfidenceLevel(String strippedKey, Map<String, Object> map) {
        if (map.containsKey(strippedKey)) {
            Object value = map.get(strippedKey);
            if (value instanceof String) {
                this.setValue("forecast.config.confidenceLevel", CONFIDENCE_LEVELS.getOrDefault(map.get(strippedKey), -1.0));
            } else if (value instanceof Number) {
                value = ((Number)value).doubleValue() / 100.0;
                this.setValue("forecast.config.confidenceLevel", value);
            }
        } else {
            LOG.info("No model option passed for {}, default value will be used.", (Object)strippedKey);
        }
    }

    private void setModelName(Map<String, Object> modelOptions) {
        String modelType = (String)modelOptions.get(ForecastingContext.strippedKey("forecast.config.modelName"));
        if (!ForecastingContext.isAuto(modelType)) {
            super.setModelType(modelType);
        }
    }

    private void setIncludeStatisticalDetails(Map<String, Object> modelOptions) {
        String key = ForecastingContext.strippedKey("forecast.config.includeStatisticalDetails");
        Object value = modelOptions.getOrDefault(key, true);
        if (!(value instanceof Boolean)) {
            throw new ForecastingParametersException("Output option includeStatisticalDetails is not a valid boolean value", ForecastingParametersExceptionKey.INCLUDE_STATISTICAL_DETAILS);
        }
        this.setValue("forecast.config.includeStatisticalDetails", value);
    }

    private void setIncludeConfidenceIntervals(Map<String, Object> modelOptions) {
        String key = ForecastingContext.strippedKey("forecast.config.includeConfidenceIntervals");
        Object value = modelOptions.getOrDefault(key, true);
        if (!(value instanceof Boolean)) {
            throw new ForecastingParametersException("Output option includeStatisticalDetails is not a valid boolean value", ForecastingParametersExceptionKey.INCLUDE_STATISTICAL_DETAILS);
        }
        this.setValue("forecast.config.includeConfidenceIntervals", value);
    }

    static String strippedKey(String key) {
        String prefix = "forecast.config.";
        if (key.startsWith(prefix)) {
            return key.substring(prefix.length(), key.length());
        }
        return key;
    }

    private static boolean isAuto(String value) {
        return value == null || AUTO.equals(value);
    }

    static {
        CONFIDENCE_LEVELS.put("90", 0.9);
        CONFIDENCE_LEVELS.put("95", 0.95);
        CONFIDENCE_LEVELS.put("99", 0.99);
    }
}

