/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.forecasting;

import com.ibm.bi.predict.algorithms.forecasting.result.ForecastingResult;
import com.ibm.bi.predict.algorithms.forecasting.result.ForecastingResultData;
import com.ibm.bi.predict.algorithms.forecasting.result.ForecastingStatisticalDetails;
import com.ibm.bi.predict.algorithms.forecasting.result.ModelValue;
import com.ibm.bi.predict.algorithms.forecasting.result.SeriesResult;
import com.ibm.bi.predict.dataaccess.json.JsonHelpers;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.forecasting.ForecastingContext;
import com.ibm.bi.predict.result.Message;
import com.ibm.bi.predict.result.StatusCode;
import com.ibm.bi.predict.service.DataProvider;
import com.ibm.bi.predict.service.PredictServiceResponse;
import com.ibm.bi.predict.source.Category;
import com.ibm.bi.predict.source.ColumnFormat;
import com.ibm.bi.predict.source.ColumnGroup;
import com.ibm.bi.predict.source.ColumnIdentifier;
import com.ibm.bi.predict.source.ColumnMetaData;
import com.ibm.bi.predict.source.DataSource;
import com.ibm.bi.predict.source.Row;
import com.ibm.bi.predict.source.SourceMetaData;
import com.ibm.bi.predict.source.jsonstat.ColumnGroupType;
import com.ibm.bi.predict.source.jsonstat.OutputFormatType;
import com.ibm.bi.predict.source.writer.JsonStatWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class TimeSeriesResult
implements PredictServiceResponse {
    private final DataProvider dataProvider;
    private final ForecastingResult result;
    private final ForecastingContext context;

    public TimeSeriesResult(DataProvider dataProvider, ForecastingResult result, ForecastingContext context) {
        this.dataProvider = dataProvider;
        this.result = result;
        this.context = context;
    }

    public PredictServiceResponse.HttpStatusCode getResponseCode() {
        return this.result.getStatus() == StatusCode.FAILURE ? PredictServiceResponse.HttpStatusCode.ERROR : PredictServiceResponse.HttpStatusCode.SUCCESS;
    }

    public JSONObject getResponseBody() throws JSONException {
        JSONObject json = new JSONObject();
        JSONObject statusObject = new JSONObject();
        JSONObject resultObject = new JSONObject();
        statusObject.put("state", (Object)this.result.getStatus().toString());
        statusObject.put("warnings", (Collection)this.serializeMessages(this.result.getWarningMessages()));
        statusObject.put("errors", (Collection)this.serializeMessages(this.result.getErrorMessages()));
        statusObject.put("diagnostics", (Collection)new JSONArray((Collection)this.result.getDiagnosticMessages()));
        DataSource dataSource = this.dataProvider.asDataSource();
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource is null");
        }
        ArrayList<SeriesResult> seriesResults = new ArrayList<SeriesResult>();
        ((ForecastingResultData)this.result.getContent()).getSeriesResults().forEach((k, v) -> seriesResults.add((SeriesResult)v));
        DataSource outputDataSource = TimeSeriesResult.outputDataSource(dataSource, seriesResults, this.context.getIncludeConfidenceIntervals());
        resultObject.put("forecast", (Map)JsonStatWriter.toJsonStat((DataSource)outputDataSource, (OutputFormatType)this.context.getOutputFormat()));
        if (this.context.getIncludeStatisticalDetails()) {
            resultObject.put("statisticalDetails", (Collection)this.getStatDetailsArray());
        }
        json.put("version", (Object)"1.0");
        json.put("predictStatus", (Map)statusObject);
        json.put("predictResults", (Map)resultObject);
        return json;
    }

    public ForecastingResult getResult() {
        return this.result;
    }

    private JSONArray getStatDetailsArray() {
        JSONArray statDetailsArray = new JSONArray();
        List seriesResults = ((ForecastingResultData)this.result.getContent()).getOrderedSeriesResults();
        for (SeriesResult sr : seriesResults) {
            ForecastingStatisticalDetails statisticalDetails = sr.getStatisticalDetails();
            if (statisticalDetails == null) continue;
            statDetailsArray.add((Object)statisticalDetails.get());
        }
        return statDetailsArray;
    }

    private static int forecastPeriods(List<SeriesResult> seriesResults) {
        int forecastPeriods = 0;
        for (SeriesResult sr : seriesResults) {
            if (sr.getForecastValues() == null) continue;
            forecastPeriods = sr.getForecastValues().length - sr.getForecastOffset();
            break;
        }
        return forecastPeriods;
    }

    public static DataSource outputDataSource(DataSource inputDataSource, List<SeriesResult> seriesResults, boolean includeConfidenceIntervals) {
        int leafTimeColumnIndex = TimeSeriesResult.leafTimeColumnIndex(inputDataSource.groups());
        int forecastPeriods = TimeSeriesResult.forecastPeriods(seriesResults);
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        for (ColumnMetaData inputColumn : inputDataSource.meta().columnMetaData()) {
            if (TimeSeriesResult.isTime(inputDataSource.groups(), inputColumn.identifier())) {
                if (leafTimeColumnIndex == inputColumn.identifier().index()) {
                    columns.add(TimeSeriesResult.getLeafTimeColumn(inputColumn, forecastPeriods));
                    continue;
                }
                columns.add(TimeSeriesResult.getNonLeafTimeColumn(inputColumn));
                continue;
            }
            columns.add(inputColumn);
        }
        columns.add(TimeSeriesResult.getForecastTypeColumn(columns.size(), includeConfidenceIntervals));
        SourceMetaData meta = new SourceMetaData(columns);
        List<Double> values = TimeSeriesResult.getValues(columns, leafTimeColumnIndex, seriesResults, includeConfidenceIntervals);
        Collection<Row> rows = TimeSeriesResult.getRows(columns, values);
        List groups = inputDataSource.groups().stream().filter(group -> !group.hasProperty((Enum)ColumnGroupType.OTHER)).collect(Collectors.toList());
        return new DataSource(meta, rows, groups);
    }

    private static ColumnMetaData getForecastTypeColumn(int colIndex, boolean includeConfidenceIntervals) {
        ArrayList<Category> categories = new ArrayList<Category>();
        if (includeConfidenceIntervals) {
            categories.add(new Category((Object)"forecastHighConfidence", "forecastHighConfidence"));
            categories.add(new Category((Object)"forecastValue", "forecastValue"));
            categories.add(new Category((Object)"forecastLowConfidence", "forecastLowConfidence"));
        } else {
            categories.add(new Category((Object)"forecastValue", "forecastValue"));
        }
        return new ColumnMetaData(ColumnIdentifier.make((String)"_forecast_type", (String)"_forecast_type", (int)colIndex), 1, FieldType.CATEGORICAL, AggregationType.NONE, categories, ColumnFormat.formatForString(), Collections.emptyMap());
    }

    private static ColumnMetaData getNonLeafTimeColumn(ColumnMetaData column) {
        Category t0 = new Category((Object)"t0", "t0");
        return new ColumnMetaData(column.identifier(), 1, column.type(), column.aggregation(), Arrays.asList(t0), column.format(), Collections.emptyMap());
    }

    private static ColumnMetaData getLeafTimeColumn(ColumnMetaData column, int forecastPeriods) {
        ArrayList<Category> categories = new ArrayList<Category>();
        for (int i = 0; i < forecastPeriods; ++i) {
            String id = "t" + i;
            Category cat = new Category((Object)id, id);
            categories.add(cat);
        }
        return new ColumnMetaData(column.identifier(), categories.size(), column.type(), column.aggregation(), categories, column.format(), Collections.emptyMap());
    }

    private static int leafTimeColumnIndex(List<ColumnGroup> groups) {
        ColumnGroup timeGroup = groups.stream().filter(group -> group.hasProperty((Enum)ColumnGroupType.TIME)).findFirst().get();
        return ((ColumnIdentifier)timeGroup.columns().get(timeGroup.columns().size() - 1)).index();
    }

    private static boolean isTime(List<ColumnGroup> groups, ColumnIdentifier identifier) {
        for (int i = 0; i < groups.size(); ++i) {
            ColumnGroup group = groups.get(i);
            if (!group.hasProperty((Enum)ColumnGroupType.TIME) || !group.columns().contains(identifier)) continue;
            return true;
        }
        return false;
    }

    private static List<Double> getValues(List<ColumnMetaData> columns, int leafTimeColumnIndex, List<SeriesResult> seriesResults, boolean includeConfidenceIntervals) {
        List<ColumnMetaData> seriesColumns = TimeSeriesResult.getSeriesColumns(columns, seriesResults);
        int totalSize = columns.stream().map(a -> a.categoryCount()).filter(n -> n > 0).reduce(1, (a, b) -> a * b);
        Double[] forecastData = new Double[totalSize];
        List<Integer> seriesColumnSizes = seriesColumns.stream().map(c -> c.categoryCount()).collect(Collectors.toList());
        for (int seriesIndex = 0; seriesIndex < seriesResults.size(); ++seriesIndex) {
            int forecastOffset;
            SeriesResult seriesResult = seriesResults.get(seriesIndex);
            ModelValue[] future = seriesResult.getForecastValues();
            if (future == null) continue;
            int seriesOrdinal = Integer.parseInt(seriesResult.id());
            int[] seriesIndices = TimeSeriesResult.indexToIndices(seriesOrdinal, seriesColumnSizes);
            int[] indices = new int[columns.size()];
            for (int j = 0; j < seriesColumns.size(); ++j) {
                int colIndex = seriesColumns.get(j).identifier().index();
                indices[colIndex] = seriesIndices[j];
            }
            for (int timeIndex = forecastOffset = seriesResult.getForecastOffset(); timeIndex < future.length; ++timeIndex) {
                indices[leafTimeColumnIndex] = timeIndex - forecastOffset;
                int ord = TimeSeriesResult.getOrdinal(columns, indices);
                if (includeConfidenceIntervals) {
                    forecastData[ord++] = future[timeIndex].getUpperBound();
                    forecastData[ord++] = future[timeIndex].getValue();
                    forecastData[ord] = future[timeIndex].getLowerBound();
                    continue;
                }
                forecastData[ord] = future[timeIndex].getValue();
            }
        }
        return Arrays.asList(forecastData);
    }

    private static List<ColumnMetaData> getSeriesColumns(List<ColumnMetaData> columns, List<SeriesResult> seriesResults) {
        if (seriesResults.isEmpty() || seriesResults.get(0).getColumns() == null) {
            return Collections.emptyList();
        }
        ArrayList<ColumnMetaData> seriesColumns = new ArrayList<ColumnMetaData>();
        for (int colIndex : seriesResults.get(0).getColumns()) {
            seriesColumns.add(columns.get(colIndex));
        }
        return seriesColumns;
    }

    private static int getOrdinal(List<ColumnMetaData> columns, int[] indices) {
        int ord = 0;
        for (int i = 0; i < columns.size(); ++i) {
            if (columns.get(i).categoryCount() <= 0) continue;
            ord = ord * columns.get(i).categoryCount() + indices[i];
        }
        return ord;
    }

    private static Collection<Row> getRows(final List<ColumnMetaData> columns, final List<Double> values) {
        final List sizes = columns.stream().map(column -> column.categoryCount()).collect(Collectors.toList());
        int totalSize = sizes.stream().filter(n -> n > 0).reduce(1, (a, b) -> a * b);
        return IntStream.range(0, totalSize).mapToObj(i -> {
            final int[] indices = TimeSeriesResult.indexToIndices(i, sizes);
            return new Row(){

                public double valueAt(int index) {
                    if (index >= indices.length) {
                        throw new IllegalArgumentException("Invalid index. Index exceeds size of indices - index=" + index);
                    }
                    if ((Integer)sizes.get(index) == 0) {
                        return values.get(i) == null ? Double.NaN : (Double)values.get(i);
                    }
                    return indices[index];
                }

                public Category categoryAt(int index) {
                    if (index >= indices.length) {
                        throw new IllegalArgumentException("Invalid index. Index exceeds size of indices - index=" + index);
                    }
                    int catIdx = indices[index];
                    List categories = ((ColumnMetaData)columns.get(index)).categories();
                    if (categories != null) {
                        return (Category)categories.get(catIdx);
                    }
                    throw new IllegalStateException("Cannot access categories of numeric field at position " + index);
                }
            };
        }).collect(Collectors.toList());
    }

    private static int[] indexToIndices(int index, List<Integer> sizes) {
        int[] indices = new int[sizes.size()];
        for (int j = sizes.size() - 1; j >= 0; --j) {
            if (sizes.get(j) == 0) continue;
            int idx = index;
            for (int p = j + 1; p < sizes.size(); ++p) {
                int n = p + 1 < sizes.size() ? sizes.get(p + 1) : 1;
                idx -= indices[p] * n;
            }
            indices[j] = idx / TimeSeriesResult.product(sizes, j + 1) % sizes.get(j);
        }
        return indices;
    }

    private static int product(List<Integer> l, int from) {
        return l.subList(from, l.size()).stream().filter(n -> n > 0).reduce(1, (a, b) -> a * b);
    }

    private JSONArray serializeMessages(List<Message> messages) {
        JSONArray serializedMessages = new JSONArray();
        messages.stream().map(this::serializeMessage).distinct().forEach(arg_0 -> ((JSONArray)serializedMessages).add(arg_0));
        return serializedMessages;
    }

    private JSONObject serializeMessage(Message message) {
        return JsonHelpers.makeObj((String)"id", (Object)message.getMessageCode().toString(), (String)"caption", (Object)message.getCaption());
    }
}

