/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.matrix;

import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.matrix.DiagMatrix;
import com.spss.math.matrix.LinpackD;
import com.spss.math.matrix.RectMatrix;
import com.spss.math.statistics.CCBitSet;
import com.spss.math.statistics.MathFun;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class DenseRectMatrix
implements RectMatrix,
Cloneable {
    private int nRows = 0;
    private int nCols = 0;
    private double[] mat = null;

    public DenseRectMatrix() {
        this.nRows = 0;
        this.nCols = 0;
    }

    public DenseRectMatrix(int nRows, int nCols) {
        this.nRows = nRows >= 0 ? nRows : 0;
        this.nCols = nCols >= 0 ? nCols : 0;
        this.mat = new double[nRows * nCols];
    }

    public DenseRectMatrix(DenseRectMatrix srcMat) {
        this.nRows = srcMat.nRows;
        this.nCols = srcMat.nCols;
        this.mat = Arrays.copyOf(srcMat.mat, srcMat.mat.length);
    }

    public boolean addToColumn(int iCol, DenseRectMatrix matR, int iColR, double coeff) {
        boolean result = false;
        int nRowsR = matR.getNRows();
        int nColsR = matR.getNCols();
        if (iCol >= 0 && iCol < this.nCols && iColR >= 0 && iColR < nColsR && nRowsR == this.nRows) {
            result = true;
            int index = iCol;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                int n = index;
                this.mat[n] = this.mat[n] + coeff * matR.getElem(iRow, iColR);
                index += this.nCols;
            }
        }
        return result;
    }

    public boolean addToColumn(int iCol, DenseRectMatrix matR, int iColR) {
        return this.addToColumn(iCol, matR, iColR, 1.0);
    }

    public void checkForOnes(double tol) {
        if (tol > 0.0) {
            for (int i = 0; i < this.mat.length; ++i) {
                double elem = this.mat[i];
                if (!(Math.abs(Math.abs(elem) - 1.0) < tol)) continue;
                this.mat[i] = elem > 0.0 ? 1.0 : -1.0;
            }
        }
    }

    public void clear() {
        Arrays.fill(this.mat, 0.0);
    }

    public boolean colClean(int iCol, double coeff) {
        boolean result = false;
        if (iCol >= 0 && iCol < this.nCols) {
            double coef1;
            double norm = this.colNorm(iCol);
            if (MathFun.qLReps(norm, coef1 = coeff * 10000.0)) {
                this.zeroOutCol(iCol);
            } else {
                this.colScale(iCol, 1.0 / norm);
                int index = iCol;
                for (int iRow = 0; iRow < this.nRows; ++iRow) {
                    double value = this.mat[index];
                    this.mat[index] = MathFun.qLReps(value, coef1) ? 0.0 : value * norm;
                    index += this.nCols;
                }
            }
            result = true;
        }
        return result;
    }

    public double colNorm(int iCol) {
        double result = MissingValue.getMissing();
        if (iCol >= 0 && iCol < this.nCols) {
            result = MathFun.dNrm2(this.nRows, this.mat, iCol, this.nCols);
        }
        return result;
    }

    public boolean colScale(int iCol, double coeff) {
        boolean result = false;
        if (iCol >= 0 && iCol < this.nCols) {
            int index = iCol;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                int n = index;
                this.mat[n] = this.mat[n] * coeff;
                index += this.nCols;
            }
            result = true;
        }
        return result;
    }

    public boolean computeLTRTrans(DenseSymMatrix mLT, DenseRectMatrix mOut) {
        boolean result;
        boolean bl = result = this.nRows == mLT.getNRows();
        if (result) {
            if (mOut.getNRows() != this.nRows || mOut.getNCols() != this.nCols) {
                mOut.resize(this.nRows, this.nCols);
            }
            double[] ltMat = mLT.getMatrix();
            int iLTStart = 0;
            double[] outMat = mOut.getMatrix();
            int iOut = 0;
            for (int iLT = 0; iLT < this.nRows; ++iLT) {
                int colStart = 0;
                for (int iCol = 0; iCol < this.nCols; ++iCol) {
                    double outElem = MathFun.dDot(iLT + 1, ltMat, iLTStart, 1, this.mat, colStart++, 1);
                    outMat[iOut++] = outElem;
                }
                iLTStart += iLT + 1;
            }
        }
        return result;
    }

    public boolean computeLTTransR(DenseSymMatrix mLT, DenseRectMatrix mOut) {
        boolean result;
        boolean bl = result = this.nRows == mLT.getNRows();
        if (result) {
            if (mOut.getNRows() != this.nRows || mOut.getNCols() != this.nCols) {
                mOut.resize(this.nRows, this.nCols);
            }
            double[] ltMat = mLT.getMatrix();
            double[] outMat = mOut.getMatrix();
            int iOut = 0;
            double[] work = new double[this.nRows];
            int iLTDiag = 0;
            int colStart = 0;
            for (int iLT = 0; iLT < this.nRows; ++iLT) {
                int nCopy = this.nRows - iLT;
                int iFrom = iLTDiag;
                for (int i = 0; i < nCopy; ++i) {
                    work[i] = ltMat[iFrom];
                    iFrom += iLT + i + 1;
                }
                for (int iCol = 0; iCol < this.nCols; ++iCol) {
                    double dotP = MathFun.dDot(nCopy, work, 0, 1, this.mat, colStart + iCol, this.nCols);
                    outMat[iOut++] = dotP;
                }
                iLTDiag += iLT + 2;
                colStart += this.nCols;
            }
        }
        return result;
    }

    public boolean computeMatrixProduct(DenseRectMatrix inpMatr, DenseRectMatrix outMatr) {
        boolean result;
        boolean bl = result = inpMatr.getNRows() == this.nCols && outMatr.getNRows() == this.nRows && outMatr.getNCols() == inpMatr.getNCols();
        if (result) {
            for (int i = 0; i < this.nRows; ++i) {
                for (int j = 0; j < inpMatr.getNCols(); ++j) {
                    double val = this.dotProductRowCol(i, inpMatr, j);
                    outMatr.setElem(i, j, val);
                }
            }
        }
        return result;
    }

    public boolean computeRLTTrans(DenseSymMatrix mLT, DenseRectMatrix mOut) {
        boolean result;
        boolean bl = result = this.nCols == mLT.getNRows();
        if (result) {
            if (mOut.getNRows() != this.nRows || mOut.getNCols() != this.nCols) {
                mOut.resize(this.nRows, this.nCols);
            }
            int rowStart = 0;
            int iOut = 0;
            double[] ltMat = mLT.getMatrix();
            double[] outMat = mOut.getMatrix();
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                int iLTStart = 0;
                for (int iLT = 0; iLT < this.nCols; ++iLT) {
                    double outElem = MathFun.dDot(iLT + 1, this.mat, rowStart, 1, ltMat, iLTStart, 1);
                    outMat[iOut++] = outElem;
                    iLTStart += iLT + 1;
                }
                rowStart += this.nCols;
            }
        }
        return result;
    }

    public double computeRowDistance(DenseRectMatrix mOther, int thisRow, int otherRow, boolean squared) {
        double result = MissingValue.getMissing();
        if (this.nCols == mOther.getNCols() && thisRow >= 0 && thisRow < this.nRows && otherRow >= 0 && otherRow < mOther.getNRows()) {
            int thisStart = thisRow * this.nCols;
            double[] otherMat = mOther.getMatrix();
            int otherStart = otherRow * this.nCols;
            result = MathFun.dSumOfSquaredDiff(this.nCols, this.mat, thisStart, otherMat, otherStart);
            if (!squared) {
                result = Math.sqrt(result);
            }
        }
        return result;
    }

    public double[] computeRV(int[] inds, double[] vals) {
        double[] ret = null;
        if (inds.length == vals.length && inds[inds.length - 1] <= this.nRows) {
            ret = new double[this.nRows];
            for (int iV = 0; iV < inds.length; ++iV) {
                int index = inds[iV];
                double value = vals[iV];
                int iMat = index;
                int iRow = 0;
                while (iRow < this.nRows) {
                    int n = iRow++;
                    ret[n] = ret[n] + value * this.mat[iMat];
                    iMat += this.nCols;
                }
            }
        }
        return ret;
    }

    @Override
    public double[] computeRV(double[] inp) {
        double[] ret = null;
        if (inp.length >= this.nCols) {
            ret = new double[this.nRows];
            int matInd = 0;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                double sum = 0.0;
                for (int iCol = 0; iCol < this.nCols; ++iCol) {
                    sum += this.mat[matInd++] * inp[iCol];
                }
                ret[iRow] = sum;
            }
        }
        return ret;
    }

    public boolean computeRV(double[] vInp, double[] vOut) {
        boolean result;
        boolean bl = result = vInp.length >= this.nCols && vOut.length >= this.nRows;
        if (result) {
            int matInd = 0;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                double sum = 0.0;
                for (int iCol = 0; iCol < this.nCols; ++iCol) {
                    sum += this.mat[matInd++] * vInp[iCol];
                }
                vOut[iRow] = sum;
            }
        }
        return result;
    }

    public boolean computeRV(double[] vInp, int sInp, double[] vOut, int sOut) {
        boolean result;
        boolean bl = result = sInp >= 0 && vInp.length - sInp >= this.nCols && sOut >= 0 && vOut.length - sOut >= this.nRows;
        if (result) {
            int matInd = 0;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                double sum = 0.0;
                for (int iCol = 0; iCol < this.nCols; ++iCol) {
                    sum += this.mat[matInd++] * vInp[sInp + iCol];
                }
                vOut[sOut + iRow] = sum;
            }
        }
        return result;
    }

    public boolean computeRV(int[] vInds, double[] vVals, double[] vOut) {
        boolean result;
        int vLen = vInds.length;
        boolean bl = result = vLen == vVals.length && vInds[vLen - 1] <= this.nCols && vOut.length >= this.nRows;
        if (result) {
            Arrays.fill(vOut, 0, this.nRows, 0.0);
            for (int iV = 0; iV < vLen; ++iV) {
                int index = vInds[iV];
                double value = vVals[iV];
                int iMat = index;
                int iRow = 0;
                while (iRow < this.nRows) {
                    int n = iRow++;
                    vOut[n] = vOut[n] + value * this.mat[iMat];
                    iMat += this.nCols;
                }
            }
        }
        return result;
    }

    @Override
    public double[] computeVR(double[] inp) {
        double[] ret = null;
        if (inp.length >= this.nRows) {
            ret = new double[this.nCols];
            for (int iCol = 0; iCol < this.nCols; ++iCol) {
                int matInd = iCol;
                double sum = 0.0;
                for (int iRow = 0; iRow < this.nRows; ++iRow) {
                    sum += inp[iRow] * this.mat[matInd];
                    matInd += this.nCols;
                }
                ret[iCol] = sum;
            }
        }
        return ret;
    }

    public double[] computeVR(int[] inds, double[] vals) {
        double[] ret = null;
        if (inds.length == vals.length && vals[inds.length - 1] <= (double)this.nRows) {
            ret = new double[this.nCols];
            for (int iV = 0; iV < inds.length; ++iV) {
                int index = inds[iV];
                double value = vals[iV];
                int iMat = this.nCols * index;
                int iCol = 0;
                while (iCol < this.nCols) {
                    int n = iCol++;
                    ret[n] = ret[n] + value * this.mat[iMat++];
                }
            }
        }
        return ret;
    }

    public boolean computeVR(double[] vInp, double[] vOut) {
        boolean result;
        boolean bl = result = vInp.length >= this.nRows && vOut.length >= this.nCols;
        if (result) {
            for (int iCol = 0; iCol < this.nCols; ++iCol) {
                int matInd = iCol;
                double sum = 0.0;
                for (int iRow = 0; iRow < this.nRows; ++iRow) {
                    sum += vInp[iRow] * this.mat[matInd];
                    matInd += this.nCols;
                }
                vOut[iCol] = sum;
            }
            result = true;
        }
        return result;
    }

    public boolean computeVR(double[] vInp, int sInp, double[] vOut, int sOut) {
        boolean result;
        boolean bl = result = sInp >= 0 && vInp.length - sInp >= this.nRows && sOut >= 0 && vOut.length - sOut >= this.nCols;
        if (result) {
            for (int iCol = 0; iCol < this.nCols; ++iCol) {
                int matInd = iCol;
                double sum = 0.0;
                for (int iRow = 0; iRow < this.nRows; ++iRow) {
                    sum += vInp[iRow + sInp] * this.mat[matInd];
                    matInd += this.nCols;
                }
                vOut[iCol + sOut] = sum;
            }
            result = true;
        }
        return result;
    }

    public boolean computeVR(int[] vInds, double[] vVals, double[] vOut) {
        boolean result;
        int vLen = vInds.length;
        boolean bl = result = vOut.length >= this.nCols && vLen == vVals.length && vInds[vLen - 1] <= this.nRows;
        if (result) {
            Arrays.fill(vOut, 0, this.nCols, 0.0);
            for (int iV = 0; iV < vLen; ++iV) {
                int index = vInds[iV];
                double value = vVals[iV];
                int iMat = this.nCols * index;
                int iCol = 0;
                while (iCol < this.nCols) {
                    int n = iCol++;
                    vOut[n] = vOut[n] + value * this.mat[iMat++];
                }
            }
            result = true;
        }
        return result;
    }

    public boolean computeDiagR(DiagMatrix mDiag) {
        boolean bResult;
        boolean bl = bResult = mDiag.getNRows() == this.nRows;
        if (bResult) {
            double[] vD = mDiag.getMatrix();
            int iR = 0;
            for (int i = 0; i < this.nRows; ++i) {
                double coef = vD[i];
                for (int j = 0; j < this.nCols; ++j) {
                    int n = iR++;
                    this.mat[n] = this.mat[n] * coef;
                }
            }
        }
        return bResult;
    }

    public boolean copyColToCol(int iColFrom, int iColTo, DenseRectMatrix mOutR) {
        boolean ret;
        int nRowsR = mOutR.getNRows();
        int nColsR = mOutR.getNCols();
        boolean bl = ret = iColFrom >= 0 && iColFrom < this.nCols && iColTo >= 0 && iColTo < nColsR && nRowsR == this.nRows;
        if (ret) {
            int index = iColFrom;
            for (int i = 0; i < nRowsR; ++i) {
                double elem = this.mat[index];
                mOutR.setElem(i, iColTo, elem);
                index += this.nCols;
            }
        }
        return ret;
    }

    public boolean copyColToRow(DenseRectMatrix matR, int iColR, int iRow) {
        boolean result = false;
        int nRowsR = matR.getNRows();
        int nColsR = matR.getNCols();
        if (iColR >= 0 && iColR < nColsR && iRow >= 0 && iRow < this.nRows && nRowsR == this.nCols) {
            int index = iRow * this.nCols;
            for (int i = 0; i < nRowsR; ++i) {
                this.mat[index++] = matR.getElem(i, iColR);
            }
            result = true;
        }
        return result;
    }

    public boolean computeProductMatrixTrans(DenseRectMatrix inpMatr, DenseRectMatrix outMatr) {
        boolean result;
        boolean bl = result = inpMatr.getNCols() == this.nCols;
        if (result) {
            outMatr.setNRowsCols(this.nRows, inpMatr.getNRows());
            for (int i = 0; i < this.nRows; ++i) {
                for (int j = 0; j < inpMatr.getNRows(); ++j) {
                    double val = this.dotProductRowRow(i, inpMatr, j);
                    outMatr.setElem(i, j, val);
                }
            }
        }
        return result;
    }

    @Override
    public boolean copyRows(RectMatrix rMat, int iFirstRow, int nRows) {
        boolean ret;
        boolean bl = ret = iFirstRow >= 0 && nRows > 0 && iFirstRow + nRows <= rMat.getNRows();
        if (ret) {
            this.resize(nRows, rMat.getNCols());
            if (rMat instanceof DenseRectMatrix) {
                double[] sourceMat = ((DenseRectMatrix)rMat).getMatrix();
                int startInd = iFirstRow * this.nCols;
                for (int i = 0; i < nRows * this.nCols; ++i) {
                    this.mat[i] = sourceMat[i + startInd];
                }
            }
        }
        return ret;
    }

    public boolean copyRowToRow(int iRowFrom, int iRowTo, DenseRectMatrix mOutR) {
        boolean result = false;
        int nRowsR = mOutR.getNRows();
        int nColsR = mOutR.getNCols();
        if (iRowFrom >= 0 && iRowFrom < this.nRows && iRowTo >= 0 && iRowTo < nRowsR && nColsR == this.nCols) {
            double[] vOutR = mOutR.getMatrix();
            int iFrom = iRowFrom * this.nCols;
            int iTo = iRowTo * this.nCols;
            for (int i = 0; i < this.nCols; ++i) {
                vOutR[iTo + i] = this.mat[iFrom + i];
            }
            result = true;
        }
        return result;
    }

    @Override
    public boolean createBlockDiagonal(int k, RectMatrix outM) {
        boolean ret;
        boolean bl = ret = k > 0 && this.nRows > 0 && this.nCols > 0 && outM instanceof DenseRectMatrix;
        if (ret) {
            int longRowLen = k * this.nCols;
            int longColLen = k * this.nRows;
            outM.resize(longColLen, longRowLen);
            for (int i = 0; i < this.nRows; ++i) {
                int srcStartInd = i * this.nCols;
                for (int b = 0; b < k; ++b) {
                    int rowIndex = b * this.nRows + i;
                    int colIndex = b * this.nCols;
                    int destStartInd = rowIndex * longRowLen + colIndex;
                    for (int j = 0; j < this.nCols; ++j) {
                        ((DenseRectMatrix)outM).mat[destStartInd + j] = this.mat[srcStartInd + j];
                    }
                }
            }
        }
        return ret;
    }

    public double dotProductCol(int iCol1, int iCol2) {
        double result = MissingValue.getMissing();
        if (iCol1 >= 0 && iCol1 < this.nCols && iCol2 >= 0 && iCol2 < this.nCols) {
            result = MathFun.dDot(this.nRows, this.mat, iCol1, this.nCols, this.mat, iCol2, this.nCols);
        }
        return result;
    }

    public double dotProductColCol(int iCol, DenseRectMatrix matR, int iColR) {
        double result = MissingValue.getMissing();
        int nRowsR = matR.getNRows();
        int nColsR = matR.getNCols();
        if (iCol >= 0 && iCol < this.nCols && iColR >= 0 && iColR < nColsR && nRowsR == this.nRows) {
            result = 0.0;
            int index = iCol;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                result += this.mat[index] * matR.getElem(iRow, iColR);
                index += this.nCols;
            }
        }
        return result;
    }

    public double dotProductColVector(int iCol, double[] vec) {
        double result = MissingValue.getMissing();
        if (iCol >= 0 && iCol < this.nCols && vec.length >= this.nRows) {
            result = MathFun.dDot(this.nRows, this.mat, iCol, this.nCols, vec, 0, 1);
        }
        return result;
    }

    public double dotProductRowCol(int iRow, DenseRectMatrix matR, int iColR) {
        double result = MissingValue.getMissing();
        int nColsR = matR.getNCols();
        if (iRow >= 0 && iRow < this.nRows && iColR >= 0 && iColR < nColsR) {
            result = 0.0;
            int index1 = iRow * this.nCols;
            for (int iCol = 0; iCol < this.nCols; ++iCol) {
                result += this.mat[index1++] * matR.getElem(iCol, iColR);
            }
        }
        return result;
    }

    public double dotProductRowRow(int iRow, DenseRectMatrix matR, int iRowR) {
        double result = MissingValue.getMissing();
        int nRowsR = matR.getNRows();
        int nColsR = matR.getNCols();
        if (iRow >= 0 && iRow < this.nRows && iRowR >= 0 && iRowR < nRowsR && nColsR == this.nCols) {
            double[] rMat = matR.getMatrix();
            result = MathFun.dDot(this.nCols, this.mat, iRow * this.nCols, 1, rMat, iRowR * this.nCols, 1);
        }
        return result;
    }

    public double dotProductRows(int iRow1, int iRow2) {
        double result = MissingValue.getMissing();
        if (iRow1 >= 0 && iRow1 < this.nRows && iRow2 >= 0 && iRow2 < this.nRows) {
            int index1 = iRow1 * this.nCols;
            int index2 = iRow2 * this.nCols;
            result = MathFun.dDot(this.nCols, this.mat, index1, 1, this.mat, index2, 1);
        }
        return result;
    }

    public double dotProductRowVector(int iRow, double[] vec) {
        double result = MissingValue.getMissing();
        if (iRow >= 0 && iRow < this.nRows && vec.length >= this.nCols) {
            int index = iRow * this.nCols;
            result = MathFun.dDot(this.nCols, this.mat, index, 1, vec, 0, 1);
        }
        return result;
    }

    public int estimateLinearGI(double[] vRHS, double[] vSol, double tol) {
        boolean res;
        int result = 0;
        if (this.nRows <= 0 || this.nCols <= 0 || tol <= 0.0) {
            return -1;
        }
        if (vRHS.length < this.nRows || vSol.length < this.nCols) {
            return -1;
        }
        if (this.nRows == this.nCols && (res = this.solveLinearSquare(vRHS, vSol, tol))) {
            return 0;
        }
        DenseSymMatrix mAA = new DenseSymMatrix(this.nCols);
        mAA.computeRTransByR(this);
        double[] vR = new double[this.nCols];
        this.computeVR(vRHS, vR);
        result = mAA.lTSolve(vR, tol, vSol);
        return result;
    }

    @Override
    public int extractColumns(int[] colX, RectMatrix outR) {
        int nColsR = 0;
        if (outR instanceof DenseRectMatrix) {
            int iCol;
            int i;
            int iColR = 0;
            for (i = 0; i < colX.length; ++i) {
                iCol = colX[i];
                if (iCol < 0 || iCol >= this.nCols) continue;
                ++nColsR;
            }
            outR.resize(this.nRows, nColsR);
            for (i = 0; i < colX.length; ++i) {
                iCol = colX[i];
                if (iCol < 0 || iCol >= this.nCols) continue;
                this.copyColToCol(iCol, iColR++, (DenseRectMatrix)outR);
            }
        } else {
            nColsR = -1;
        }
        return nColsR;
    }

    public int extractFullRank(double tol, DenseRectMatrix mFullRank, int[] vIndNonRed, boolean doRows) {
        int result = 0;
        if (tol < 0.0) {
            return -1;
        }
        result = this.findNonRedunIndices(tol, vIndNonRed, doRows);
        if (doRows) {
            this.extractRows(vIndNonRed, mFullRank);
        } else {
            this.extractColumns(vIndNonRed, mFullRank);
        }
        return result;
    }

    @Override
    public int extractRows(int[] rowX, RectMatrix outR) {
        int nRowsR = 0;
        if (outR instanceof DenseRectMatrix) {
            int iRow;
            for (int i = 0; i < rowX.length; ++i) {
                iRow = rowX[i];
                if (iRow < 0 || iRow >= this.nRows) continue;
                ++nRowsR;
            }
            outR.resize(nRowsR, this.nCols);
            int iR = 0;
            for (int i = 0; i < rowX.length; ++i) {
                iRow = rowX[i];
                if (iRow < 0 || iRow >= this.nRows) continue;
                int start = iRow * this.nCols;
                for (int j = 0; j < this.nCols; ++j) {
                    ((DenseRectMatrix)outR).mat[iR++] = this.mat[start++];
                }
            }
        } else {
            nRowsR = -1;
        }
        return nRowsR;
    }

    public int findFirstNonZeroInRow(int iRow, double tol) {
        int result = -1;
        if (iRow >= 0 && iRow < this.nRows && tol > 0.0) {
            int index = iRow * this.nCols;
            for (int iCol = 0; iCol < this.nCols && result < 0; ++iCol) {
                int n = index++;
                if (!(Math.abs(this.mat[n]) > tol)) continue;
                result = iCol;
            }
        }
        return result;
    }

    public int findNonRedunIndices(double tol, int[] vIndNonRed, boolean doRows) {
        int result = 0;
        if (tol < 0.0) {
            return -1;
        }
        int nRowsAA = doRows ? this.nRows : this.nCols;
        DenseSymMatrix mAA = new DenseSymMatrix(nRowsAA);
        if (doRows) {
            mAA.computeRByRTrans(this);
        } else {
            mAA.computeRTransByR(this);
        }
        double tolAA = tol * tol;
        Arrays.fill(vIndNonRed, -1);
        result = mAA.cholIndNonRed(0, tolAA, vIndNonRed);
        return result;
    }

    public int findSameRows(DenseRectMatrix other, int[] rowInd) {
        boolean argOK;
        int result = -1;
        int oNRows = other.getNRows();
        boolean bl = argOK = this.nCols == other.getNCols() && rowInd.length >= oNRows;
        if (argOK) {
            result = 0;
            double[] oMat = other.getMatrix();
            int oStart = 0;
            for (int oRow = 0; oRow < oNRows; ++oRow) {
                int start = 0;
                rowInd[oRow] = -1;
                for (int row = 0; row < this.nRows; ++row) {
                    if (MathFun.dVecEqual(this.nCols, this.mat, start, oMat, oStart)) {
                        rowInd[oRow] = row;
                        ++result;
                        break;
                    }
                    start += this.nCols;
                }
                oStart += this.nCols;
            }
        }
        return result;
    }

    @Override
    public double getElem(int iRow, int iCol) {
        return this.mat[this.nCols * iRow + iCol];
    }

    public double[] getMatrix() {
        return this.mat;
    }

    @Override
    public int getNCols() {
        return this.nCols;
    }

    @Override
    public int getNRows() {
        return this.nRows;
    }

    @Override
    public double[] getRow(int iRow) {
        double[] row = null;
        if (iRow >= 0 && iRow < this.nRows) {
            row = new double[this.nCols];
            int offset = iRow * this.nCols;
            for (int i = 0; i < this.nCols; ++i) {
                row[i] = this.mat[offset + i];
            }
        }
        return row;
    }

    public double[] getCol(int iCol) {
        double[] col = null;
        if (iCol >= 0 && iCol < this.nCols) {
            col = new double[this.nRows];
            for (int i = 0; i < this.nRows; ++i) {
                col[i] = this.mat[iCol + i * this.nCols];
            }
        }
        return col;
    }

    public boolean incrVecByColumn(int iCol, double[] vec, int iPos, int nUpd, double coeff, boolean chkPar) {
        boolean result = true;
        int vLen = vec.length;
        if (chkPar) {
            if (iCol < 0 || iCol >= this.nCols) {
                result = false;
            }
            if (result && (nUpd <= 0 || nUpd > this.nRows)) {
                result = false;
            }
            if (result && (iPos < 0 || iPos + nUpd > vLen)) {
                result = false;
            }
        }
        if (result) {
            int iMat = iCol;
            int iVec = iPos;
            for (int i = 0; i < this.nRows && i < nUpd; ++i) {
                int n = iVec++;
                vec[n] = vec[n] + this.mat[iMat] * coeff;
                iMat += this.nCols;
            }
        }
        return result;
    }

    public boolean isColZero(int col) {
        boolean ret;
        boolean bl = ret = this.nRows > 0 && this.nCols > 0 && col >= 0 && col < this.nCols;
        if (ret) {
            int index = col;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                if (this.mat[index] != 0.0) {
                    ret = false;
                    break;
                }
                index += this.nCols;
            }
        }
        return ret;
    }

    public boolean isERowMultipleOfAnother(int iRow1, int iRow2, double elm1, double elm2, double[] coeff) {
        double rDiff;
        int iCol;
        boolean result = this.nCols > 0 && iRow1 >= 0 && iRow1 < this.nRows && iRow2 >= 0 && iRow2 < this.nRows;
        boolean stop = !result;
        int index1 = iRow1 * this.nCols;
        int index2 = iRow2 * this.nCols;
        double ratio = 0.0;
        double vMax1 = 0.0;
        double vMax2 = 0.0;
        double tolerance = 2.220446049250313E-16;
        if (!stop) {
            for (iCol = 0; iCol < this.nCols; ++iCol) {
                if (Math.abs(this.mat[index1]) > vMax1) {
                    vMax1 = Math.abs(this.mat[index1]);
                }
                if (Math.abs(this.mat[index2]) > vMax2) {
                    vMax2 = Math.abs(this.mat[index2]);
                }
                ++index1;
                ++index2;
            }
            if (Math.abs(elm1) > vMax1) {
                vMax1 = Math.abs(elm1);
            }
            if (Math.abs(elm2) > vMax2) {
                vMax2 = Math.abs(elm2);
            }
            if (vMax1 == 0.0 && vMax2 == 0.0) {
                result = true;
                ratio = 0.0;
                stop = true;
            }
            if (vMax1 == 0.0 || vMax2 == 0.0) {
                result = false;
                stop = true;
            }
        }
        if (!stop) {
            boolean nonZeroPairFound = false;
            index1 = iRow1 * this.nCols;
            index2 = iRow2 * this.nCols;
            for (iCol = 0; iCol < this.nCols; ++iCol) {
                double value1 = this.mat[index1];
                double value2 = this.mat[index2];
                if (value1 != 0.0 && value2 != 0.0) {
                    nonZeroPairFound = true;
                    ratio = value1 / value2;
                    break;
                }
                if (value1 == 0.0 && value2 == 0.0) {
                    ++index1;
                    ++index2;
                    continue;
                }
                result = false;
                stop = true;
                break;
            }
            if (!nonZeroPairFound && !stop) {
                if (elm1 != 0.0 && elm2 != 0.0) {
                    nonZeroPairFound = true;
                    ratio = elm1 / elm2;
                } else {
                    result = false;
                    stop = true;
                }
            }
        }
        if (!stop) {
            index1 = iRow1 * this.nCols;
            index2 = iRow2 * this.nCols;
            for (iCol = 0; iCol < this.nCols; ++iCol) {
                rDiff = Math.abs(this.mat[index1] - ratio * this.mat[index2]) / vMax1;
                if (rDiff > tolerance) {
                    result = false;
                    stop = true;
                    break;
                }
                ++index1;
                ++index2;
            }
        }
        if (!stop && (rDiff = Math.abs(elm1 - ratio * elm2) / vMax1) > tolerance) {
            result = false;
        }
        if (result) {
            coeff[0] = ratio;
        }
        return result;
    }

    @Override
    public boolean isRowZero(int iRow) {
        boolean ret;
        boolean bl = ret = this.nCols > 0 && this.nRows > 0 && iRow >= 0 && iRow < this.nRows;
        if (ret) {
            int index = iRow * this.nCols;
            for (int col = 0; col < this.nCols; ++col) {
                if (this.mat[index++] == 0.0) continue;
                ret = false;
                break;
            }
        }
        return ret;
    }

    @Override
    public void resize(int nRows, int nCols) {
        if (nRows > 0 && nCols > 0) {
            this.nRows = nRows;
            this.nCols = nCols;
        } else {
            this.nRows = 0;
            this.nCols = 0;
        }
        this.mat = new double[this.nRows * this.nCols];
    }

    public boolean residOfOrthProjection(DenseRectMatrix matX, double tolerance, CCBitSet indepColX, CCBitSet indepColY) {
        boolean result = false;
        int nColsX = matX.getNCols();
        if (this.nRows == matX.getNRows() && this.nRows > 0 && this.nCols > 0 && nColsX > 0 && tolerance > 0.0) {
            int i;
            result = true;
            if (indepColX.size() != nColsX) {
                indepColX.resize(nColsX);
            } else {
                indepColX.clear();
            }
            if (indepColY.size() != this.nCols) {
                indepColY.resize(this.nCols);
            } else {
                indepColY.clear();
            }
            int nRowsSym = nColsX + this.nCols;
            DenseSymMatrix sym = new DenseSymMatrix(nRowsSym);
            sym.updateXXMat2(matX, this);
            double[] diag = sym.getDiagonal();
            for (i = 0; i < nColsX; ++i) {
                sym.sweep(i, tolerance, diag, indepColX, false);
            }
            for (i = 0; i < nColsX; ++i) {
                if (!indepColX.isIn(i)) continue;
                for (int j = 0; j < this.nCols; ++j) {
                    double coeff = -sym.getElem(nColsX + j, i);
                    this.addToColumn(j, matX, i, coeff);
                }
            }
            for (i = 0; i < this.nCols; ++i) {
                double rss = this.dotProductCol(i, i);
                if (rss > diag[nColsX + i] * tolerance) {
                    indepColY.set(i, true);
                    continue;
                }
                indepColY.set(i, false);
            }
        }
        return result;
    }

    @Override
    public void setElem(int iRow, int iCol, double val) {
        this.mat[this.nCols * iRow + iCol] = val;
    }

    public boolean setNRowsCols(int nRows, int nCols) {
        this.nRows = nRows >= 0 ? nRows : 0;
        this.nCols = nCols >= 0 ? nCols : 0;
        this.mat = new double[this.nRows * this.nCols];
        return true;
    }

    @Override
    public boolean shiftColumns(int nCols, RectMatrix outM) {
        boolean ret;
        boolean bl = ret = nCols >= 0 && this.nRows > 0 && this.nCols > 0 && outM instanceof DenseRectMatrix;
        if (ret && outM != null) {
            outM.resize(this.nRows, nCols + this.nCols);
            double[] destMat = ((DenseRectMatrix)outM).getMatrix();
            for (int i = 0; i < this.nRows; ++i) {
                int srcStartInd = i * this.nCols;
                int destStartInd = nCols + i * outM.getNCols();
                for (int j = 0; j < this.nCols; ++j) {
                    destMat[destStartInd + j] = this.mat[srcStartInd + j];
                }
            }
        }
        return ret;
    }

    public boolean solveLinearSquare(double[] vRHS, double[] vSol, double tol) {
        boolean result = true;
        result = this.nRows == this.nCols && this.nRows >= 1 && tol >= 0.0;
        result = result && vRHS.length >= this.nRows && vSol.length >= this.nRows;
        double[] vCopy = new double[this.mat.length];
        double rCond = 0.0;
        int[] vPivot = new int[this.nRows];
        double[] vWork1 = new double[this.nRows];
        if (result) {
            MathFun.dCopy(this.mat, vCopy);
            rCond = LinpackD.dgeco(vCopy, this.nRows, this.nRows, vPivot, vWork1);
            boolean bl = result = rCond > tol;
        }
        if (result) {
            int jobCode = 1;
            MathFun.dCopy(vRHS, vSol);
            LinpackD.dgesl(vCopy, this.nRows, this.nRows, vPivot, vSol, jobCode);
        }
        return result;
    }

    public void transpose() {
        int matLen = this.nRows * this.nCols;
        double[] oldCopy = new double[matLen];
        int indexOld = 0;
        for (int i = 0; i < matLen; ++i) {
            oldCopy[i] = this.mat[i];
        }
        for (int iRow = 0; iRow < this.nRows; ++iRow) {
            int indexNew = iRow;
            for (int iCol = 0; iCol < this.nCols; ++iCol) {
                this.mat[indexNew] = oldCopy[indexOld++];
                indexNew += this.nRows;
            }
        }
        int nRowsOld = this.nRows;
        this.nRows = this.nCols;
        this.nCols = nRowsOld;
    }

    public boolean zeroOutCol(int iCol) {
        boolean result = false;
        if (iCol >= 0 && iCol < this.nCols) {
            int index = iCol;
            for (int i = 0; i < this.nRows; ++i) {
                this.mat[index] = 0.0;
                index += this.nCols;
            }
            result = true;
        }
        return result;
    }

    public boolean zeroOutPivotRow(int iPivotRow, double tol, int[] iPivotCol) {
        boolean result;
        boolean bl = result = iPivotRow >= 0 && iPivotRow < this.nRows && tol > 0.0;
        if (result) {
            iPivotCol[0] = this.findFirstNonZeroInRow(iPivotRow, tol);
            if (iPivotCol[0] >= 0) {
                result = true;
                for (int iCol = 0; iCol < this.nCols; ++iCol) {
                    if (iCol == iPivotCol[0]) continue;
                    double coeff = this.getElem(iPivotRow, iCol);
                    this.addToColumn(iCol, this, iPivotCol[0], coeff);
                }
                this.zeroOutCol(iPivotCol[0]);
            } else {
                iPivotCol[0] = -1;
            }
        } else {
            iPivotCol[0] = -1;
        }
        return result;
    }

    public boolean zeroOutRowPart(int iRow, int iCol1, int iCol2) {
        boolean result;
        boolean bl = result = iRow >= 0 && iRow < this.nRows && iCol1 >= 0 && iCol1 <= iCol2 && iCol2 < this.nCols;
        if (result) {
            int index = iRow * this.nCols + iCol1;
            for (int i = iCol1; i <= iCol2; ++i) {
                this.mat[index++] = 0.0;
            }
        }
        return result;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nRows);
        dataOutput.writeInt(this.nCols);
        dataOutput.writeInt(this.mat.length);
        for (int i = 0; i < this.mat.length; ++i) {
            dataOutput.writeDouble(this.mat[i]);
        }
    }

    public Object readObject(DataInput dataInput) throws IOException {
        this.nRows = dataInput.readInt();
        this.nCols = dataInput.readInt();
        int matLen = dataInput.readInt();
        this.mat = new double[matLen];
        for (int i = 0; i < this.mat.length; ++i) {
            this.mat[i] = dataInput.readDouble();
        }
        return this;
    }

    public String toString() {
        return "DenseRectMatrix [mat=" + Arrays.toString(this.mat) + ", nCols=" + this.nCols + ", nRows=" + this.nRows + "]";
    }

    public boolean copyTo(DenseRectMatrix outMatrix) {
        if (outMatrix.getNRows() != this.nRows || outMatrix.getNCols() != this.nCols) {
            outMatrix.setNRowsCols(this.nRows, this.nCols);
        }
        double[] out = outMatrix.getMatrix();
        return MathFun.dCopy(this.mat, out);
    }

    public DenseRectMatrix clone() {
        try {
            DenseRectMatrix result = (DenseRectMatrix)super.clone();
            if (this.mat != null) {
                result.mat = (double[])this.mat.clone();
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean decompositionH(DenseSymMatrix matR, DenseRectMatrix matQ) {
        boolean bResult = true;
        if (this.nRows <= 0 || this.nCols <= 0) {
            return false;
        }
        int nNewRows = this.nRows;
        int nNewCols = this.nCols;
        if (this.nRows < this.nCols) {
            nNewRows = this.nCols;
            nNewCols = this.nRows;
        }
        if (matR.getNRows() != nNewCols) {
            matR.resize(nNewCols);
        }
        if (matQ.getNRows() != nNewRows || matQ.getNCols() != nNewRows) {
            matQ.resize(nNewRows, nNewRows);
        }
        if (bResult) {
            int i;
            matR.clear();
            matQ.clear();
            DenseRectMatrix mRPrev = new DenseRectMatrix(this);
            if (this.nRows < this.nCols) {
                mRPrev.transpose();
            }
            DenseRectMatrix mRCur = new DenseRectMatrix(nNewRows, nNewCols);
            double[] vQiElem = new double[nNewRows];
            double[] vQiWork = new double[nNewRows];
            double[] vRCol = new double[nNewRows];
            DenseRectMatrix mQCur = new DenseRectMatrix(nNewRows, nNewRows);
            for (i = 0; i < nNewRows; ++i) {
                matQ.setElem(i, i, 1.0);
            }
            int len = nNewRows;
            for (int iCol = 0; iCol < nNewCols; ++iCol) {
                vRCol = mRPrev.getCol(iCol);
                double norm = MathFun.dNrm2(len, vRCol, iCol, 1);
                if (vRCol[iCol] > 0.0) {
                    norm = -norm;
                }
                int n = iCol;
                vRCol[n] = vRCol[n] - norm;
                norm = MathFun.dNrm2(len, vRCol, iCol, 1);
                if (norm == 0.0) {
                    bResult = false;
                    break;
                }
                for (i = iCol; i < nNewRows; ++i) {
                    vQiWork[i] = vRCol[i] / norm;
                }
                for (i = iCol; i < nNewRows; ++i) {
                    double dotP;
                    int j;
                    double elm = vQiWork[i];
                    for (j = iCol; j < nNewRows; ++j) {
                        vQiElem[j] = -2.0 * elm * vQiWork[j];
                    }
                    int n2 = i;
                    vQiElem[n2] = vQiElem[n2] + 1.0;
                    int n3 = j = i == iCol ? iCol : iCol + 1;
                    while (j < nNewCols) {
                        vRCol = mRPrev.getCol(j);
                        dotP = MathFun.dDot(len, vQiElem, iCol, 1, vRCol, iCol, 1);
                        mRCur.setElem(i, j, dotP);
                        if (i == iCol) {
                            matR.setElem(i, j, dotP);
                        }
                        ++j;
                    }
                    for (j = 0; j < nNewRows; ++j) {
                        vRCol = matQ.getCol(j);
                        dotP = MathFun.dDot(len, vQiElem, iCol, 1, vRCol, iCol, 1);
                        mQCur.setElem(i, j, dotP);
                    }
                }
                mRCur.copyTo(mRPrev);
                mQCur.copyTo(matQ);
                --len;
            }
            matQ.transpose();
        }
        return bResult;
    }
}

