/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.matrix;

import com.spss.math.MissingValue;
import com.spss.math.matrix.DenseRectMatrix;
import com.spss.math.matrix.SymMatrix;
import com.spss.math.statistics.CCBitSet;
import com.spss.math.statistics.MathFun;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class DenseSymMatrix
implements SymMatrix,
Cloneable {
    private int nRows = 0;
    private double[] mat = null;

    public DenseSymMatrix() {
        this.nRows = 0;
    }

    public DenseSymMatrix(int nRows) {
        this.nRows = nRows >= 0 ? nRows : 0;
        this.mat = new double[nRows * (nRows + 1) / 2];
    }

    public DenseSymMatrix(DenseSymMatrix srcMat) {
        this.nRows = srcMat.nRows;
        this.mat = Arrays.copyOf(srcMat.mat, srcMat.mat.length);
    }

    public void addConstToDiagonal(double aConst) {
        int iDiag = 0;
        for (int i = 0; i < this.nRows; ++i) {
            int n = iDiag;
            this.mat[n] = this.mat[n] + aConst;
            iDiag += i + 2;
        }
    }

    public void addVectorToDiagonal(double[] vec) {
        int upd = Math.min(this.nRows, vec.length);
        int iDiag = 0;
        for (int i = 0; i < upd; ++i) {
            int n = iDiag;
            this.mat[n] = this.mat[n] + vec[i];
            iDiag += i + 2;
        }
    }

    @Override
    public void changeSign() {
        int i = 0;
        while (i < this.mat.length) {
            int n = i++;
            this.mat[n] = this.mat[n] * -1.0;
        }
    }

    public int cholIndNonRed(int nToFind, double tol, int[] indNonRed) {
        if (indNonRed == null || indNonRed.length == 0 || tol < 0.0) {
            return 0;
        }
        if (nToFind <= 0 || nToFind > this.nRows) {
            nToFind = this.nRows;
        }
        if (nToFind > indNonRed.length) {
            nToFind = indNonRed.length;
        }
        int nonRedCnt = 0;
        double[] diag = new double[this.nRows];
        int iDiag = 0;
        for (int i = 0; i < this.nRows; ++i) {
            diag[i] = this.mat[iDiag];
            iDiag += i + 2;
        }
        double[] sym = new double[this.mat.length];
        MathFun.dCopy(this.mat, sym);
        iDiag = 0;
        int iElm = 0;
        int iFst = 0;
        for (int i = 0; i < this.nRows && nonRedCnt < nToFind; ++i) {
            double rowTol = tol * diag[i];
            int jDiag = 0;
            int jFst = 0;
            for (int j = 0; j <= i; ++j) {
                double valOld = sym[iElm] - MathFun.dDot(j, sym, iFst, 1, sym, jFst, 1);
                if (j != i) {
                    double valNew = sym[jDiag];
                    if (valNew != 0.0) {
                        valNew = valOld / valNew;
                    }
                    sym[iElm] = valNew;
                } else {
                    if (valOld > rowTol) {
                        valOld = Math.sqrt(valOld);
                        indNonRed[nonRedCnt++] = i;
                    } else {
                        valOld = 0.0;
                    }
                    sym[iDiag] = valOld;
                }
                ++iElm;
                jFst = jDiag + 1;
                jDiag += j + 2;
            }
            iFst = iDiag + 1;
            iDiag += i + 2;
        }
        return nonRedCnt;
    }

    @Override
    public int cholInverse(double[] diag, double tol, DenseSymMatrix igi) {
        int result = -1;
        if (diag.length >= this.nRows && igi.getNRows() == this.nRows) {
            double[] imat = igi.getMatrix();
            for (int i = 0; i < imat.length; ++i) {
                imat[i] = this.mat[i];
            }
            result = igi.lTChol(diag, tol, false);
            if (result >= 0) {
                result = this.nRows - result;
                int job = 10;
                double[] det = new double[2];
                igi.lTDetInverse(det, job);
                igi.lTLTransL();
            }
        }
        return result;
    }

    @Override
    public int cholInverse(double[] diag, double tol, DenseSymMatrix igi, CCBitSet nonRed) {
        int result = -1;
        if (diag.length >= this.nRows && igi.getNRows() == this.nRows && nonRed.size() == this.nRows) {
            double[] imat = igi.getMatrix();
            for (int i = 0; i < imat.length; ++i) {
                imat[i] = this.mat[i];
            }
            result = igi.lTChol(diag, tol, nonRed, false);
            if (result >= 0) {
                result = this.nRows - result;
                int job = 10;
                double[] det = new double[2];
                igi.lTDetInverse(det, job);
                igi.lTLTransL();
            }
        }
        return result;
    }

    @Override
    public int cholInverse(double[] diag, double tol, DenseSymMatrix igi, double[] minDg) {
        int result = -1;
        if (diag.length >= this.nRows && igi.getNRows() == this.nRows) {
            int i;
            double[] imat = igi.getMatrix();
            for (i = 0; i < imat.length; ++i) {
                imat[i] = this.mat[i];
            }
            result = igi.lTChol(diag, tol, false);
            if (result >= 0) {
                result = this.nRows - result;
                if (minDg.length >= 1) {
                    minDg[1] = igi.getElem(0, 0);
                    for (i = 1; i < this.nRows; ++i) {
                        double diagElm = igi.getElem(i, i);
                        if (!(diagElm < minDg[1])) continue;
                        minDg[1] = diagElm;
                    }
                }
                int job = 10;
                double[] det = new double[2];
                igi.lTDetInverse(det, job);
                igi.lTLTransL();
            }
        }
        if (result == -1 && minDg.length >= 1) {
            minDg[0] = MissingValue.getMissing();
        }
        return result;
    }

    @Override
    public void clear() {
        Arrays.fill(this.mat, 0.0);
    }

    public DenseSymMatrix clone() {
        try {
            DenseSymMatrix result = (DenseSymMatrix)super.clone();
            if (this.mat != null) {
                result.mat = (double[])this.mat.clone();
            }
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean computeAXpY(double alpha, DenseSymMatrix x) {
        boolean result;
        int n = x.getNRows();
        boolean bl = result = n == this.nRows;
        if (result) {
            double[] xMat = x.getMatrix();
            int vSize = xMat.length;
            MathFun.daxpy(vSize, alpha, xMat, 0, 1, this.mat, 0, 1);
        }
        return result;
    }

    public int computeDeterminant(double tol, double[] det) {
        if (this.nRows == 0 || det == null || det.length < 2) {
            return -1;
        }
        DenseSymMatrix tempMatrix = new DenseSymMatrix(this);
        double[] minDg = new double[1];
        int res = tempMatrix.lTChol(tol, 1.0E-4, minDg, true);
        if (res == -1) {
            return -1;
        }
        if (minDg[0] == 0.0) {
            det[0] = 0.0;
            det[1] = 0.0;
        } else {
            int job = 1;
            res = tempMatrix.lTDetInverse(det, job);
            if (res == 0) {
                det[0] = det[0] * det[0];
                det[1] = det[1] * 2.0;
                while (Math.abs(det[0]) < 1.0) {
                    det[0] = det[0] * 10.0;
                    det[1] = det[1] - 1.0;
                }
                while (Math.abs(det[0]) >= 10.0) {
                    det[0] = det[0] / 10.0;
                    det[1] = det[1] + 1.0;
                }
            }
        }
        return 0;
    }

    public double computeDotProduct2Rows(int iRow1, int iRow2) {
        double result;
        block8: {
            result = 0.0;
            if (iRow1 < 0 || iRow1 >= this.nRows || iRow2 < 0 || iRow2 >= this.nRows) break block8;
            int iElm1 = iRow1 * (iRow1 + 1) / 2;
            int iElm2 = iRow2 * (iRow2 + 1) / 2;
            if (iRow1 <= iRow2) {
                int i;
                for (i = 0; i < iRow1; ++i) {
                    result += this.mat[iElm1] * this.mat[iElm2];
                    ++iElm1;
                    ++iElm2;
                }
                for (i = iRow1; i < iRow2; ++i) {
                    result += this.mat[iElm1] * this.mat[iElm2];
                    iElm1 += i + 1;
                    ++iElm2;
                }
                for (i = iRow2; i < this.nRows; ++i) {
                    result += this.mat[iElm1] * this.mat[iElm2];
                    iElm1 += i + 1;
                    iElm2 += i + 1;
                }
            } else {
                int i;
                for (i = 0; i < iRow2; ++i) {
                    result += this.mat[iElm1] * this.mat[iElm2];
                    ++iElm1;
                    ++iElm2;
                }
                for (i = iRow2; i < iRow1; ++i) {
                    result += this.mat[iElm1] * this.mat[iElm2];
                    ++iElm1;
                    iElm2 += i + 1;
                }
                for (i = iRow1; i < this.nRows; ++i) {
                    result += this.mat[iElm1] * this.mat[iElm2];
                    iElm1 += i + 1;
                    iElm2 += i + 1;
                }
            }
        }
        return result;
    }

    public boolean computeDSD(double[] vDiag) {
        boolean result;
        boolean bl = result = this.nRows <= vDiag.length;
        if (result) {
            int iMat = 0;
            for (int i = 0; i < this.nRows; ++i) {
                double d1 = vDiag[i];
                for (int j = 0; j <= i; ++j) {
                    int n = iMat++;
                    this.mat[n] = this.mat[n] * (d1 * vDiag[j]);
                }
            }
        }
        return result;
    }

    @Override
    public boolean computeGMG(double[] mVec, DenseSymMatrix gmg) {
        boolean result;
        int mSize = this.nRows * (this.nRows + 1) / 2;
        boolean bl = result = mVec.length == mSize && gmg.getNRows() == this.nRows;
        if (result) {
            gmg.clear();
            double[] vGMG = gmg.getMatrix();
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                int rowStart = 0;
                for (int iCol = 0; iCol < this.nRows; ++iCol) {
                    double dotP = this.computeRowDotProductS(iCol, mVec, iRow);
                    this.incrVecByRow(iRow, vGMG, rowStart, iCol + 1, dotP, false);
                    rowStart += iCol + 1;
                }
            }
        }
        return result;
    }

    public boolean computeLR(DenseRectMatrix mR, DenseRectMatrix mOut) {
        boolean result;
        int nRRows = mR.getNRows();
        int nRCols = mR.getNCols();
        boolean bl = result = this.nRows == nRRows;
        if (result) {
            if (nRRows != mOut.getNRows() || nRCols != mOut.getNCols()) {
                mOut.resize(nRRows, nRCols);
            }
            int iFirst = 0;
            double[] vR = mR.getMatrix();
            double[] vOut = mOut.getMatrix();
            int iOut = 0;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                for (int iCol = 0; iCol < nRCols; ++iCol) {
                    double dotProd = MathFun.dDot(iRow + 1, this.mat, iFirst, 1, vR, iCol, nRCols);
                    vOut[iOut++] = dotProd;
                }
                iFirst += iRow + 1;
            }
        }
        return result;
    }

    public boolean computeLSLTrans(DenseSymMatrix lTriangular, DenseSymMatrix lSLTrans) {
        boolean result;
        boolean bl = result = this.nRows == lTriangular.getNRows() && this.nRows == lSLTrans.nRows;
        if (result) {
            double[] vLTriang = lTriangular.getMatrix();
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                int rowOffset = iRow * (iRow + 1) / 2;
                for (int iCol = 0; iCol <= iRow; ++iCol) {
                    int colOffset = iCol * (iCol + 1) / 2;
                    double elem = this.computeVSWParts(vLTriang, rowOffset, iRow + 1, vLTriang, colOffset, iCol + 1);
                    lSLTrans.setElem(iRow, iCol, elem);
                }
            }
        }
        return result;
    }

    public boolean computeLTransV(double[] inpVec, double[] outVec) {
        boolean result;
        boolean bl = result = inpVec.length >= this.nRows && outVec.length >= this.nRows;
        if (result) {
            double[] work = new double[this.nRows];
            int iLDiag = 0;
            int iOut = 0;
            int vStart = 0;
            for (int iL = 0; iL < this.nRows; ++iL) {
                int nCopy = this.nRows - iL;
                int iFrom = iLDiag;
                for (int i = 0; i < nCopy; ++i) {
                    work[i] = this.mat[iFrom];
                    iFrom += iL + i + 1;
                }
                double dotP = MathFun.dDot(nCopy, work, 0, 1, inpVec, vStart++, 1);
                outVec[iOut++] = dotP;
                iLDiag += iL + 2;
            }
        }
        return result;
    }

    public boolean computeLTransV(double[] inpVec, int inpStart, double[] outVec) {
        boolean result;
        boolean bl = result = inpVec.length - inpStart >= this.nRows && outVec.length >= this.nRows;
        if (result) {
            double[] work = new double[this.nRows];
            int iLDiag = 0;
            int iOut = 0;
            int vStart = inpStart;
            for (int iL = 0; iL < this.nRows; ++iL) {
                int nCopy = this.nRows - iL;
                int iFrom = iLDiag;
                for (int i = 0; i < nCopy; ++i) {
                    work[i] = this.mat[iFrom];
                    iFrom += iL + i + 1;
                }
                double dotP = MathFun.dDot(nCopy, work, 0, 1, inpVec, vStart++, 1);
                outVec[iOut++] = dotP;
                iLDiag += iL + 2;
            }
        }
        return result;
    }

    public boolean computeLV(double[] inpVec, double[] outVec) {
        boolean result;
        boolean bl = result = inpVec.length >= this.nRows && outVec.length >= this.nRows;
        if (result) {
            int iFirst = 0;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                double dotPrd;
                outVec[iRow] = dotPrd = MathFun.dDot(iRow + 1, this.mat, iFirst, 1, inpVec, 0, 1);
                iFirst += iRow + 1;
            }
        }
        return result;
    }

    public boolean computeLV(double[] inpVec, int inpStart, double[] outVec) {
        boolean result;
        boolean bl = result = inpVec.length - inpStart >= this.nRows && outVec.length >= this.nRows;
        if (result) {
            int iFirst = 0;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                double dotPrd;
                outVec[iRow] = dotPrd = MathFun.dDot(iRow + 1, this.mat, iFirst, 1, inpVec, inpStart, 1);
                iFirst += iRow + 1;
            }
        }
        return result;
    }

    public boolean computeRByRTrans(DenseRectMatrix matR) {
        int nRows;
        boolean result = true;
        this.nRows = nRows = matR.getNRows();
        this.mat = new double[nRows * (nRows + 1) / 2];
        int iMat = 0;
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j <= i; ++j) {
                this.mat[iMat++] = matR.dotProductRows(i, j);
            }
        }
        return result;
    }

    @Override
    public double computeRowDotProductS(int iRow, DenseSymMatrix mInpS, int iRowS) {
        double[] vInpS = mInpS.getMatrix();
        return this.computeRowDotProductS(iRow, vInpS, iRowS);
    }

    @Override
    public double computeRowDotProductS(int iRow, double[] vInpS, int iRowS) {
        double result;
        block8: {
            result = 0.0;
            if (iRow < 0 || iRow >= this.nRows || iRowS < 0 || iRowS >= this.nRows || this.nRows * (this.nRows + 1) / 2 != vInpS.length) break block8;
            int iElm = iRow * (iRow + 1) / 2;
            int iElmS = iRowS * (iRowS + 1) / 2;
            if (iRow <= iRowS) {
                int i;
                for (i = 0; i < iRow; ++i) {
                    result += this.mat[iElm] * vInpS[iElmS];
                    ++iElm;
                    ++iElmS;
                }
                for (i = iRow; i < iRowS; ++i) {
                    result += this.mat[iElm] * vInpS[iElmS];
                    iElm += i + 1;
                    ++iElmS;
                }
                for (i = iRowS; i < this.nRows; ++i) {
                    result += this.mat[iElm] * vInpS[iElmS];
                    iElm += i + 1;
                    iElmS += i + 1;
                }
            } else {
                int i;
                for (i = 0; i < iRowS; ++i) {
                    result += this.mat[iElm] * vInpS[iElmS];
                    ++iElm;
                    ++iElmS;
                }
                for (i = iRowS; i < iRow; ++i) {
                    result += this.mat[iElm] * vInpS[iElmS];
                    ++iElm;
                    iElmS += i + 1;
                }
                for (i = iRow; i < this.nRows; ++i) {
                    result += this.mat[iElm] * vInpS[iElmS];
                    iElm += i + 1;
                    iElmS += i + 1;
                }
            }
        }
        return result;
    }

    public boolean computeRS(DenseRectMatrix inpR, DenseRectMatrix outR) {
        boolean result = inpR.getNCols() == this.nRows;
        int nRows = inpR.getNRows();
        if (result && (outR.getNRows() != nRows || outR.getNCols() != this.nRows)) {
            result = outR.setNRowsCols(nRows, this.nRows);
        }
        if (result) {
            double[] vInpR = inpR.getMatrix();
            int sInpR = 0;
            for (int iRow = 0; iRow < nRows; ++iRow) {
                for (int iCol = 0; iCol < this.nRows; ++iCol) {
                    outR.setElem(iRow, iCol, this.computeRVD(iCol, vInpR, sInpR, 1));
                }
                sInpR += this.nRows;
            }
        }
        return result;
    }

    public DenseSymMatrix computeRSRTrans(DenseRectMatrix matR) {
        int nRowsR = matR.getNRows();
        int nColsR = matR.getNCols();
        if (nColsR != this.nRows) {
            return null;
        }
        DenseSymMatrix rSRTr = new DenseSymMatrix(nRowsR);
        double[] vecR = matR.getMatrix();
        double[] vecOut = rSRTr.getMatrix();
        for (int iColR = 0; iColR < nColsR; ++iColR) {
            int rowOStart = 0;
            int rowRStart = 0;
            for (int iRowR = 0; iRowR < nRowsR; ++iRowR) {
                double dotP = this.computeRVD(iColR, vecR, rowRStart, 1);
                boolean result = matR.incrVecByColumn(iColR, vecOut, rowOStart, iRowR + 1, dotP, true);
                if (!result) {
                    return null;
                }
                rowOStart += iRowR + 1;
                rowRStart += nColsR;
            }
        }
        return rSRTr;
    }

    public boolean computeRTransByR(DenseRectMatrix matR) {
        int nCols;
        boolean result = true;
        this.nRows = nCols = matR.getNCols();
        this.mat = new double[nCols * (nCols + 1) / 2];
        int iMat = 0;
        for (int i = 0; i < nCols; ++i) {
            for (int j = 0; j <= i; ++j) {
                this.mat[iMat++] = matR.dotProductCol(i, j);
            }
        }
        return result;
    }

    public DenseSymMatrix computeRTransSR(DenseRectMatrix inpR) {
        int nRowsR = inpR.getNRows();
        int nColsR = inpR.getNCols();
        if (nRowsR != this.nRows) {
            return null;
        }
        DenseSymMatrix outS = new DenseSymMatrix(nColsR);
        double[] vInp = inpR.getMatrix();
        for (int k = 0; k < this.nRows; ++k) {
            for (int j = 0; j < nColsR; ++j) {
                double dotP = this.computeRVD(k, vInp, j, nColsR);
                for (int i = j; i < nColsR; ++i) {
                    double outVal = outS.getElem(i, j);
                    outS.setElem(i, j, outVal += inpR.getElem(k, i) * dotP);
                }
            }
        }
        return outS;
    }

    public double computeRVD(int iRow, double[] vct, int sVct, int incr) {
        double result = 0.0;
        if (iRow >= 0 && iRow < this.nRows && sVct >= 0 && sVct + (this.nRows - 1) * incr + 1 <= vct.length) {
            int i;
            int iElm = iRow * (iRow + 1) / 2;
            int index = 0;
            for (i = 0; i < iRow; ++i) {
                result += this.mat[iElm] * vct[sVct + index];
                ++iElm;
                index += incr;
            }
            for (i = iRow; i < this.nRows; ++i) {
                result += this.mat[iElm] * vct[sVct + index];
                iElm += i + 1;
                index += incr;
            }
        }
        return result;
    }

    public double computeRVD(int iRow, double[] vct) {
        return this.computeRVD(iRow, vct, 0, 1);
    }

    public boolean computeSbyS(DenseSymMatrix mOut) {
        boolean result = true;
        if (mOut.getNRows() != this.nRows) {
            result = mOut.setNRows(this.nRows);
        }
        if (result) {
            for (int i = 0; i < this.nRows; ++i) {
                for (int j = 0; j <= i; ++j) {
                    double dotp = this.computeDotProduct2Rows(i, j);
                    mOut.setElem(i, j, dotp);
                }
            }
        }
        return result;
    }

    @Override
    public boolean computeSV(double[] inpVec, double[] outVec) {
        boolean result = false;
        if (inpVec.length >= this.nRows && outVec.length >= this.nRows) {
            int iFirst = 0;
            for (int i = 0; i < this.nRows; ++i) {
                int j;
                double sum = 0.0;
                for (j = 0; j <= i; ++j) {
                    sum += this.mat[iFirst + j] * inpVec[j];
                }
                int xSym = iFirst + i;
                int shift = i + 1;
                for (j = i + 1; j < this.nRows; ++j) {
                    sum += this.mat[xSym += shift++] * inpVec[j];
                }
                iFirst += i + 1;
                outVec[i] = sum;
            }
            result = true;
        }
        return result;
    }

    @Override
    public boolean computeSV(int nRows, double[] inpVec, double[] outVec) {
        boolean result = false;
        if (inpVec.length >= nRows && outVec.length >= nRows && nRows >= 0 && nRows <= this.nRows) {
            int iFirst = 0;
            for (int i = 0; i < nRows; ++i) {
                int j;
                double sum = 0.0;
                for (j = 0; j <= i; ++j) {
                    sum += this.mat[iFirst + j] * inpVec[j];
                }
                int xSym = iFirst + i;
                int shift = i + 1;
                for (j = i + 1; j < nRows; ++j) {
                    sum += this.mat[xSym += shift++] * inpVec[j];
                }
                iFirst += i + 1;
                outVec[i] = sum;
            }
            result = true;
        }
        return result;
    }

    @Override
    public boolean computeSV(int[] vInds, double[] vVals, double[] outVec) {
        boolean result;
        int vLength = vInds.length;
        boolean bl = result = vLength == vVals.length && vInds[vLength - 1] <= this.nRows && outVec.length >= this.nRows;
        if (result) {
            int iFirst = 0;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                int index;
                int j;
                double sum = 0.0;
                int j1 = vLength;
                for (j = 0; j < vLength; ++j) {
                    index = vInds[j];
                    if (index > iRow) {
                        j1 = j;
                        break;
                    }
                    sum += this.mat[iFirst + index] * vVals[j];
                }
                for (j = j1; j < vLength; ++j) {
                    index = vInds[j];
                    int iSym = iRow + index * (index + 1) / 2;
                    sum += this.mat[iSym] * vVals[j];
                }
                iFirst += iRow + 1;
                outVec[iRow] = sum;
            }
        }
        return result;
    }

    @Override
    public double computeVSV(double[] inpVec) {
        return this.computeVSW(inpVec, inpVec);
    }

    @Override
    public double computeVSV(DenseRectMatrix matR, int iRow) {
        double result = 0.0;
        int nColsR = matR.getNCols();
        int nRowsR = matR.getNRows();
        if (nColsR == this.nRows && iRow >= 0 && iRow < nRowsR) {
            double[] rectRow = matR.getRow(iRow);
            result = this.computeVSW(rectRow, 1, rectRow, 1);
        }
        return result;
    }

    @Override
    public double computeVSV(int[] vInds, double[] vVals) {
        double result = 0.0;
        int vLen = vInds.length;
        if (vVals.length == vLen && vInds[vLen - 1] < this.nRows) {
            for (int i = 0; i < vLen; ++i) {
                double dotPrd = 0.0;
                int col = vInds[i];
                for (int j = 0; j < vLen; ++j) {
                    int jInd = vInds[j];
                    int mIndex = jInd >= col ? jInd * (jInd + 1) / 2 + col : col * (col + 1) / 2 + jInd;
                    dotPrd += vVals[j] * this.mat[mIndex];
                }
                result += dotPrd * vVals[i];
            }
        }
        return result;
    }

    @Override
    public double computeVSW(double[] vecV, double[] vecW) {
        double result = 0.0;
        if (vecV.length == this.nRows && vecW.length == this.nRows) {
            for (int i = 0; i < this.nRows; ++i) {
                double dotPrd = 0.0;
                for (int j = 0; j < this.nRows; ++j) {
                    int mIndex = j >= i ? j * (j + 1) / 2 + i : i * (i + 1) / 2 + j;
                    dotPrd += vecV[j] * this.mat[mIndex];
                }
                result += dotPrd * vecW[i];
            }
        }
        return result;
    }

    @Override
    public double computeVSW(double[] vecV, int incV, double[] vecW, int incW) {
        double result = 0.0;
        int indW = 0;
        for (int i = 0; i < this.nRows; ++i) {
            double dotPrd = 0.0;
            int indV = 0;
            for (int j = 0; j < this.nRows; ++j) {
                int mIndex = j >= i ? j * (j + 1) / 2 + i : i * (i + 1) / 2 + j;
                dotPrd += vecV[indV] * this.mat[mIndex];
                indV += incV;
            }
            result += dotPrd * vecW[indW];
            indW += incW;
        }
        return result;
    }

    @Override
    public double computeVSW(double[] matS, int nRows, int iRowV, int iRowW) {
        double result = 0.0;
        if (matS.length >= nRows * (nRows + 1) / 2 && iRowV >= 0 && iRowV < nRows && iRowW >= 0 && iRowW < nRows && nRows <= this.nRows) {
            for (int i = 0; i < nRows; ++i) {
                int mIndex1;
                double dotPrd = 0.0;
                for (int j = 0; j < nRows; ++j) {
                    mIndex1 = iRowV >= j ? iRowV * (iRowV + 1) / 2 + j : j * (j + 1) / 2 + iRowV;
                    int mIndex2 = j >= i ? j * (j + 1) / 2 + i : i * (i + 1) / 2 + j;
                    dotPrd += this.mat[mIndex1] * matS[mIndex2];
                }
                mIndex1 = iRowW >= i ? iRowW * (iRowW + 1) / 2 + i : i * (i + 1) / 2 + iRowW;
                result += dotPrd * this.mat[mIndex1];
            }
        }
        return result;
    }

    public double computeVSW(double[] vecV, int startV, int incV, double[] vecW, int startW, int incW) {
        double result = 0.0;
        int indW = 0;
        for (int i = 0; i < this.nRows; ++i) {
            double dotPrd = 0.0;
            int indV = 0;
            for (int j = 0; j < this.nRows; ++j) {
                int mIndex = j >= i ? j * (j + 1) / 2 + i : i * (i + 1) / 2 + j;
                dotPrd += vecV[startV + indV] * this.mat[mIndex];
                indV += incV;
            }
            result += dotPrd * vecW[startW + indW];
            indW += incW;
        }
        return result;
    }

    public double computeVSWParts(double[] vecV, int skipV, int nUseV, double[] vecW, int skipW, int nUseW) {
        int nV = nUseV > this.nRows ? this.nRows : nUseV;
        int nW = nUseW > this.nRows ? this.nRows : nUseW;
        double result = 0.0;
        for (int i = 0; i < nW; ++i) {
            double dotPrd = 0.0;
            for (int j = 0; j < nV; ++j) {
                dotPrd += vecV[skipV + j] * this.getElem(j, i);
            }
            result += dotPrd * vecW[skipW + i];
        }
        return result;
    }

    public double computeVSWParts(int[] vInds, double[] vVals, int skipV, int nUseV, int[] wInds, double[] wVals, int skipW, int nUseW) {
        int nV = nUseV > this.nRows ? this.nRows : nUseV;
        int nW = nUseW > this.nRows ? this.nRows : nUseW;
        double result = 0.0;
        for (int i = 0; i < wInds.length; ++i) {
            int indI = wInds[i] - skipW;
            if (indI < 0 || indI >= nW) continue;
            double dotPrd = 0.0;
            for (int j = 0; j < vInds.length; ++j) {
                int indJ = vInds[j] - skipV;
                if (indJ < 0 || indJ >= nV) continue;
                dotPrd += vVals[j] * this.getElem(indJ, indI);
            }
            result += dotPrd * wVals[i];
        }
        return result;
    }

    public boolean copyRowToRColumn(int iRow, DenseRectMatrix matR, int iColR, int nCopy) {
        boolean result;
        int nRowsR = matR.getNRows();
        int nColsR = matR.getNCols();
        boolean bl = result = iRow >= 0 && iRow < this.nRows && iColR >= 0 && iColR < nColsR;
        if (result) {
            int i;
            if (nCopy < 0) {
                nCopy = nRowsR;
            }
            if (nCopy > this.nRows) {
                nCopy = this.nRows;
            }
            int iElm = iRow * (iRow + 1) / 2;
            for (i = 0; i <= iRow && i < nCopy; ++i) {
                matR.setElem(i, iColR, this.mat[iElm++]);
            }
            int iIncr = iRow + 1;
            --iElm;
            for (i = iRow + 1; i < nCopy; ++i) {
                matR.setElem(i, iColR, this.mat[iElm += iIncr++]);
            }
        }
        return result;
    }

    public boolean copyRowToRColumn(int iRow, DenseRectMatrix matR, int iColR) {
        return this.copyRowToRColumn(iRow, matR, iColR, -1);
    }

    public boolean copyRowToRRow(int iRow, DenseRectMatrix matR, int iRowR) {
        boolean result;
        int nRowsR = matR.getNRows();
        int nColsR = matR.getNCols();
        boolean bl = result = iRow >= 0 && iRow < this.nRows && iRowR >= 0 && iRowR < nRowsR && this.nRows == nColsR;
        if (result) {
            double[] vR = matR.getMatrix();
            int iElm = iRow * (iRow + 1) / 2;
            int iR = iRowR * nColsR;
            for (int i = 0; i <= iRow; ++i) {
                vR[iR++] = this.mat[iElm++];
            }
            int iIncr = iRow + 1;
            --iElm;
            for (int i = iRow + 1; i < this.nRows; ++i) {
                vR[iR++] = this.mat[iElm += iIncr++];
            }
        }
        return result;
    }

    public boolean copyTo(DenseSymMatrix outMatrix) {
        if (outMatrix.getNRows() != this.nRows) {
            outMatrix.setNRows(this.nRows);
        }
        double[] out = outMatrix.getMatrix();
        return MathFun.dCopy(this.mat, out);
    }

    @Override
    public double getElem(int iRow, int iCol) {
        int index = iRow >= iCol ? iRow * (iRow + 1) / 2 + iCol : iCol * (iCol + 1) / 2 + iRow;
        return this.mat[index];
    }

    @Override
    public boolean getNCheckDiagonal(double[] diag, double tol) {
        boolean result;
        boolean bl = result = diag.length >= this.nRows && tol >= 0.0;
        if (result) {
            int iDiag = 0;
            double maxPos = 0.0;
            for (int i = 0; i < this.nRows; ++i) {
                double dVal = this.mat[iDiag];
                if (dVal > maxPos) {
                    maxPos = dVal;
                }
                diag[i] = dVal;
                iDiag += i + 2;
            }
            double replace = maxPos * tol;
            for (int i = 0; i < this.nRows; ++i) {
                if (!(diag[i] < replace)) continue;
                diag[i] = replace;
            }
        }
        return result;
    }

    public boolean getNCheckDiagonalOld(double[] diag, double bound, double rVal) {
        boolean result;
        boolean bl = result = diag.length >= this.nRows;
        if (result) {
            int iDiag = 0;
            for (int i = 0; i < this.nRows; ++i) {
                double dVal = this.mat[iDiag];
                if (dVal < bound) {
                    dVal = rVal;
                }
                diag[i] = dVal;
                iDiag += i + 2;
            }
        }
        return result;
    }

    @Override
    public boolean getRegCoeffs(double[] coeffs, CCBitSet swept) {
        boolean result;
        int n1 = this.nRows - 1;
        boolean bl = result = coeffs.length >= n1 && swept.size() >= n1;
        if (result) {
            int offset = n1 * (n1 + 1) / 2;
            for (int i = 0; i < n1; ++i) {
                coeffs[i] = swept.isIn(i) ? this.mat[offset + i] : 0.0;
            }
        }
        return result;
    }

    public boolean extractBelowDiag(double[] vect) {
        boolean result;
        boolean bl = result = vect.length >= this.nRows * (this.nRows - 1) / 2;
        if (result) {
            int iIn = 1;
            int iOut = 0;
            for (int i = 1; i < this.nRows; ++i) {
                for (int j = 0; j < i; ++j) {
                    vect[iOut++] = this.mat[iIn++];
                }
                ++iIn;
            }
        }
        return result;
    }

    @Override
    public DenseSymMatrix extractFirstNRows() {
        DenseSymMatrix result = new DenseSymMatrix(this.nRows - 1);
        double[] resMat = result.getMatrix();
        for (int i = 0; i < resMat.length; ++i) {
            resMat[i] = this.mat[i];
        }
        return result;
    }

    public boolean extractFirstRows(int nExtract, DenseSymMatrix mOut) {
        boolean result;
        boolean bl = result = nExtract >= 0 && nExtract <= this.nRows;
        if (result) {
            if (mOut.getNRows() != nExtract) {
                mOut.setNRows(nExtract);
            }
            double[] vOut = mOut.getMatrix();
            System.arraycopy(this.mat, 0, vOut, 0, vOut.length);
        }
        return result;
    }

    public boolean extractH(int rowFst, int rowLst, CCBitSet nRedPar, DenseRectMatrix tLMat, int[] iCol1, CCBitSet hRowSel, int nExtr) {
        int iRowHMat;
        boolean result;
        int nExtract = nExtr < 0 ? this.nRows : nExtr;
        boolean bl = result = rowFst >= 0 && rowLst >= rowFst && rowLst < this.nRows && hRowSel.size() >= this.nRows && nRedPar.size() >= this.nRows && tLMat.getNRows() >= nExtract;
        if (result) {
            int newColCount = 0;
            for (iRowHMat = rowFst; iRowHMat <= rowLst; ++iRowHMat) {
                if (!nRedPar.isIn(iRowHMat)) continue;
                ++newColCount;
            }
            if (iCol1[0] + newColCount - 1 > tLMat.getNCols()) {
                result = false;
            }
        }
        if (result) {
            int iColTLMat = iCol1[0];
            for (iRowHMat = rowFst; iRowHMat <= rowLst; ++iRowHMat) {
                if (!nRedPar.isIn(iRowHMat)) continue;
                hRowSel.set(iRowHMat, true);
                this.copyRowToRColumn(iRowHMat, tLMat, iColTLMat++, nExtract);
            }
            if (iColTLMat - iCol1[0] > 0) {
                int fstnrd = 0;
                for (int iRowTLMat = 0; iRowTLMat < this.nRows; ++iRowTLMat) {
                    if (!nRedPar.isIn(iRowTLMat)) continue;
                    tLMat.zeroOutRowPart(iRowTLMat, iCol1[0], iColTLMat - 1);
                    if (rowFst > iRowTLMat || iRowTLMat > rowLst) continue;
                    tLMat.setElem(iRowTLMat, iCol1[0] + fstnrd++, 1.0);
                }
                double clnCoeff = 10000.0 * (double)this.nRows;
                for (iRowHMat = 0; iRowHMat < iColTLMat; ++iRowHMat) {
                    tLMat.colClean(iCol1[0] + iRowHMat, clnCoeff);
                }
            }
            iCol1[0] = iColTLMat;
        }
        return result;
    }

    public boolean extractH(int rowFst, int rowLst, CCBitSet nRedPar, DenseRectMatrix tLMat, int[] iCol1, CCBitSet hRowSel) {
        return this.extractH(rowFst, rowLst, nRedPar, tLMat, iCol1, hRowSel, -1);
    }

    public boolean extractPartOfLastRow(int iStart, int nElem, double[] vec) {
        boolean result;
        boolean bl = result = iStart >= 0 && nElem > 0 && iStart + nElem <= this.nRows && vec.length >= nElem;
        if (result) {
            int iBegin = (this.nRows - 1) * this.nRows / 2 + iStart;
            for (int i = 0; i < nElem; ++i) {
                vec[i] = this.mat[iBegin + i];
            }
        }
        return result;
    }

    public double[] extractPartOfLastRow(int iStart, int nElem) {
        boolean valid;
        double[] result = null;
        boolean bl = valid = iStart >= 0 && nElem > 0 && iStart + nElem <= this.nRows;
        if (valid) {
            result = new double[nElem];
            int iBegin = (this.nRows - 1) * this.nRows / 2 + iStart;
            for (int i = 0; i < nElem; ++i) {
                result[i] = this.mat[iBegin + i];
            }
        }
        return result;
    }

    @Override
    public double[] getDiagonal() {
        double[] diag = new double[this.nRows];
        int iDiag = 0;
        for (int i = 0; i < this.nRows; ++i) {
            diag[i] = this.mat[iDiag];
            iDiag += i + 2;
        }
        return diag;
    }

    public boolean getDiagonal(double[] vDiag) {
        boolean result;
        boolean bl = result = vDiag.length >= this.nRows;
        if (result) {
            int iDiag = 0;
            for (int i = 0; i < this.nRows; ++i) {
                vDiag[i] = this.mat[iDiag];
                iDiag += i + 2;
            }
        }
        return result;
    }

    public double[] getLTNoDiag() {
        int size = this.nRows * (this.nRows - 1) / 2;
        double[] out = new double[size];
        int iOut = 0;
        int iMat = 1;
        for (int i = 1; i < this.nRows; ++i) {
            System.arraycopy(this.mat, iMat, out, iOut, i);
            iOut += i;
            iMat += i + 1;
        }
        return out;
    }

    @Override
    public double[] getMatrix() {
        return this.mat;
    }

    @Override
    public int getNCols() {
        return this.nRows;
    }

    @Override
    public int getNRows() {
        return this.nRows;
    }

    @Override
    public boolean getRow(int iRow, double[] vRow) {
        boolean result;
        boolean bl = result = iRow >= 0 && iRow < this.nRows && vRow.length >= this.nRows;
        if (result) {
            int i;
            int iElm = iRow * (iRow + 1) / 2;
            for (i = 0; i < iRow; ++i) {
                vRow[i] = this.mat[iElm++];
            }
            iElm = (iRow + 1) * (iRow + 2) / 2 - 1;
            for (i = iRow; i < this.nRows; ++i) {
                vRow[i] = this.mat[iElm];
                iElm += i + 1;
            }
        }
        return result;
    }

    public double[] getRow(int iRow) {
        boolean valid;
        double[] result = null;
        boolean bl = valid = iRow >= 0 && iRow < this.nRows;
        if (valid) {
            int i;
            result = new double[this.nRows];
            int iElm = iRow * (iRow + 1) / 2;
            for (i = 0; i < iRow; ++i) {
                result[i] = this.mat[iElm++];
            }
            iElm = (iRow + 1) * (iRow + 2) / 2 - 1;
            for (i = iRow; i < this.nRows; ++i) {
                result[i] = this.mat[iElm];
                iElm += i + 1;
            }
        }
        return result;
    }

    public boolean incrementByRTR(DenseRectMatrix mR) {
        boolean result;
        int nRRows = mR.getNRows();
        int nRCols = mR.getNCols();
        boolean bl = result = this.nRows == nRCols;
        if (result) {
            double[] vecR = mR.getMatrix();
            int iOut = 0;
            for (int i = 0; i < nRCols; ++i) {
                for (int j = 0; j <= i; ++j) {
                    double dotProd = MathFun.dDot(nRRows, vecR, i, nRCols, vecR, j, nRCols);
                    int n = iOut++;
                    this.mat[n] = this.mat[n] + dotProd;
                }
            }
        }
        return result;
    }

    public void incrementByVV(double[] vecV, int skipV, double coeff) {
        int iX = 0;
        for (int i = 0; i < this.nRows; ++i) {
            double prod = coeff * vecV[skipV + i];
            for (int j = 0; j <= i; ++j) {
                int n = iX++;
                this.mat[n] = this.mat[n] + prod * vecV[skipV + j];
            }
        }
    }

    public void incrementByVV(int[] vInds, double[] vVals, int skipV, double coeff) {
        for (int i = 0; i < vInds.length; ++i) {
            int indI = vInds[i] - skipV;
            if (indI < 0 || indI >= this.nRows) continue;
            double prod = coeff * vVals[i];
            int index = indI * (indI + 1) / 2;
            for (int j = 0; j < vInds.length; ++j) {
                int indJ = vInds[j] - skipV;
                if (indJ < 0 || indJ > indI) continue;
                int n = index + indJ;
                this.mat[n] = this.mat[n] + prod * vVals[j];
            }
        }
    }

    @Override
    public boolean incrVecByRow(int iRow, double[] vec, int iPos, int nUpd, double coeff, boolean chkPar) {
        boolean result = true;
        int vSize = vec.length;
        if (chkPar) {
            if (iRow < 0 || iRow >= this.nRows) {
                result = false;
            }
            if (nUpd <= 0 || nUpd > this.nRows) {
                result = false;
            }
            if (iPos < 0 || iPos + nUpd > vSize) {
                result = false;
            }
        }
        if (result) {
            int i;
            int iElm = iRow * (iRow + 1) / 2;
            int index = iPos;
            for (i = 0; i < iRow && i < nUpd; ++i) {
                int n = index++;
                vec[n] = vec[n] + this.mat[iElm++] * coeff;
            }
            for (i = iRow; i < this.nRows && i < nUpd; ++i) {
                int n = index++;
                vec[n] = vec[n] + this.mat[iElm] * coeff;
                iElm += i + 1;
            }
        }
        return result;
    }

    @Override
    public int lTChol(double[] diag, double tol, boolean chkArg) {
        int result = 0;
        if (chkArg) {
            if (tol < 0.0) {
                result = -1;
            }
            if (result == 0 && diag.length < this.nRows) {
                result = -1;
            }
            if (result == 0) {
                for (int k = 0; k < this.nRows; ++k) {
                    if (!(diag[k] < 0.0)) continue;
                    result = -1;
                    break;
                }
            }
        }
        if (result == 0) {
            int iDiag = 0;
            int iElm = 0;
            int iFst = 0;
            for (int i = 0; i < this.nRows; ++i) {
                double rowTol = tol * diag[i];
                int jDiag = 0;
                int jFst = 0;
                for (int j = 0; j <= i; ++j) {
                    double valOld = this.mat[iElm] - MathFun.dDot(j, this.mat, iFst, 1, this.mat, jFst, 1);
                    if (j != i) {
                        double valNew = this.mat[jDiag];
                        if (valNew != 0.0) {
                            valNew = valOld / valNew;
                        }
                        this.mat[iElm] = valNew;
                    } else {
                        if (valOld > rowTol) {
                            valOld = Math.sqrt(valOld);
                        } else {
                            valOld = 0.0;
                            ++result;
                        }
                        this.mat[iDiag] = valOld;
                    }
                    ++iElm;
                    jFst = jDiag + 1;
                    jDiag += j + 2;
                }
                iFst = iDiag + 1;
                iDiag += i + 2;
            }
        }
        return result;
    }

    @Override
    public int lTChol(double[] diag, double tol, CCBitSet nonRed, boolean chkArg) {
        int result = 0;
        if (chkArg) {
            if (tol < 0.0) {
                result = -1;
            }
            if (result == 0 && diag.length < this.nRows) {
                result = -1;
            }
            if (result == 0) {
                for (int k = 0; k < this.nRows; ++k) {
                    if (!(diag[k] < 0.0)) continue;
                    result = -1;
                    break;
                }
            }
            if (result == 0 && nonRed.size() < this.nRows) {
                result = -1;
            }
        }
        if (result == 0) {
            nonRed.clear();
            int iDiag = 0;
            int iElm = 0;
            int iFst = 0;
            for (int i = 0; i < this.nRows; ++i) {
                double rowTol = tol * diag[i];
                int jDiag = 0;
                int jFst = 0;
                for (int j = 0; j <= i; ++j) {
                    double valOld = this.mat[iElm] - MathFun.dDot(j, this.mat, iFst, 1, this.mat, jFst, 1);
                    if (j != i) {
                        double valNew = this.mat[jDiag];
                        if (valNew != 0.0) {
                            valNew = valOld / valNew;
                        }
                        this.mat[iElm] = valNew;
                    } else {
                        if (valOld > rowTol) {
                            valOld = Math.sqrt(valOld);
                            nonRed.set(i);
                        } else {
                            valOld = 0.0;
                            ++result;
                        }
                        this.mat[iDiag] = valOld;
                    }
                    ++iElm;
                    jFst = jDiag + 1;
                    jDiag += j + 2;
                }
                iFst = iDiag + 1;
                iDiag += i + 2;
            }
        }
        return result;
    }

    @Override
    public int lTChol(double tol, double diagTol, double[] minDg, boolean chkArg) {
        int result = 0;
        if (chkArg && minDg.length < 1) {
            result = -1;
        }
        if (result == 0) {
            minDg[0] = MissingValue.getMissing();
            double[] diag = new double[this.nRows];
            this.getNCheckDiagonal(diag, diagTol);
            result = this.lTChol(diag, tol, chkArg);
            if (result >= 0) {
                minDg[0] = Double.MAX_VALUE;
                int iDiag = 0;
                for (int i = 0; i < this.nRows; ++i) {
                    double diagElm = this.mat[iDiag];
                    if (diagElm > 0.0 && diagElm < minDg[0]) {
                        minDg[0] = diagElm;
                    }
                    iDiag += i + 2;
                }
                if (minDg[0] == Double.MAX_VALUE) {
                    minDg[0] = MissingValue.getMissing();
                }
            }
        }
        return result;
    }

    public int lTChol(double tol, double diagTol, double[] minDg, CCBitSet nonRed, boolean chkArg) {
        int result = 0;
        if (chkArg && nonRed.size() < this.nRows) {
            result = -1;
        }
        if (result == 0) {
            result = this.lTChol(tol, diagTol, minDg, chkArg);
            nonRed.clear();
            if (result >= 0) {
                int iDiag = 0;
                for (int i = 0; i < this.nRows; ++i) {
                    double diagElm = this.mat[iDiag];
                    if (diagElm > 0.0) {
                        nonRed.set(i);
                    }
                    iDiag += i + 2;
                }
            }
        }
        return result;
    }

    public int lTCholMinRel(double tol, double[] minRelDg, CCBitSet nonRed, boolean chkArg) {
        int result = 0;
        if (chkArg) {
            if (minRelDg.length < 1) {
                result = -1;
            } else if (nonRed.size() < this.nRows) {
                result = -1;
            }
        }
        if (result == 0) {
            double minRel = MissingValue.getMissing();
            double[] diag = new double[this.nRows];
            this.getNCheckDiagonal(diag, 1.0E-4);
            result = this.lTChol(diag, tol, chkArg);
            nonRed.clear();
            if (result >= 0) {
                minRel = Double.MAX_VALUE;
                int iDiag = 0;
                for (int i = 0; i < this.nRows; ++i) {
                    double diagElm = this.mat[iDiag];
                    if (diagElm > 0.0) {
                        nonRed.set(i);
                        minRel = Math.min(minRel, diagElm /= Math.sqrt(diag[i]));
                    }
                    iDiag += i + 2;
                }
                if (minRel == Double.MAX_VALUE) {
                    minRel = MissingValue.getMissing();
                }
            }
            minRelDg[0] = minRel;
        }
        return result;
    }

    @Override
    public int lTDetInverse(double[] det, int job) {
        int result = 0;
        int nZero = 0;
        int iDiag = 0;
        if (det.length < 2 || job != 1 && job != 10 && job != 11) {
            result = -1;
        }
        if (result == 0) {
            int i;
            for (i = 1; i <= this.nRows; ++i) {
                if (this.mat[(iDiag += i) - 1] != 0.0) continue;
                ++nZero;
            }
            if (job == 1 || job == 11) {
                if (nZero == 0) {
                    det[0] = 1.0;
                    det[1] = 0.0;
                    iDiag = 0;
                    for (i = 1; i <= this.nRows; ++i) {
                        det[0] = this.mat[(iDiag += i) - 1] * det[0];
                        while (Math.abs(det[0]) < 1.0) {
                            det[0] = det[0] * 10.0;
                            det[1] = det[1] - 1.0;
                        }
                        while (Math.abs(det[0]) >= 10.0) {
                            det[0] = det[0] / 10.0;
                            det[1] = det[1] + 1.0;
                        }
                    }
                } else {
                    det[0] = 0.0;
                    det[1] = 0.0;
                }
            }
            if (job == 10 || job == 11) {
                iDiag = this.nRows * (this.nRows + 1) / 2;
                for (i = this.nRows; i >= 1; --i) {
                    double temp = this.mat[iDiag - 1];
                    if (temp == 0.0) {
                        MathFun.iIInit(this.nRows - i + 1, 0.0, this.mat, iDiag - 1, i);
                        MathFun.lRZero(this.mat, iDiag - i, i);
                    } else {
                        this.mat[iDiag - 1] = temp = 1.0 / temp;
                        temp = -temp;
                        MathFun.iIScal(this.nRows - i, temp, this.mat, iDiag + i - 1, i + 1);
                        for (int j = 1; j <= i - 1; ++j) {
                            temp = this.mat[iDiag - i + j - 1];
                            this.mat[iDiag - i + j - 1] = 0.0;
                            MathFun.iIAxpy(this.nRows - i + 1, temp, this.mat, iDiag - 1, i, this.mat, iDiag - i + j - 1, i);
                        }
                    }
                    iDiag -= i;
                }
            }
            result = nZero;
        }
        return result;
    }

    @Override
    public boolean lTInverse() {
        double[] det = new double[2];
        int job = 10;
        int retCode = this.lTDetInverse(det, job);
        if (retCode >= 0) {
            this.lTLTransL();
        }
        return retCode >= 0;
    }

    public void lTLLTrans() {
        int iStart = 0;
        double[] vResults = new double[this.mat.length];
        int iRes = 0;
        for (int i = 0; i < this.nRows; ++i) {
            int jStart = 0;
            for (int j = 0; j <= i; ++j) {
                double product = MathFun.dDot(j + 1, this.mat, iStart, 1, this.mat, jStart, 1);
                vResults[iRes++] = product;
                jStart += j + 1;
            }
            iStart += i + 1;
        }
        MathFun.dCopy(vResults, this.mat);
    }

    @Override
    public void lTLTransL() {
        int jDiag = 0;
        for (int j = 1; j <= this.nRows; ++j) {
            int iDiag = jDiag += j;
            int ij = jDiag;
            for (int i = j; i <= this.nRows; ++i) {
                this.mat[ij - 1] = MathFun.iIDot(this.nRows - i + 1, this.mat, iDiag - 1, i, this.mat, ij - 1, i);
                ij += i;
                iDiag = iDiag + i + 1;
            }
        }
    }

    public int lTSolve(double[] vRHS, double tol, double[] vSol) {
        int result = -1;
        if (tol > 0.0 && vRHS.length >= this.nRows && vSol.length >= this.nRows) {
            this.getDiagonal(vSol);
            result = this.lTChol(vSol, tol, false);
        }
        if (result >= 0) {
            double dotp;
            int i;
            double value = this.mat[0];
            if (value != 0.0) {
                value = vRHS[0] / value;
            }
            vSol[0] = value;
            int iDiag = 0;
            int iRowStart = 0;
            for (i = 1; i < this.nRows; ++i) {
                iRowStart += i;
                value = this.mat[iDiag += i + 1];
                if (value != 0.0) {
                    dotp = MathFun.dDot(i, this.mat, iRowStart, 1, vSol, 0, 1);
                    value = (vRHS[i] - dotp) / value;
                }
                vSol[i] = value;
            }
            iDiag = this.nRows * (this.nRows + 1) / 2 - 1;
            value = this.mat[iDiag];
            if (value != 0.0) {
                value = vSol[this.nRows - 1] / value;
            }
            vSol[this.nRows - 1] = value;
            for (i = this.nRows - 2; i >= 0; --i) {
                value = this.mat[iDiag -= i + 2];
                if (value != 0.0) {
                    dotp = 0.0;
                    int iCol = iDiag;
                    for (int j = i + 1; j < this.nRows; ++j) {
                        dotp += this.mat[iCol += j] * vSol[j];
                    }
                    value = (vSol[i] - dotp) / value;
                }
                vSol[i] = value;
            }
        }
        return result;
    }

    @Override
    public int lTSubstitute(double[] vRHS, double[] vSol) {
        int result = 0;
        if (vRHS.length < this.nRows || vSol.length < this.nRows) {
            result = -1;
        }
        if (result >= 0) {
            double dotp;
            int i;
            int matIndex = 0;
            double value = this.mat[matIndex];
            if (value != 0.0) {
                value = vRHS[0] / value;
            }
            vSol[0] = value;
            for (i = 1; i < this.nRows; ++i) {
                matIndex = i * (i + 1) / 2 + i;
                value = this.mat[matIndex];
                if (value != 0.0) {
                    matIndex = i * (i + 1) / 2;
                    dotp = MathFun.dDot(i, this.mat, matIndex, 1, vSol, 0, 1);
                    value = (vRHS[i] - dotp) / value;
                }
                vSol[i] = value;
            }
            matIndex = (this.nRows - 1) * this.nRows / 2 + this.nRows - 1;
            value = this.mat[matIndex];
            if (value != 0.0) {
                value = vSol[this.nRows - 1] / value;
            }
            vSol[this.nRows - 1] = value;
            for (i = this.nRows - 2; i >= 0; --i) {
                matIndex = i * (i + 1) / 2 + i;
                value = this.mat[matIndex];
                if (value != 0.0) {
                    dotp = 0.0;
                    int col = i;
                    for (int j = i + 1; j < this.nRows; ++j) {
                        matIndex = j * (j + 1) / 2 + col;
                        dotp += this.mat[matIndex] * vSol[j];
                    }
                    value = (vSol[i] - dotp) / value;
                }
                vSol[i] = value;
            }
        }
        return result;
    }

    public boolean tSolveSubst(double[] vRHS, double[] vSol, boolean bBack) {
        boolean result;
        block8: {
            boolean bl = result = vRHS.length == this.nRows;
            if (!result) break block8;
            if (bBack) {
                for (int iRow = this.nRows - 1; iRow >= 0; --iRow) {
                    int iDiag = (iRow + 1) * (iRow + 2) / 2 - 1;
                    double diag = this.mat[iDiag];
                    if (diag == 0.0) {
                        vSol[iRow] = 0.0;
                        continue;
                    }
                    double[] dotP = new double[1];
                    boolean bRes = this.dotProdColBelowDiagBackVec(iRow, vSol, dotP);
                    if (!bRes) {
                        result = false;
                        break;
                    }
                    vSol[iRow] = (vRHS[iRow] - dotP[0]) / diag;
                }
            } else {
                for (int iRow = 0; iRow < this.nRows; ++iRow) {
                    int iDiag = (iRow + 1) * (iRow + 2) / 2 - 1;
                    double diag = this.mat[iDiag];
                    if (diag == 0.0) {
                        vSol[iRow] = 0.0;
                        continue;
                    }
                    double[] dotP = new double[1];
                    boolean bRes = this.dotProdRowBeforeDiagFrontVec(iRow, vSol, dotP);
                    if (!bRes) {
                        result = false;
                        break;
                    }
                    vSol[iRow] = (vRHS[iRow] - dotP[0]) / diag;
                }
            }
        }
        return result;
    }

    public boolean dotProdColBelowDiagBackVec(int iCol, double[] vec, double[] dotP) {
        boolean result;
        boolean bl = result = iCol >= 0 && iCol < this.nRows && vec.length == this.nRows;
        if (result) {
            dotP[0] = 0.0;
            int iSym = (iCol + 2) * (iCol + 3) / 2 - 2;
            int iVec = iCol + 1;
            int iIncr = iCol + 2;
            for (int i = iCol + 1; i < this.nRows; ++i) {
                dotP[0] = dotP[0] + this.mat[iSym] * vec[iVec++];
                iSym += iIncr++;
            }
        }
        return result;
    }

    boolean dotProdRowBeforeDiagFrontVec(int iRow, double[] vec, double[] dotP) {
        boolean result;
        boolean bl = result = iRow >= 0 && iRow < this.nRows && vec.length == this.nRows;
        if (result) {
            dotP[0] = 0.0;
            int iSym = iRow * (iRow + 1) / 2;
            int iVec = 0;
            for (int i = 0; i < iRow; ++i) {
                dotP[0] = dotP[0] + this.mat[iSym++] * vec[iVec++];
            }
        }
        return result;
    }

    public boolean makeCorr(boolean checkDiag) {
        double[] sqrtDiag = new double[this.nRows];
        int iDiag = 0;
        for (int i = 0; i < this.nRows; ++i) {
            double elem = this.mat[iDiag];
            if (checkDiag && elem <= 0.0) {
                return false;
            }
            sqrtDiag[i] = Math.sqrt(elem);
            iDiag += i + 2;
        }
        int iFst = 1;
        this.mat[0] = 1.0;
        iDiag = 2;
        for (int i = 1; i < this.nRows; ++i) {
            double si = sqrtDiag[i];
            for (int j = 0; j < i; ++j) {
                int n = iFst + j;
                this.mat[n] = this.mat[n] / (si * sqrtDiag[j]);
            }
            iFst += i + 1;
            this.mat[iDiag] = 1.0;
            iDiag += i + 2;
        }
        return true;
    }

    public boolean makeCorr(boolean checkDiag, DenseSymMatrix outMat) {
        double[] sqrtDiag = new double[this.nRows];
        int iDiag = 0;
        for (int i = 0; i < this.nRows; ++i) {
            double elem = this.mat[iDiag];
            if (checkDiag && elem <= 0.0) {
                return false;
            }
            sqrtDiag[i] = Math.sqrt(elem);
            iDiag += i + 2;
        }
        if (outMat.getNRows() != this.nRows) {
            outMat.setNRows(this.nRows);
        }
        double[] outVec = outMat.getMatrix();
        int iFst = 1;
        outVec[0] = 1.0;
        iDiag = 2;
        for (int i = 1; i < this.nRows; ++i) {
            double si = sqrtDiag[i];
            for (int j = 0; j < i; ++j) {
                outVec[iFst + j] = this.mat[iFst + j] / (si * sqrtDiag[j]);
            }
            iFst += i + 1;
            outVec[iDiag] = 1.0;
            iDiag += i + 2;
        }
        return true;
    }

    public boolean makeCorrBelowDiag(boolean checkDiag, DenseSymMatrix outMat) {
        double[] sqrtDiag = new double[this.nRows];
        int iDiag = 0;
        for (int i = 0; i < this.nRows; ++i) {
            double elem = this.mat[iDiag];
            if (checkDiag && elem <= 0.0) {
                return false;
            }
            sqrtDiag[i] = Math.sqrt(elem);
            iDiag += i + 2;
        }
        if (outMat.getNRows() != this.nRows - 1) {
            outMat.setNRows(this.nRows - 1);
        }
        double[] outVec = outMat.getMatrix();
        int iIn = 1;
        int iOut = 0;
        for (int i = 1; i < this.nRows; ++i) {
            double si = sqrtDiag[i];
            for (int j = 0; j < i; ++j) {
                outVec[iOut++] = this.mat[iIn++] / si / sqrtDiag[j];
            }
            ++iIn;
        }
        return true;
    }

    public boolean makeCorrBelowDiagChkMin(boolean checkArg, DenseSymMatrix outMat, double minCorr) {
        if (checkArg && (minCorr > 1.0 || minCorr < -1.0)) {
            return false;
        }
        double[] sqrtDiag = new double[this.nRows];
        int iDiag = 0;
        for (int i = 0; i < this.nRows; ++i) {
            double elem = this.mat[iDiag];
            if (checkArg && elem <= 0.0) {
                return false;
            }
            sqrtDiag[i] = Math.sqrt(elem);
            iDiag += i + 2;
        }
        if (outMat.getNRows() != this.nRows - 1) {
            outMat.setNRows(this.nRows - 1);
        }
        double[] outVec = outMat.getMatrix();
        int iIn = 0;
        int iOut = 0;
        for (int i = 0; i < this.nRows; ++i) {
            double si = sqrtDiag[i];
            for (int j = 0; j <= i; ++j) {
                if (j != i) {
                    double corr = this.mat[iIn] / si / sqrtDiag[j];
                    if (corr < minCorr) {
                        this.mat[iIn] = minCorr * si * sqrtDiag[j];
                        corr = minCorr;
                    }
                    outVec[iOut++] = corr;
                }
                ++iIn;
            }
        }
        return true;
    }

    @Override
    public void multiplyByNumber(double coeff) {
        int i = 0;
        while (i < this.mat.length) {
            int n = i++;
            this.mat[n] = this.mat[n] * coeff;
        }
    }

    @Override
    public boolean resize(int nRows) {
        this.nRows = nRows > 0 ? nRows : 0;
        int vLen = this.nRows * (this.nRows + 1) / 2;
        this.mat = new double[vLen];
        return true;
    }

    @Override
    public void setElem(int iRow, int iCol, double val) {
        int index = iRow >= iCol ? iRow * (iRow + 1) / 2 + iCol : iCol * (iCol + 1) / 2 + iRow;
        this.mat[index] = val;
    }

    @Override
    public boolean setNRows(int nRows) {
        this.nRows = nRows > 0 ? nRows : 0;
        int vLen = this.nRows * (this.nRows + 1) / 2;
        this.mat = new double[vLen];
        return true;
    }

    public boolean setToVV(double[] inpVec) {
        boolean result = true;
        this.nRows = inpVec.length;
        this.mat = new double[this.nRows * (this.nRows + 1) / 2];
        if (result) {
            int iVV = 0;
            for (int i = 0; i < this.nRows; ++i) {
                double val = inpVec[i];
                for (int j = 0; j <= i; ++j) {
                    this.mat[iVV++] = val * inpVec[j];
                }
            }
        }
        return result;
    }

    @Override
    public boolean sweep(int p, double tol, double[] pOrigDiag, CCBitSet swept, boolean bCheckArgs) {
        boolean bSwept;
        boolean bResult = true;
        int pLong = p;
        int nRLong = this.nRows;
        int Iii = 0;
        int Ipp = 0;
        int Iip = 0;
        int Ipj = 0;
        int i = 0;
        int j = 0;
        double App = 0.0;
        int Ii0j = 0;
        int Ii1j = 0;
        int Ii2j = 0;
        int Ii3j = 0;
        double Ai0p = 0.0;
        double Ai1p = 0.0;
        double Ai2p = 0.0;
        double Ai3p = 0.0;
        if (bCheckArgs) {
            if (p < 0 || p >= this.nRows || tol <= 0.0) {
                bResult = false;
            }
            if (bResult && swept.size() < this.nRows) {
                bResult = false;
            }
            if (bResult) {
                for (i = 0; i < nRLong; ++i) {
                    if (!(pOrigDiag[i] < 0.0)) continue;
                    bResult = false;
                }
            }
        }
        boolean bl = bSwept = bResult && swept.isIn(p);
        if (bResult) {
            Ipp = (pLong + 1) * (pLong + 2) / 2 - 1;
            App = this.mat[Ipp];
            if (!bSwept) {
                if (App <= tol * pOrigDiag[pLong]) {
                    bResult = false;
                } else {
                    Iii = 0;
                    Iip = Ipp - p;
                    i = 0;
                    while (bResult && i < nRLong) {
                        if (i > pLong) {
                            Iip += i - 1;
                        }
                        if (swept.isIn(i)) {
                            double Aip = this.mat[Iip];
                            double Bii = this.mat[Iii] - Aip * (Aip / App);
                            bResult = Bii * tol * pOrigDiag[i] > -1.0;
                        }
                        Iii += ++i + 1;
                        ++Iip;
                    }
                }
            }
        }
        if (bResult) {
            double Apj;
            double Bpp = -1.0 / App;
            double absBpp = Math.abs(Bpp);
            this.mat[Ipp] = Bpp;
            i = 0;
            Ii0j = 0;
            Ii1j = 1;
            Ii2j = 3;
            Ii3j = 6;
            Iip = Ipp - pLong;
            while (i < pLong - 3) {
                Ai0p = this.mat[Iip];
                Ai1p = this.mat[Iip + 1];
                Ai2p = this.mat[Iip + 2];
                Ai3p = this.mat[Iip + 3];
                this.mat[Iip] = absBpp * Ai0p;
                this.mat[Iip + 1] = absBpp * Ai1p;
                this.mat[Iip + 2] = absBpp * Ai2p;
                this.mat[Iip + 3] = absBpp * Ai3p;
                if (Bpp < 0.0) {
                    Ai0p = -Ai0p;
                    Ai1p = -Ai1p;
                    Ai2p = -Ai2p;
                    Ai3p = -Ai3p;
                }
                Ipj = Ipp - pLong;
                j = 0;
                while (j <= i) {
                    Apj = this.mat[Ipj];
                    int n = Ii0j++;
                    this.mat[n] = this.mat[n] + Ai0p * Apj;
                    int n2 = Ii1j++;
                    this.mat[n2] = this.mat[n2] + Ai1p * Apj;
                    int n3 = Ii2j++;
                    this.mat[n3] = this.mat[n3] + Ai2p * Apj;
                    int n4 = Ii3j++;
                    this.mat[n4] = this.mat[n4] + Ai3p * Apj;
                    ++j;
                    ++Ipj;
                }
                Apj = this.mat[Ipj];
                int n = Ii1j++;
                this.mat[n] = this.mat[n] + Ai1p * Apj;
                int n5 = Ii2j++;
                this.mat[n5] = this.mat[n5] + Ai2p * Apj;
                int n6 = Ii3j++;
                this.mat[n6] = this.mat[n6] + Ai3p * Apj;
                Apj = this.mat[++Ipj];
                int n7 = Ii2j++;
                this.mat[n7] = this.mat[n7] + Ai2p * Apj;
                int n8 = Ii3j++;
                this.mat[n8] = this.mat[n8] + Ai3p * Apj;
                Apj = this.mat[++Ipj];
                int n9 = Ii3j++;
                this.mat[n9] = this.mat[n9] + Ai3p * Apj;
                ++Ipj;
                Ii0j += 3 * (i + 1) + 6;
                Ii1j += 3 * (i + 2) + 6;
                Ii2j += 3 * (i + 3) + 6;
                Ii3j += 3 * (i + 4) + 6;
                i += 4;
                Iip += 4;
            }
            while (i < pLong) {
                Ai0p = this.mat[Iip];
                this.mat[Iip] = absBpp * Ai0p;
                if (Bpp < 0.0) {
                    Ai0p = -Ai0p;
                }
                Ipj = Ipp - pLong;
                j = 0;
                while (j <= i) {
                    Apj = this.mat[Ipj];
                    int n = Ii0j++;
                    this.mat[n] = this.mat[n] + Ai0p * Apj;
                    ++j;
                    ++Ipj;
                }
                ++i;
                ++Iip;
            }
            ++Iip;
            Iip += ++i - 1;
            Ii1j = (Ii0j += pLong + 1) + pLong + 2;
            Ii2j = Ii1j + pLong + 3;
            Ii3j = Ii2j + pLong + 4;
            while (i < nRLong - 3) {
                Ai0p = this.mat[Iip];
                Ai1p = this.mat[Iip + i + 1];
                Ai2p = this.mat[Iip + 2 * i + 3];
                Ai3p = this.mat[Iip + 3 * i + 6];
                this.mat[Iip] = absBpp * Ai0p;
                this.mat[Iip + i + 1] = absBpp * Ai1p;
                this.mat[Iip + 2 * i + 3] = absBpp * Ai2p;
                this.mat[Iip + 3 * i + 6] = absBpp * Ai3p;
                if (Bpp < 0.0) {
                    Ai0p = -Ai0p;
                    Ai1p = -Ai1p;
                    Ai2p = -Ai2p;
                    Ai3p = -Ai3p;
                }
                Ipj = Ipp - pLong;
                j = 0;
                while (j < pLong) {
                    Apj = this.mat[Ipj];
                    int n = Ii0j++;
                    this.mat[n] = this.mat[n] + Ai0p * Apj;
                    int n10 = Ii1j++;
                    this.mat[n10] = this.mat[n10] + Ai1p * Apj;
                    int n11 = Ii2j++;
                    this.mat[n11] = this.mat[n11] + Ai2p * Apj;
                    int n12 = Ii3j++;
                    this.mat[n12] = this.mat[n12] + Ai3p * Apj;
                    ++j;
                    ++Ipj;
                }
                ++j;
                ++Ipj;
                ++Ii0j;
                ++Ii1j;
                ++Ii2j;
                ++Ii3j;
                while (j <= i) {
                    Apj = this.mat[Ipj += j - 1];
                    int n = Ii0j++;
                    this.mat[n] = this.mat[n] + Ai0p * Apj;
                    int n13 = Ii1j++;
                    this.mat[n13] = this.mat[n13] + Ai1p * Apj;
                    int n14 = Ii2j++;
                    this.mat[n14] = this.mat[n14] + Ai2p * Apj;
                    int n15 = Ii3j++;
                    this.mat[n15] = this.mat[n15] + Ai3p * Apj;
                    ++j;
                    ++Ipj;
                }
                if (j != pLong) {
                    if (j > pLong) {
                        Ipj += j - 1;
                    }
                    Apj = this.mat[Ipj];
                    int n = Ii1j;
                    this.mat[n] = this.mat[n] + Ai1p * Apj;
                    int n16 = Ii2j;
                    this.mat[n16] = this.mat[n16] + Ai2p * Apj;
                    int n17 = Ii3j;
                    this.mat[n17] = this.mat[n17] + Ai3p * Apj;
                }
                ++Ipj;
                ++Ii1j;
                ++Ii2j;
                ++Ii3j;
                if (++j != pLong) {
                    if (j > pLong) {
                        Ipj += j - 1;
                    }
                    Apj = this.mat[Ipj];
                    int n = Ii2j;
                    this.mat[n] = this.mat[n] + Ai2p * Apj;
                    int n18 = Ii3j;
                    this.mat[n18] = this.mat[n18] + Ai3p * Apj;
                }
                ++Ipj;
                ++Ii2j;
                ++Ii3j;
                if (++j != pLong) {
                    if (j > pLong) {
                        Ipj += j - 1;
                    }
                    Apj = this.mat[Ipj];
                    int n = Ii3j;
                    this.mat[n] = this.mat[n] + Ai3p * Apj;
                }
                ++j;
                ++Ipj;
                ++Ii3j;
                Ii0j += 3 * (i + 1) + 6;
                Ii1j += 3 * (i + 2) + 6;
                Ii2j += 3 * (i + 3) + 6;
                Ii3j += 3 * (i + 4) + 6;
                Iip += 4 * (i += 4) - 6;
            }
            while (i < nRLong) {
                Ai0p = this.mat[Iip];
                this.mat[Iip] = absBpp * Ai0p;
                if (Bpp < 0.0) {
                    Ai0p = -Ai0p;
                }
                Ipj = Ipp - pLong;
                j = 0;
                while (j <= i) {
                    if (j != pLong) {
                        if (j > pLong) {
                            Ipj += j - 1;
                        }
                        Apj = this.mat[Ipj];
                        int n = Ii0j;
                        this.mat[n] = this.mat[n] + Ai0p * Apj;
                    }
                    ++j;
                    ++Ipj;
                    ++Ii0j;
                }
                Iip += ++i;
            }
            swept.set(p, !bSwept);
        }
        return bResult;
    }

    public boolean sweepOrig(int p, double tol, double[] vOrigDiag, CCBitSet swept, boolean bCheckArg) {
        int i;
        boolean result = true;
        double App = 0.0;
        int Ipp = 0;
        if (bCheckArg) {
            if (p < 0 || p >= this.nRows || tol <= 0.0) {
                result = false;
            }
            if (result && (vOrigDiag.length < this.nRows || swept.size() < this.nRows)) {
                result = false;
            }
            if (result) {
                for (i = 0; i < this.nRows; ++i) {
                    if (!(vOrigDiag[i] < 0.0)) continue;
                    result = false;
                }
            }
        }
        boolean pSwept = false;
        if (result) {
            pSwept = swept.isIn(p);
        }
        if (result) {
            double Aip;
            int Iip;
            Ipp = (p + 1) * (p + 2) / 2 - 1;
            App = this.mat[Ipp];
            if (!pSwept) {
                if (App <= tol * vOrigDiag[p]) {
                    result = false;
                } else {
                    int Iii = -1;
                    Iip = Ipp - p - 1;
                    for (i = 0; result && i < this.nRows; ++i) {
                        Iii += i + 1;
                        ++Iip;
                        if (i > p) {
                            Iip += i - 1;
                        }
                        if (!swept.isIn(i)) continue;
                        Aip = this.mat[Iip];
                        double Bii = this.mat[Iii] - Aip * (Aip / App);
                        result = Bii * tol * vOrigDiag[i] > -1.0;
                    }
                }
            }
            if (result) {
                int Iij = -1;
                Iip = Ipp - p - 1;
                double Bpp = -1.0 / App;
                double absBpp = Math.abs(Bpp);
                this.mat[Ipp] = Bpp;
                for (i = 0; i < this.nRows; ++i) {
                    ++Iip;
                    if (i == p) {
                        Iij += p + 1;
                        continue;
                    }
                    if (i > p) {
                        Iip += i - 1;
                    }
                    Aip = this.mat[Iip];
                    this.mat[Iip] = absBpp * Aip;
                    if (Bpp < 0.0) {
                        Aip = -Aip;
                    }
                    int Ipj = Ipp - p - 1;
                    for (int j = 0; j <= i; ++j) {
                        ++Iij;
                        ++Ipj;
                        if (j == p) continue;
                        if (j > p) {
                            Ipj += j - 1;
                        }
                        double Apj = this.mat[Ipj];
                        int n = Iij;
                        this.mat[n] = this.mat[n] + Aip * Apj;
                    }
                }
                swept.set(p, !pSwept);
            }
        }
        return result;
    }

    public boolean sweepOnMany(int nPivots, double tol, boolean bLogBefore, CCBitSet swept, double[] sumOfLogs, boolean checkArgs, double[] origDiag) {
        double[] oDiag;
        boolean result = true;
        double[] dArray = oDiag = origDiag == null ? this.getDiagonal() : origDiag;
        if (swept.size() == 0) {
            swept.resize(this.nRows);
        }
        if (checkArgs) {
            int i;
            if (nPivots <= 0 || nPivots > this.nRows || tol <= 0.0) {
                result = false;
            }
            if (result) {
                for (i = 0; result && i < this.nRows; ++i) {
                    if (!(oDiag[i] < 0.0)) continue;
                    result = false;
                }
            }
            if (result && swept.size() < nPivots) {
                result = false;
            }
            if (result) {
                for (i = 0; i < this.nRows; ++i) {
                    if (!(oDiag[i] < 1.0)) continue;
                    oDiag[i] = 1.0;
                }
            }
        }
        if (result) {
            sumOfLogs[0] = 0.0;
            swept.setRange(0, nPivots - 1, false);
            int iDiag = 0;
            for (int pivot = 0; pivot < nPivots; ++pivot) {
                double diag = 0.0;
                if (bLogBefore) {
                    diag = this.mat[iDiag];
                }
                boolean swept1 = this.sweep(pivot, tol, oDiag, swept, false);
                if (!bLogBefore) {
                    diag = -this.mat[iDiag];
                }
                if (swept1 && diag > 0.0) {
                    sumOfLogs[0] = sumOfLogs[0] + Math.log(diag);
                }
                iDiag += pivot + 2;
            }
        }
        return result;
    }

    public boolean sweepOnSelected(int[] vIndices, double tol, CCBitSet swept, boolean checkArgs, double[] origDiag) {
        int i;
        double[] oDiag;
        boolean result = true;
        double[] dArray = oDiag = origDiag == null ? this.getDiagonal() : origDiag;
        if (swept.size() == 0) {
            swept.resize(this.nRows);
        }
        if (checkArgs) {
            for (i = 0; result && i < this.nRows; ++i) {
                if (!(oDiag[i] < 0.0)) continue;
                result = false;
            }
            if (result && swept.size() < this.nRows) {
                result = false;
            }
            if (result) {
                for (i = 0; result && i < vIndices.length; ++i) {
                    int pivot = vIndices[i];
                    if (pivot >= 0 && pivot < this.nRows) continue;
                    result = false;
                }
            }
            if (result) {
                for (i = 0; i < this.nRows; ++i) {
                    if (!(oDiag[i] < 1.0)) continue;
                    oDiag[i] = 1.0;
                }
            }
        }
        if (result) {
            for (i = 0; i < vIndices.length; ++i) {
                this.sweep(vIndices[i], tol, oDiag, swept, false);
            }
        }
        return result;
    }

    public String toString() {
        return "DenseSymMatrix [mat=" + Arrays.toString(this.mat) + ", nRows=" + this.nRows + "]";
    }

    public boolean updateByOuterSquare(double[] vector) {
        boolean result;
        boolean bl = result = vector.length >= this.nRows;
        if (result) {
            int iOut = 0;
            for (int i = 0; i < this.nRows; ++i) {
                double elemI = vector[i];
                for (int j = 0; j <= i; ++j) {
                    int n = iOut++;
                    this.mat[n] = this.mat[n] + elemI * vector[j];
                }
            }
        }
        return result;
    }

    @Override
    public boolean updateXX(double[] oCase, double weight) {
        boolean result = false;
        if (oCase.length == this.nRows && weight > 0.0) {
            int iMat = 0;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                if (oCase[iRow] == 0.0) {
                    iMat += iRow + 1;
                    continue;
                }
                double case1 = oCase[iRow] * weight;
                for (int iCol = 0; iCol <= iRow; ++iCol) {
                    int n = iMat++;
                    this.mat[n] = this.mat[n] + case1 * oCase[iCol];
                }
            }
            result = true;
        }
        return result;
    }

    public boolean updateXXMat2(DenseRectMatrix mat1, DenseRectMatrix mat2, double weight) {
        boolean result = false;
        int nCol1 = mat1.getNCols();
        int nCol2 = mat2.getNCols();
        int nRow1 = mat1.getNRows();
        int nRow2 = mat2.getNRows();
        if (nCol1 + nCol2 == this.nRows && nRow1 == nRow2 && weight > 0.0) {
            int j;
            int i;
            int iMat = 0;
            for (i = 0; i < nCol1; ++i) {
                for (j = 0; j <= i; ++j) {
                    int n = iMat++;
                    this.mat[n] = this.mat[n] + mat1.dotProductCol(i, j) * weight;
                }
            }
            for (i = 0; i < nCol2; ++i) {
                for (j = 0; j < nCol1; ++j) {
                    int n = iMat++;
                    this.mat[n] = this.mat[n] + mat2.dotProductColCol(i, mat1, j) * weight;
                }
                for (j = 0; j <= i; ++j) {
                    int n = iMat++;
                    this.mat[n] = this.mat[n] + mat2.dotProductCol(i, j) * weight;
                }
            }
            result = true;
        }
        return result;
    }

    public boolean updateXXMat2(DenseRectMatrix mat1, DenseRectMatrix mat2) {
        return this.updateXXMat2(mat1, mat2, 1.0);
    }

    public boolean updateXXNonRedun(double[] oCase, CCBitSet redunInfo, double weight) {
        boolean result;
        boolean bl = result = oCase.length == this.nRows;
        if (result) {
            int iMat = 0;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                if (oCase[iRow] == 0.0 || !redunInfo.isIn(iRow)) {
                    iMat += iRow + 1;
                    continue;
                }
                double case1 = oCase[iRow] * weight;
                for (int iCol = 0; iCol <= iRow; ++iCol) {
                    if (redunInfo.isIn(iCol)) {
                        int n = iMat;
                        this.mat[n] = this.mat[n] + case1 * oCase[iCol];
                    }
                    ++iMat;
                }
            }
        }
        return result;
    }

    public boolean updateXXNonRedun(double[] oCase, CCBitSet redunInfo) {
        return this.updateXXNonRedun(oCase, redunInfo, 1.0);
    }

    public boolean updateXXPosNegW(double[] oCase, double weight) {
        boolean result;
        boolean bl = result = oCase.length == this.nRows;
        if (result) {
            int iMat = 0;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                if (oCase[iRow] == 0.0) {
                    iMat += iRow + 1;
                    continue;
                }
                double case1 = oCase[iRow] * weight;
                for (int iCol = 0; iCol <= iRow; ++iCol) {
                    int n = iMat++;
                    this.mat[n] = this.mat[n] + case1 * oCase[iCol];
                }
            }
        }
        return result;
    }

    public boolean updateXXPosNegW(double[] oCase) {
        return this.updateXXPosNegW(oCase, 1.0);
    }

    public boolean updateXXSparse(int nUse, int[] iCase, double[] vCase, double weight) {
        boolean result = true;
        if (result) {
            for (int i1 = 0; i1 < nUse; ++i1) {
                int iRow = iCase[i1];
                int iFst = iRow * (iRow + 1) / 2;
                double value1 = vCase[i1] * weight;
                for (int i2 = 0; i2 <= i1; ++i2) {
                    int iCol = iCase[i2];
                    int n = iFst + iCol;
                    this.mat[n] = this.mat[n] + value1 * vCase[i2];
                }
            }
        }
        return result;
    }

    public boolean updateXXSparse(int nUse, int[] iCase, double[] vCase) {
        return this.updateXXSparse(nUse, iCase, vCase, 1.0);
    }

    public boolean updateXXSparseNonRedun(int nUse, int[] iCase, double[] vCase, CCBitSet redunInfo, double weight) {
        boolean result = true;
        if (result) {
            for (int iRow = 0; iRow < nUse; ++iRow) {
                int iInd = iCase[iRow];
                if (vCase[iRow] == 0.0 || !redunInfo.isIn(iInd)) continue;
                int iFst = iInd * (iInd + 1) / 2;
                double value = vCase[iRow] * weight;
                for (int iCol = 0; iCol <= iRow; ++iCol) {
                    int jInd = iCase[iCol];
                    if (!redunInfo.isIn(jInd)) continue;
                    int n = iFst + jInd;
                    this.mat[n] = this.mat[n] + value * vCase[iCol];
                }
            }
        }
        return result;
    }

    @Override
    public boolean zeroOut(int iRow) {
        boolean result = false;
        if (iRow >= 0 && iRow < this.nRows) {
            int i;
            int iElm = iRow * (iRow + 1) / 2;
            for (i = 0; i <= iRow; ++i) {
                this.mat[iElm++] = 0.0;
            }
            int iIncr = iRow + 1;
            --iElm;
            for (i = iRow + 1; i < this.nRows; ++i) {
                this.mat[iElm += iIncr++] = 0.0;
            }
            result = true;
        }
        return result;
    }

    public void zeroOutAllSmall(double tol) {
        if (tol > 0.0) {
            int iDiag = 0;
            double md = 0.0;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                double aDiag = Math.abs(this.mat[iDiag]);
                if (aDiag > md) {
                    md = aDiag;
                }
                iDiag += iRow + 2;
            }
            double comp = md * tol;
            if (comp > 0.0) {
                for (int i = 0; i < this.mat.length; ++i) {
                    if (!(Math.abs(this.mat[i]) < comp)) continue;
                    this.mat[i] = 0.0;
                }
            }
        }
    }

    @Override
    public boolean zeroOutRedundant(CCBitSet inModel) {
        boolean result = true;
        if (inModel.size() < this.nRows) {
            result = false;
        } else if (this.nRows > 0) {
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                if (inModel.isIn(iRow)) continue;
                this.zeroOut(iRow);
            }
        }
        return result;
    }

    @Override
    public void zeroOutNonDiag(double tol) {
        if (tol > 0.0) {
            int iElm = 0;
            int iDiag1 = 0;
            for (int iRow = 0; iRow < this.nRows; ++iRow) {
                double diag1 = Math.abs(this.mat[iDiag1]);
                int iDiag2 = 0;
                for (int iCol = 0; iCol <= iRow; ++iCol) {
                    if (iRow != iCol) {
                        double diag2 = Math.abs(this.mat[iDiag2]);
                        if (Math.abs(this.mat[iElm]) <= tol * Math.sqrt(diag1 * diag2)) {
                            this.mat[iElm] = 0.0;
                        }
                    }
                    ++iElm;
                    iDiag2 += iCol + 2;
                }
                iDiag1 += iRow + 2;
            }
        }
    }

    public boolean replaceDiagZeroes(double tol) {
        double dElem;
        int i;
        boolean result = tol >= 0.0;
        double dMax = 0.0;
        int iDiag = 0;
        if (result) {
            for (i = 0; i < this.nRows; ++i) {
                dElem = this.mat[iDiag];
                if (dElem > dMax) {
                    dMax = dElem;
                }
                iDiag += i + 2;
            }
            boolean bl = result = dMax > 0.0;
        }
        if (result) {
            iDiag = 0;
            for (i = 0; i < this.nRows; ++i) {
                dElem = this.mat[iDiag];
                if (dElem <= 0.0 || dElem / dMax <= tol) {
                    this.mat[iDiag] = dMax;
                }
                iDiag += i + 2;
            }
        }
        return result;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nRows);
        dataOutput.writeInt(this.mat.length);
        for (int i = 0; i < this.mat.length; ++i) {
            dataOutput.writeDouble(this.mat[i]);
        }
    }

    public Object readObject(DataInput dataInput) throws IOException {
        this.nRows = dataInput.readInt();
        int matLen = dataInput.readInt();
        this.mat = new double[matLen];
        for (int i = 0; i < this.mat.length; ++i) {
            this.mat[i] = dataInput.readDouble();
        }
        return this;
    }
}

