/*
 * Decompiled with CFR 0.152.
 */
package com.spss.math.matrix;

import com.spss.math.matrix.DenseSymMatrix;
import com.spss.math.statistics.MathFun;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class DenseSymSquareMatrix
implements Cloneable {
    private int nRows = 0;
    private double[] mat = null;

    public DenseSymSquareMatrix() {
    }

    public DenseSymSquareMatrix(int nRows) {
        this.nRows = nRows >= 0 ? nRows : 0;
        this.mat = new double[this.nRows * this.nRows];
    }

    public DenseSymSquareMatrix(DenseSymMatrix srcMat) {
        this.nRows = srcMat.getNRows();
        this.mat = new double[this.nRows * this.nRows];
        double[] vSrc = srcMat.getMatrix();
        int iMat = 0;
        for (int c = 0; c < this.nRows; ++c) {
            for (int r = 0; r < this.nRows; ++r) {
                int iSrc = c > r ? c * (c + 1) / 2 + r : r * (r + 1) / 2 + c;
                this.mat[iMat++] = vSrc[iSrc];
            }
        }
    }

    public DenseSymSquareMatrix(DenseSymSquareMatrix srcMat) {
        this.nRows = srcMat.nRows;
        this.mat = Arrays.copyOf(srcMat.mat, srcMat.mat.length);
    }

    public boolean copyTo(DenseSymSquareMatrix outMatrix) {
        if (outMatrix.getNRows() != this.nRows) {
            outMatrix.setNRows(this.nRows);
        }
        double[] out = outMatrix.getMatrix();
        return MathFun.dCopy(this.mat, out);
    }

    public double getElem(int iRow, int iCol) {
        return this.mat[iRow * this.nRows + iCol];
    }

    public double[] getMatrix() {
        return this.mat;
    }

    public int getNCols() {
        return this.nRows;
    }

    public int getNRows() {
        return this.nRows;
    }

    public void setElem(int iRow, int iCol, double val) {
        this.mat[iRow * this.nRows + iCol] = val;
        this.mat[iCol * this.nRows + iRow] = val;
    }

    public void setMat(double[] mat) {
        if (mat.length == this.nRows * this.nRows) {
            this.mat = mat;
        }
    }

    public boolean setNRows(int nRows) {
        this.nRows = nRows > 0 ? nRows : 0;
        this.mat = new double[this.nRows * this.nRows];
        return true;
    }

    public double computeVSW(double[] vecV, int startV, int incV, double[] vecW, int startW, int incW) {
        double result = 0.0;
        int indW = 0;
        for (int j = 0; j < this.nRows; ++j) {
            double dotPrd = 0.0;
            int indV = 0;
            for (int i = 0; i < this.nRows; ++i) {
                dotPrd += vecV[startV + indV] * this.mat[j * this.nRows + i];
                indV += incV;
            }
            result += dotPrd * vecW[startW + indW];
            indW += incW;
        }
        return result;
    }

    public double computeVSV(int[] vInds, double[] vVals) {
        double result = 0.0;
        int vLen = vInds.length;
        if (vVals.length == vLen && vInds[vLen - 1] < this.nRows) {
            for (int i = 0; i < vLen; ++i) {
                double dotPrd = 0.0;
                int col = vInds[i];
                for (int j = 0; j < vLen; ++j) {
                    int jInd = vInds[j];
                    dotPrd += vVals[j] * this.mat[col * this.nRows + jInd];
                }
                result += dotPrd * vVals[i];
            }
        }
        return result;
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.nRows);
        dataOutput.writeInt(this.mat.length);
        for (int i = 0; i < this.mat.length; ++i) {
            dataOutput.writeDouble(this.mat[i]);
        }
    }

    public Object readObject(DataInput dataInput) throws IOException {
        this.nRows = dataInput.readInt();
        int matLen = dataInput.readInt();
        this.mat = new double[matLen];
        for (int i = 0; i < this.mat.length; ++i) {
            this.mat[i] = dataInput.readDouble();
        }
        return this;
    }

    public String toString() {
        return "DenseSymSquareMatrix [mat=" + Arrays.toString(this.mat) + ", nRows=" + this.nRows + "]";
    }
}

